/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class CommitStatistics
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int addedLines;
    private final int deletedLines;
    private final int authorCount;
    private final int commitCount;
    private final int filesCount;

    public CommitStatistics(Collection<? extends CommitDiffItem> commits) {
        this.addedLines = CommitStatistics.countAddedLines(commits);
        this.deletedLines = CommitStatistics.countDeletedLines(commits);
        this.authorCount = CommitStatistics.countAuthors(commits);
        this.commitCount = CommitStatistics.countCommits(commits);
        this.filesCount = (int)commits.stream().map(CommitDiffItem::getNewPath).distinct().filter(name -> !"/dev/null".equals(name)).count();
    }

    public CommitStatistics() {
        this(Collections.emptyList());
    }

    @Deprecated
    CommitStatistics(int numberOfCommits, int numberOfAuthors) {
        this.commitCount = numberOfCommits;
        this.authorCount = numberOfAuthors;
        this.addedLines = 0;
        this.deletedLines = 0;
        this.filesCount = 0;
    }

    public int getAddedLines() {
        return this.addedLines;
    }

    public int getDeletedLines() {
        return this.deletedLines;
    }

    public int getLinesOfCode() {
        return this.addedLines - this.deletedLines;
    }

    public int getAbsoluteChurn() {
        return this.addedLines + this.deletedLines;
    }

    public int getAuthorCount() {
        return this.authorCount;
    }

    public int getCommitCount() {
        return this.commitCount;
    }

    public int getFilesCount() {
        return this.filesCount;
    }

    @Generated
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitStatistics that = (CommitStatistics)o;
        return this.addedLines == that.addedLines && this.deletedLines == that.deletedLines && this.authorCount == that.authorCount && this.commitCount == that.commitCount && this.filesCount == that.filesCount;
    }

    @Generated
    public int hashCode() {
        return Objects.hash(this.addedLines, this.deletedLines, this.authorCount, this.commitCount, this.filesCount);
    }

    @Generated
    public String toString() {
        return new StringJoiner(", ", CommitStatistics.class.getSimpleName() + "[", "]").add("addedLines=" + this.addedLines).add("deletedLines=" + this.deletedLines).add("authorCount=" + this.authorCount).add("commitCount=" + this.commitCount).add("filesCount=" + this.filesCount).toString();
    }

    private static int getDistinctCount(Collection<? extends CommitDiffItem> commits, Function<CommitDiffItem, String> property) {
        return (int)commits.stream().map(property).map(s -> s.toLowerCase(Locale.ENGLISH)).distinct().count();
    }

    private static int count(Collection<? extends CommitDiffItem> commits, ToIntFunction<CommitDiffItem> property) {
        return commits.stream().mapToInt(property).sum();
    }

    public static int countMoves(Collection<? extends CommitDiffItem> commits) {
        return (int)commits.stream().filter(CommitDiffItem::isMove).count();
    }

    public static int countDeletes(Collection<? extends CommitDiffItem> commits) {
        return (int)commits.stream().filter(CommitDiffItem::isDelete).count();
    }

    public static int countChanges(Collection<? extends CommitDiffItem> commits) {
        return (int)commits.stream().filter(commit -> !commit.hasOldPath()).count();
    }

    private static int countAddedLines(Collection<? extends CommitDiffItem> commits) {
        return CommitStatistics.count(commits, CommitDiffItem::getTotalAddedLines);
    }

    private static int countDeletedLines(Collection<? extends CommitDiffItem> commits) {
        return CommitStatistics.count(commits, CommitDiffItem::getTotalDeletedLines);
    }

    private static int countAuthors(Collection<? extends CommitDiffItem> commits) {
        return CommitStatistics.getDistinctCount(commits, CommitDiffItem::getAuthor);
    }

    private static int countCommits(Collection<? extends CommitDiffItem> commits) {
        return CommitStatistics.getDistinctCount(commits, CommitDiffItem::getId);
    }

    public static void logCommits(List<CommitDiffItem> commits, FilteredLog logger) {
        logger.logInfo("-> %d commits with differences analyzed", new Object[]{CommitStatistics.countCommits(commits)});
        CommitStatistics.logIfPositive(CommitStatistics.countChanges(commits), "-> %d MODIFY commit diff items", logger);
        CommitStatistics.logIfPositive(CommitStatistics.countMoves(commits), "-> %d RENAME commit diff items", logger);
        CommitStatistics.logIfPositive(CommitStatistics.countDeletes(commits), "-> %d DELETE commit diff items", logger);
        logger.logInfo("-> %d lines added", new Object[]{CommitStatistics.countAddedLines(commits)});
        logger.logInfo("-> %d lines deleted", new Object[]{CommitStatistics.countDeletedLines(commits)});
    }

    private static void logIfPositive(int total, String message, FilteredLog logger) {
        if (total > 0) {
            logger.logInfo(message, new Object[]{total});
        }
    }
}

