/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.delta;

import edu.hm.hafner.util.FilteredLog;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import io.jenkins.plugins.forensics.delta.DeltaCalculator;
import io.jenkins.plugins.forensics.util.ScmResolver;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public abstract class DeltaCalculatorFactory
implements ExtensionPoint {
    public static DeltaCalculator findDeltaCalculator(Run<?, ?> run, Collection<FilePath> scmDirectories, TaskListener listener, FilteredLog logger) {
        return scmDirectories.stream().map(directory -> DeltaCalculatorFactory.findDeltaCalculator(run, directory, listener, logger)).flatMap(Optional::stream).findFirst().orElseGet(() -> DeltaCalculatorFactory.createNullDeltaCalculator(logger));
    }

    public static DeltaCalculator findDeltaCalculator(String scm, Run<?, ?> run, FilePath workTree, TaskListener listener, FilteredLog logger) {
        Collection<? extends SCM> scms = new ScmResolver().getScms(run, scm);
        if (scms.isEmpty()) {
            logger.logInfo("-> no SCMs found to be processed");
            return new DeltaCalculator.NullDeltaCalculator();
        }
        return DeltaCalculatorFactory.findAllDeltaCalculatorFactoryInstances().stream().map(deltaCalculatorFactory -> deltaCalculatorFactory.createDeltaCalculator((SCM)scms.iterator().next(), run, workTree, listener, logger)).flatMap(Optional::stream).findFirst().orElseGet(() -> DeltaCalculatorFactory.createNullDeltaCalculator(logger));
    }

    private static Optional<DeltaCalculator> findDeltaCalculator(Run<?, ?> run, FilePath workTree, TaskListener listener, FilteredLog logger) {
        SCM scm = new ScmResolver().getScm(run);
        return DeltaCalculatorFactory.findAllDeltaCalculatorFactoryInstances().stream().map(deltaCalculatorFactory -> deltaCalculatorFactory.createDeltaCalculator(scm, run, workTree, listener, logger)).flatMap(Optional::stream).findFirst();
    }

    private static DeltaCalculator createNullDeltaCalculator(FilteredLog logger) {
        if (DeltaCalculatorFactory.findAllDeltaCalculatorFactoryInstances().isEmpty()) {
            logger.logInfo("-> No delta calculator installed yet. You need to install the 'git-forensics' plugin to enable it for Git.");
        } else {
            logger.logInfo("-> No suitable delta calculator found.");
        }
        return new DeltaCalculator.NullDeltaCalculator();
    }

    private static List<DeltaCalculatorFactory> findAllDeltaCalculatorFactoryInstances() {
        return new JenkinsFacade().getExtensionsFor(DeltaCalculatorFactory.class);
    }

    public abstract Optional<DeltaCalculator> createDeltaCalculator(SCM var1, Run<?, ?> var2, FilePath var3, TaskListener var4, FilteredLog var5);
}

