/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.reference;

import edu.hm.hafner.util.FilteredLog;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.AccessControlled;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.ComboBoxModel;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.forensics.reference.Messages;
import io.jenkins.plugins.forensics.reference.ReferenceBuild;
import io.jenkins.plugins.forensics.reference.ReferenceJobModelValidation;
import io.jenkins.plugins.util.JenkinsFacade;
import io.jenkins.plugins.util.LogHandler;
import java.util.List;
import java.util.Optional;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SimpleReferenceRecorder
extends Recorder
implements SimpleBuildStep {
    private final JenkinsFacade jenkins;
    private String referenceJob = "";
    private Result requiredResult = Result.UNSTABLE;
    private boolean considerRunningBuild;

    @DataBoundConstructor
    public SimpleReferenceRecorder() {
        this(new JenkinsFacade());
    }

    @VisibleForTesting
    protected SimpleReferenceRecorder(JenkinsFacade jenkins) {
        this.jenkins = jenkins;
    }

    protected Object readResolve() {
        if (this.requiredResult == null) {
            this.requiredResult = Result.UNSTABLE;
        }
        return this;
    }

    @DataBoundSetter
    public void setReferenceJob(String referenceJob) {
        this.referenceJob = StringUtils.strip((String)referenceJob);
    }

    public String getReferenceJob() {
        return this.referenceJob;
    }

    @DataBoundSetter
    public void setRequiredBuildResult(String requiredBuildResult) {
        this.requiredResult = Result.fromString((String)requiredBuildResult);
    }

    public String getRequiredBuildResult() {
        return this.requiredResult != null ? this.requiredResult.toString() : "";
    }

    @DataBoundSetter
    public void setRequiredResult(Result requiredResult) {
        this.requiredResult = requiredResult;
    }

    public Result getRequiredResult() {
        return this.requiredResult;
    }

    protected boolean hasRequiredResult(Run<?, ?> referenceBuild) {
        Result result = referenceBuild.getResult();
        return result != null && result.isBetterOrEqualTo(this.requiredResult);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public SimpleReferenceRecorderDescriptor getDescriptor() {
        return (SimpleReferenceRecorderDescriptor)super.getDescriptor();
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) {
        FilteredLog log = new FilteredLog("Errors while computing the reference build:");
        boolean existing = run.removeActions(ReferenceBuild.class);
        if (existing) {
            log.logError("Replaced existing reference build, this typically indicates a misconfiguration as the reference should be constant");
        }
        run.addAction((Action)this.findReferenceBuild(run, log));
        LogHandler logHandler = new LogHandler(listener, "ReferenceFinder");
        logHandler.log(log);
    }

    @DataBoundSetter
    public void setConsiderRunningBuild(boolean considerRunningBuild) {
        this.considerRunningBuild = considerRunningBuild;
    }

    public boolean isConsiderRunningBuild() {
        return this.considerRunningBuild;
    }

    protected ReferenceBuild findReferenceBuild(Run<?, ?> run, FilteredLog log) {
        Job reference = this.resolveReferenceJob(log).orElseGet(() -> this.fallBackToCurrentJob(run, log));
        Optional<Run<?, ?>> possibleLastCompletedBuild = this.getLastBuild(reference);
        if (possibleLastCompletedBuild.isEmpty()) {
            this.logNoBuildFound(reference, log);
            return this.createEmptyReferenceBuild(run, log);
        }
        Run<?, ?> lastBuild = possibleLastCompletedBuild.get();
        log.logInfo("Found last completed build '%s' of reference job '%s'", new Object[]{lastBuild.getDisplayName(), reference.getDisplayName()});
        return this.getReferenceBuildWithRequiredStatus(run, lastBuild, log).orElse(this.createEmptyReferenceBuild(run, log));
    }

    protected void logNoBuildFound(Job<?, ?> reference, FilteredLog log) {
        if (this.isConsiderRunningBuild()) {
            log.logInfo("No build found for reference job '%s'", new Object[]{reference.getDisplayName()});
        } else {
            log.logInfo("No completed build found for reference job '%s'", new Object[]{reference.getDisplayName()});
        }
    }

    protected Optional<ReferenceBuild> getReferenceBuildWithRequiredStatus(Run<?, ?> run, Run<?, ?> start, FilteredLog log) {
        for (Run reference = start; reference != null; reference = reference.getPreviousCompletedBuild()) {
            if (!this.hasRequiredResult(reference)) continue;
            log.logInfo("-> %s '%s' has a result %s", new Object[]{this.getBuildName(start, reference), reference.getDisplayName(), reference.getResult()});
            return Optional.of(new ReferenceBuild(run, (List<String>)log.getInfoMessages(), this.requiredResult, reference));
        }
        log.logInfo("-> ignoring reference build '%s' or one of its predecessors since none have a result of %s or better", new Object[]{start.getDisplayName(), this.requiredResult});
        return Optional.empty();
    }

    private String getBuildName(Run<?, ?> start, Run<?, ?> reference) {
        return reference == start ? "Build" : "Previous build";
    }

    private Job<?, ?> fallBackToCurrentJob(Run<?, ?> run, FilteredLog log) {
        Job parent = run.getParent();
        log.logInfo("Falling back to current job '%s'", new Object[]{parent.getDisplayName()});
        return parent;
    }

    protected ReferenceBuild createEmptyReferenceBuild(Run<?, ?> run, FilteredLog messages) {
        return new ReferenceBuild(run, (List<String>)messages.getInfoMessages(), this.requiredResult);
    }

    protected Optional<Job<?, ?>> resolveReferenceJob(FilteredLog log) {
        String jobName = this.getReferenceJob();
        if (this.isValidJobName(jobName)) {
            log.logInfo("Configured reference job: '%s'", new Object[]{jobName});
            return this.findJob(jobName, log);
        }
        log.logInfo("No reference job configured");
        return Optional.empty();
    }

    protected Optional<Job<?, ?>> findJob(String jobName, FilteredLog log) {
        Optional job = this.jenkins.getJob(jobName);
        if (job.isEmpty()) {
            log.logInfo("There is no such job - maybe the job has been renamed or deleted?");
        }
        return job;
    }

    private boolean isValidJobName(String name) {
        return StringUtils.isNotBlank((CharSequence)name);
    }

    protected Optional<Run<?, ?>> getLastBuild(Job<?, ?> reference) {
        if (this.isConsiderRunningBuild()) {
            return Optional.ofNullable(reference.getLastBuild());
        }
        return Optional.ofNullable(reference.getLastCompletedBuild());
    }

    @Extension
    @Symbol(value={"discoverReferenceBuild"})
    public static class SimpleReferenceRecorderDescriptor
    extends BuildStepDescriptor<Publisher> {
        private final JenkinsFacade jenkins;
        private final ReferenceJobModelValidation model;

        public SimpleReferenceRecorderDescriptor() {
            this(new JenkinsFacade(), new ReferenceJobModelValidation());
        }

        @VisibleForTesting
        protected SimpleReferenceRecorderDescriptor(JenkinsFacade jenkins) {
            this(jenkins, new ReferenceJobModelValidation(jenkins));
        }

        @VisibleForTesting
        SimpleReferenceRecorderDescriptor(JenkinsFacade jenkins, ReferenceJobModelValidation model) {
            this.jenkins = jenkins;
            this.model = model;
        }

        @NonNull
        public String getDisplayName() {
            return Messages.Recorder_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        @POST
        public ComboBoxModel doFillReferenceJobItems(@AncestorInPath BuildableItem project) {
            if (this.jenkins.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return this.model.getAllJobs();
            }
            return new ComboBoxModel();
        }

        @POST
        public FormValidation doCheckReferenceJob(@AncestorInPath BuildableItem project, @QueryParameter String referenceJob) {
            if (!this.jenkins.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                return FormValidation.ok();
            }
            return this.model.validateJob(referenceJob);
        }

        @POST
        public ListBoxModel doFillRequiredResultItems(@AncestorInPath BuildableItem project) {
            ListBoxModel resultModel = new ListBoxModel();
            if (this.jenkins.hasPermission(Item.CONFIGURE, (AccessControlled)project)) {
                resultModel.add(Messages.RequiredResult_Failure(), Result.FAILURE.toString());
                resultModel.add(Messages.RequiredResult_Unstable(), Result.UNSTABLE.toString());
                resultModel.add(Messages.RequiredResult_Success(), Result.SUCCESS.toString());
            }
            return resultModel;
        }
    }
}

