/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.forensics.miner.CommitDiffItem;
import io.jenkins.plugins.forensics.miner.CommitStatistics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public final class FileStatistics
implements Serializable {
    private static final long serialVersionUID = 8L;
    private TreeString fileName;
    private int creationTime;
    private int lastModificationTime;
    private transient int numberOfAuthors;
    private transient int numberOfCommits;
    private CommitStatistics statistics = new CommitStatistics();
    private List<CommitDiffItem> commits = new ArrayList<CommitDiffItem>();

    private FileStatistics(TreeString fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName.toString();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="Deserialization of instances that do not have all fields yet")
    private Object readResolve() {
        if (this.commits == null) {
            this.commits = new ArrayList<CommitDiffItem>();
            this.statistics = new CommitStatistics(this.numberOfCommits, this.numberOfAuthors);
        }
        return this;
    }

    public List<CommitDiffItem> getCommits() {
        return this.commits;
    }

    public int getNumberOfAuthors() {
        return this.statistics.getAuthorCount();
    }

    public int getNumberOfCommits() {
        return this.statistics.getCommitCount();
    }

    public int getCreationTime() {
        return this.creationTime;
    }

    public int getLastModificationTime() {
        return this.lastModificationTime;
    }

    public int getLinesOfCode() {
        return this.statistics.getLinesOfCode();
    }

    public int getAbsoluteChurn() {
        return this.statistics.getAbsoluteChurn();
    }

    public void inspectCommit(CommitDiffItem additionalCommit) {
        this.commits.add(additionalCommit);
        this.updateProperties();
    }

    public void inspectCommits(Collection<CommitDiffItem> additionalCommits) {
        this.commits.addAll(additionalCommits);
        this.updateProperties();
    }

    private void updateProperties() {
        int lastCommit = this.commits.size() - 1;
        this.lastModificationTime = this.commits.get(lastCommit).getTime();
        this.creationTime = this.commits.get(0).getTime();
        this.statistics = new CommitStatistics(this.commits);
        this.fileName = TreeString.valueOf((String)this.commits.get(lastCommit).getNewPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileStatistics that = (FileStatistics)o;
        return this.creationTime == that.creationTime && this.lastModificationTime == that.lastModificationTime && Objects.equals(this.fileName, that.fileName) && Objects.equals(this.statistics, that.statistics) && Objects.equals(this.commits, that.commits);
    }

    public int hashCode() {
        return Objects.hash(this.fileName, this.creationTime, this.lastModificationTime, this.statistics, this.commits);
    }

    public String toString() {
        return new StringJoiner(", ", FileStatistics.class.getSimpleName() + "[", "]").add("fileName=" + String.valueOf(this.fileName)).add("creationTime=" + this.creationTime).add("lastModificationTime=" + this.lastModificationTime).add("statistics=" + String.valueOf(this.statistics)).toString();
    }

    public static class FileStatisticsBuilder {
        private final TreeStringBuilder builder = new TreeStringBuilder();
        private final PathUtil pathUtil = new PathUtil();

        public FileStatistics build(String fileName) {
            return new FileStatistics(this.builder.intern(this.pathUtil.getAbsolutePath(fileName)));
        }
    }
}

