/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.delta;

import io.jenkins.plugins.forensics.delta.FileChanges;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class Delta
implements Serializable {
    private static final long serialVersionUID = 5641235877389921937L;
    static final String ERROR_MESSAGE_UNKNOWN_FILE = "No information about changes for the file with the ID '%s' stored";
    private final String currentCommit;
    private final String referenceCommit;
    private final Map<String, FileChanges> fileChangesMap;

    public Delta(String currentCommit, String referenceCommit, Map<String, FileChanges> fileChangesMap) {
        this.currentCommit = currentCommit;
        this.referenceCommit = referenceCommit;
        this.fileChangesMap = new HashMap<String, FileChanges>(fileChangesMap);
    }

    public String getCurrentCommit() {
        return this.currentCommit;
    }

    public String getReferenceCommit() {
        return this.referenceCommit;
    }

    public Map<String, FileChanges> getFileChangesMap() {
        return new HashMap<String, FileChanges>(this.fileChangesMap);
    }

    public FileChanges getFileChangesById(String fileId) {
        if (this.fileChangesMap.containsKey(fileId)) {
            return this.fileChangesMap.get(fileId);
        }
        throw new NoSuchElementException(ERROR_MESSAGE_UNKNOWN_FILE.formatted(fileId));
    }

    public void addFileChanges(String fileId, FileChanges fileChange) {
        this.fileChangesMap.put(fileId, fileChange);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Delta delta = (Delta)o;
        return Objects.equals(this.currentCommit, delta.currentCommit) && Objects.equals(this.referenceCommit, delta.referenceCommit) && Objects.equals(this.fileChangesMap, delta.fileChangesMap);
    }

    public int hashCode() {
        return Objects.hash(this.currentCommit, this.referenceCommit, this.fileChangesMap);
    }
}

