/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.blame;

import io.jenkins.plugins.forensics.blame.FileBlame;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;

public class Blames
implements Serializable {
    private static final long serialVersionUID = 7L;
    private final Map<String, FileBlame> blamesPerFile = new HashMap<String, FileBlame>();

    public void add(FileBlame additionalBlame) {
        this.merge(additionalBlame.getFileName(), additionalBlame);
    }

    public void addAll(Blames other) {
        for (String otherFile : other.getFiles()) {
            FileBlame otherRequest = other.getBlame(otherFile);
            this.merge(otherFile, otherRequest);
        }
    }

    private void merge(String otherFile, FileBlame otherRequest) {
        if (this.contains(otherFile)) {
            this.getBlame(otherFile).merge(otherRequest);
        } else {
            this.blamesPerFile.put(otherFile, otherRequest);
        }
    }

    public boolean isEmpty() {
        return this.blamesPerFile.isEmpty();
    }

    public int size() {
        return this.blamesPerFile.keySet().size();
    }

    public boolean contains(String fileName) {
        return this.blamesPerFile.containsKey(fileName);
    }

    public Set<String> getFiles() {
        return new HashSet<String>(this.blamesPerFile.keySet());
    }

    public FileBlame getBlame(String fileName) {
        if (this.blamesPerFile.containsKey(fileName)) {
            return this.blamesPerFile.get(fileName);
        }
        throw new NoSuchElementException("No blame information for file '%s' stored".formatted(fileName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blames blames = (Blames)o;
        return this.blamesPerFile.equals(blames.blamesPerFile);
    }

    public int hashCode() {
        return Objects.hash(this.blamesPerFile);
    }
}

