/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.forensics.miner;

import edu.hm.hafner.util.Generated;
import io.jenkins.plugins.forensics.miner.CommitStatistics;
import io.jenkins.plugins.forensics.miner.FileStatistics;
import io.jenkins.plugins.forensics.miner.RepositoryStatistics;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.internal.Iterables;

@Generated(value={"assertj-assertions-generator"})
public class RepositoryStatisticsAssert
extends AbstractObjectAssert<RepositoryStatisticsAssert, RepositoryStatistics> {
    public RepositoryStatisticsAssert(RepositoryStatistics actual) {
        super((Object)actual, RepositoryStatisticsAssert.class);
    }

    @CheckReturnValue
    public static RepositoryStatisticsAssert assertThat(RepositoryStatistics actual) {
        return new RepositoryStatisticsAssert(actual);
    }

    public RepositoryStatisticsAssert isEmpty() {
        this.isNotNull();
        if (!((RepositoryStatistics)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual RepositoryStatistics is empty but is not.", new Object[0]);
        }
        return this;
    }

    public RepositoryStatisticsAssert isNotEmpty() {
        this.isNotNull();
        if (((RepositoryStatistics)this.actual).isEmpty()) {
            this.failWithMessage("\nExpecting that actual RepositoryStatistics is not empty but is.", new Object[0]);
        }
        return this;
    }

    public RepositoryStatisticsAssert hasFileStatistics(FileStatistics ... fileStatistics) {
        this.isNotNull();
        if (fileStatistics == null) {
            this.failWithMessage("Expecting fileStatistics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFileStatistics(), (Object[])fileStatistics);
        return this;
    }

    public RepositoryStatisticsAssert hasFileStatistics(Collection<? extends FileStatistics> fileStatistics) {
        this.isNotNull();
        if (fileStatistics == null) {
            this.failWithMessage("Expecting fileStatistics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFileStatistics(), fileStatistics.toArray());
        return this;
    }

    public RepositoryStatisticsAssert hasOnlyFileStatistics(FileStatistics ... fileStatistics) {
        this.isNotNull();
        if (fileStatistics == null) {
            this.failWithMessage("Expecting fileStatistics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFileStatistics(), (Object[])fileStatistics);
        return this;
    }

    public RepositoryStatisticsAssert hasOnlyFileStatistics(Collection<? extends FileStatistics> fileStatistics) {
        this.isNotNull();
        if (fileStatistics == null) {
            this.failWithMessage("Expecting fileStatistics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFileStatistics(), fileStatistics.toArray());
        return this;
    }

    public RepositoryStatisticsAssert doesNotHaveFileStatistics(FileStatistics ... fileStatistics) {
        this.isNotNull();
        if (fileStatistics == null) {
            this.failWithMessage("Expecting fileStatistics parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFileStatistics(), (Object[])fileStatistics);
        return this;
    }

    public RepositoryStatisticsAssert doesNotHaveFileStatistics(Collection<? extends FileStatistics> fileStatistics) {
        this.isNotNull();
        if (fileStatistics == null) {
            this.failWithMessage("Expecting fileStatistics parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFileStatistics(), fileStatistics.toArray());
        return this;
    }

    public RepositoryStatisticsAssert hasNoFileStatistics() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have fileStatistics but had :\n  <%s>";
        if (((RepositoryStatistics)this.actual).getFileStatistics().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((RepositoryStatistics)this.actual).getFileStatistics()});
        }
        return this;
    }

    public RepositoryStatisticsAssert hasFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public RepositoryStatisticsAssert hasFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContains((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFiles(), files.toArray());
        return this;
    }

    public RepositoryStatisticsAssert hasOnlyFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public RepositoryStatisticsAssert hasOnlyFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertContainsOnly((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFiles(), files.toArray());
        return this;
    }

    public RepositoryStatisticsAssert doesNotHaveFiles(String ... files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFiles(), (Object[])files);
        return this;
    }

    public RepositoryStatisticsAssert doesNotHaveFiles(Collection<? extends String> files) {
        this.isNotNull();
        if (files == null) {
            this.failWithMessage("Expecting files parameter not to be null.", new Object[0]);
            return this;
        }
        Iterables.instance().assertDoesNotContain((AssertionInfo)this.info, (Iterable)((RepositoryStatistics)this.actual).getFiles(), files.toArray());
        return this;
    }

    public RepositoryStatisticsAssert hasNoFiles() {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting :\n  <%s>\nnot to have files but had :\n  <%s>";
        if (((RepositoryStatistics)this.actual).getFiles().iterator().hasNext()) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, ((RepositoryStatistics)this.actual).getFiles()});
        }
        return this;
    }

    public RepositoryStatisticsAssert hasLatestCommitId(String latestCommitId) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting latestCommitId of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        String actualLatestCommitId = ((RepositoryStatistics)this.actual).getLatestCommitId();
        if (!Objects.deepEquals(actualLatestCommitId, latestCommitId)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, latestCommitId, actualLatestCommitId});
        }
        return this;
    }

    public RepositoryStatisticsAssert hasLatestCommitId() {
        this.isNotNull();
        if (!((RepositoryStatistics)this.actual).hasLatestCommitId()) {
            this.failWithMessage("\nExpecting that actual RepositoryStatistics has latest commit id but does not have.", new Object[0]);
        }
        return this;
    }

    public RepositoryStatisticsAssert doesNotHaveLatestCommitId() {
        this.isNotNull();
        if (((RepositoryStatistics)this.actual).hasLatestCommitId()) {
            this.failWithMessage("\nExpecting that actual RepositoryStatistics does not have latest commit id but has.", new Object[0]);
        }
        return this;
    }

    public RepositoryStatisticsAssert hasLatestStatistics(CommitStatistics latestStatistics) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting latestStatistics of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        CommitStatistics actualLatestStatistics = ((RepositoryStatistics)this.actual).getLatestStatistics();
        if (!Objects.deepEquals(actualLatestStatistics, latestStatistics)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, latestStatistics, actualLatestStatistics});
        }
        return this;
    }

    public RepositoryStatisticsAssert hasMapping(Map mapping) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting mapping of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        Map actualMapping = ((RepositoryStatistics)this.actual).getMapping();
        if (!Objects.deepEquals(actualMapping, mapping)) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, mapping, actualMapping});
        }
        return this;
    }

    public RepositoryStatisticsAssert hasTotalChurn(int totalChurn) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting totalChurn of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualTotalChurn = ((RepositoryStatistics)this.actual).getTotalChurn();
        if (actualTotalChurn != totalChurn) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, totalChurn, actualTotalChurn});
        }
        return this;
    }

    public RepositoryStatisticsAssert hasTotalLinesOfCode(int totalLinesOfCode) {
        this.isNotNull();
        String assertjErrorMessage = "\nExpecting totalLinesOfCode of:\n  <%s>\nto be:\n  <%s>\nbut was:\n  <%s>";
        int actualTotalLinesOfCode = ((RepositoryStatistics)this.actual).getTotalLinesOfCode();
        if (actualTotalLinesOfCode != totalLinesOfCode) {
            this.failWithMessage(assertjErrorMessage, new Object[]{this.actual, totalLinesOfCode, actualTotalLinesOfCode});
        }
        return this;
    }
}

