// CHECKSTYLE:OFF

package io.jenkins.plugins.forensics.reference;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code FieldValidator.Error.ReferenceJobDoesNotExist}: {@code

     * There is no such job - maybe the job has been renamed?}.
     * 
     * @return
     *     {@code There is no such job - maybe the job has been renamed?}
     */
    public static String FieldValidator_Error_ReferenceJobDoesNotExist() {
        return holder.format("FieldValidator.Error.ReferenceJobDoesNotExist");
    }

    /**
     * Key {@code FieldValidator.Error.ReferenceJobDoesNotExist}: {@code

     * There is no such job - maybe the job has been renamed?}.
     * 
     * @return
     *     {@code There is no such job - maybe the job has been renamed?}
     */
    public static Localizable _FieldValidator_Error_ReferenceJobDoesNotExist() {
        return new Localizable(holder, "FieldValidator.Error.ReferenceJobDoesNotExist");
    }

    /**
     * Key {@code Recorder.DisplayName}: {@code Discover reference build}.
     * 
     * @return
     *     {@code Discover reference build}
     */
    public static String Recorder_DisplayName() {
        return holder.format("Recorder.DisplayName");
    }

    /**
     * Key {@code Recorder.DisplayName}: {@code Discover reference build}.
     * 
     * @return
     *     {@code Discover reference build}
     */
    public static Localizable _Recorder_DisplayName() {
        return new Localizable(holder, "Recorder.DisplayName");
    }

    /**
     * Key {@code RequiredResult.Failure}: {@code All build results}.
     * 
     * @return
     *     {@code All build results}
     */
    public static String RequiredResult_Failure() {
        return holder.format("RequiredResult.Failure");
    }

    /**
     * Key {@code RequiredResult.Failure}: {@code All build results}.
     * 
     * @return
     *     {@code All build results}
     */
    public static Localizable _RequiredResult_Failure() {
        return new Localizable(holder, "RequiredResult.Failure");
    }

    /**
     * Key {@code RequiredResult.Success}: {@code Only successful}.
     * 
     * @return
     *     {@code Only successful}
     */
    public static String RequiredResult_Success() {
        return holder.format("RequiredResult.Success");
    }

    /**
     * Key {@code RequiredResult.Success}: {@code Only successful}.
     * 
     * @return
     *     {@code Only successful}
     */
    public static Localizable _RequiredResult_Success() {
        return new Localizable(holder, "RequiredResult.Success");
    }

    /**
     * Key {@code Messages.DisplayName}: {@code Reference build}.
     * 
     * @return
     *     {@code Reference build}
     */
    public static String Messages_DisplayName() {
        return holder.format("Messages.DisplayName");
    }

    /**
     * Key {@code Messages.DisplayName}: {@code Reference build}.
     * 
     * @return
     *     {@code Reference build}
     */
    public static Localizable _Messages_DisplayName() {
        return new Localizable(holder, "Messages.DisplayName");
    }

    /**
     * Key {@code RequiredResult.Unstable}: {@code Only unstable or

     * successful}.
     * 
     * @return
     *     {@code Only unstable or successful}
     */
    public static String RequiredResult_Unstable() {
        return holder.format("RequiredResult.Unstable");
    }

    /**
     * Key {@code RequiredResult.Unstable}: {@code Only unstable or

     * successful}.
     * 
     * @return
     *     {@code Only unstable or successful}
     */
    public static Localizable _RequiredResult_Unstable() {
        return new Localizable(holder, "RequiredResult.Unstable");
    }

}
