/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.file_parameters;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.model.TaskListener;
import jakarta.servlet.ServletOutputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class AbstractFileParameterValue
extends ParameterValue {
    @CheckForNull
    private String filename;

    protected AbstractFileParameterValue(String name) {
        super(name);
    }

    public final String getFilename() {
        return this.filename;
    }

    final void setFilename(String filename) {
        this.filename = new File(filename).getName();
    }

    protected InputStream open(@CheckForNull Run<?, ?> build) throws IOException, InterruptedException {
        assert (Util.isOverridden(AbstractFileParameterValue.class, ((Object)((Object)this)).getClass(), (String)"createTempFile", (Class[])new Class[]{Run.class, FilePath.class, EnvVars.class, Launcher.class, TaskListener.class}));
        if (build == null) {
            throw new IOException("Cannot operate outside of a build context");
        }
        final FilePath tempDir = new FilePath(Util.createTempDir());
        FilePath f = this.createTempFile(build, tempDir, new EnvVars(EnvVars.masterEnvVars), (Launcher)new Launcher.LocalLauncher(TaskListener.NULL), TaskListener.NULL);
        return new FilterInputStream(f.read()){

            @Override
            public void close() throws IOException {
                super.close();
                try {
                    tempDir.deleteRecursive();
                }
                catch (InterruptedException x) {
                    throw new IOException(x);
                }
            }
        };
    }

    protected FilePath createTempFile(@NonNull Run<?, ?> build, @NonNull FilePath tempDir, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws IOException, InterruptedException {
        assert (Util.isOverridden(AbstractFileParameterValue.class, ((Object)((Object)this)).getClass(), (String)"open", (Class[])new Class[]{Run.class}));
        FilePath f = tempDir.createTempFile(this.name.length() >= 3 ? this.name : "fileparam", null);
        try (InputStream is = this.open(build);){
            f.copyFrom(is);
        }
        return f;
    }

    public void doDownload(@AncestorInPath Run<?, ?> build, StaplerResponse2 rsp) throws Exception {
        rsp.setContentType("application/octet-stream");
        try (InputStream is = this.open(build);
             ServletOutputStream os = rsp.getOutputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
    }

    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        super.buildEnvironment(build, env);
        String fname = this.getFilename();
        if (fname != null) {
            env.put(this.name + "_FILENAME", fname);
        }
    }
}

