/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.file_parameters;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.queue.QueueListener;
import io.jenkins.plugins.file_parameters.AbstractFileParameterValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.io.FileUtils;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;
import org.jenkinsci.plugins.workflow.flow.StashManager;
import org.kohsuke.stapler.DataBoundConstructor;

public final class StashedFileParameterValue
extends AbstractFileParameterValue {
    private static final Logger LOGGER = Logger.getLogger(StashedFileParameterValue.class.getName());
    private static final long serialVersionUID = 1L;
    private String tmpFile;

    @DataBoundConstructor
    public StashedFileParameterValue(String name, FileItem file) throws IOException {
        this(name, file.getInputStream());
        this.setFilename(file.getName());
        file.delete();
    }

    StashedFileParameterValue(String name, InputStream src) throws IOException {
        super(name);
        File dir = new File(Jenkins.get().getRootDir(), "stashedFileParameterValueFiles");
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
        File tmpDir = Files.createTempDirectory(dir.toPath(), null, new FileAttribute[0]).toFile();
        File tmp = new File(tmpDir, name);
        FileUtils.copyInputStreamToFile((InputStream)src, (File)tmp);
        this.tmpFile = tmp.getAbsolutePath();
    }

    @Override
    public void buildEnvironment(Run<?, ?> build, EnvVars env) {
        File tmp;
        super.buildEnvironment(build, env);
        File file = tmp = this.tmpFile != null ? new File(this.tmpFile) : null;
        if (tmp != null && tmp.isFile()) {
            try {
                FlowExecutionOwner feo = build instanceof FlowExecutionOwner.Executable ? ((FlowExecutionOwner.Executable)build).asFlowExecutionOwner() : null;
                TaskListener listener = feo != null ? feo.getListener() : TaskListener.NULL;
                StashManager.stash(build, (String)this.name, (FilePath)new FilePath(tmp.getParentFile()), (Launcher)new Launcher.LocalLauncher(listener), (EnvVars)env, (TaskListener)listener, (String)tmp.getName(), null, (boolean)false, (boolean)false);
            }
            catch (IOException | InterruptedException x) {
                throw new RuntimeException(x);
            }
            try {
                FileUtils.deleteDirectory((File)tmp.getParentFile());
                this.tmpFile = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected FilePath createTempFile(Run<?, ?> build, FilePath tempDir, EnvVars env, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        StashManager.unstash(build, (String)this.name, (FilePath)tempDir, (Launcher)launcher, (EnvVars)env, (TaskListener)listener);
        return tempDir.child(this.name);
    }

    @Extension
    public static class CancelledQueueListener
    extends QueueListener {
        public void onLeft(Queue.LeftItem li) {
            if (li.isCancelled()) {
                List actions = li.getActions(ParametersAction.class);
                actions.forEach(a -> a.getAllParameters().stream().filter(p -> p instanceof StashedFileParameterValue).map(p -> (StashedFileParameterValue)((Object)((Object)p))).forEach(p -> {
                    if (p.tmpFile != null) {
                        File tmp = new File(p.tmpFile);
                        try {
                            FileUtils.deleteDirectory((File)tmp.getParentFile());
                        }
                        catch (IOException | IllegalArgumentException e) {
                            LOGGER.log(Level.WARNING, "Unable to delete temporary file {0} for parameter {1} of task {2}", new Object[]{tmp.getAbsolutePath(), p.getName(), li.task.getName()});
                        }
                    }
                }));
            }
        }
    }
}

