/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.AbstractExtraToolInstaller;
import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.Messages;
import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.ExtraToolInstallersException;
import hudson.Extension;
import hudson.FilePath;
import hudson.RestrictedSince;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.CommandInstaller;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class StubInstaller
extends AbstractExtraToolInstaller {
    private final String message;
    private final boolean failTheBuild;

    @DataBoundConstructor
    public StubInstaller(String label, String message, String toolHome, boolean failTheBuild, boolean failOnSubstitution) {
        super(label, toolHome, failOnSubstitution);
        this.message = Util.fixEmptyAndTrim((String)message);
        this.failTheBuild = failTheBuild;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isFailTheBuild() {
        return this.failTheBuild;
    }

    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        FilePath dir = this.preferredLocation(tool, node);
        String substitutedHome = this.substituteNodeVariablesValidated("Tool Home", this.getToolHome(), node);
        String messagePrefix = "[" + tool.getName() + "] - ";
        String outMessage = messagePrefix + (this.message != null ? this.substituteNodeVariablesValidated("Message", this.message, node) : Messages.StubInstaller_defaultMessage());
        log.getLogger().println(outMessage);
        if (this.failTheBuild) {
            throw new ExtraToolInstallersException((ToolInstaller)this, messagePrefix + "Installation has been interrupted");
        }
        return dir.child(substitutedHome);
    }

    @Extension
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<CommandInstaller> {
        public String getDisplayName() {
            return Messages.StubInstaller_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        @RestrictedSince(value="0.4")
        public FormValidation doCheckMessage(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.warning((String)Messages.StubInstaller_noMessage());
        }
    }
}

