/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extratoolinstallers.installers;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.PasswordCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.ExtraToolInstallersException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.ItemGroup;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.extratoolinstallers.installers.AuthenticatedDownloadCallable;
import io.jenkins.plugins.extratoolinstallers.installers.Messages;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class AuthenticatedZipExtractionInstaller
extends ToolInstaller {
    @CheckForNull
    private String url;
    @CheckForNull
    private String credentialsId;
    @CheckForNull
    private String subdir;
    private boolean fallbackToExistingInstallation;
    private static final CredentialsMatcher CREDENTIAL_TYPES_WE_CAN_HANDLE = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(PasswordCredentials.class), CredentialsMatchers.instanceOf(UsernameCredentials.class)});

    @DataBoundConstructor
    public AuthenticatedZipExtractionInstaller(String label) {
        super(label);
    }

    @CheckForNull
    public String getUrl() {
        return Util.fixEmpty((String)this.url);
    }

    @DataBoundSetter
    public void setUrl(@Nullable String url) {
        this.url = Util.fixEmpty((String)url);
    }

    @CheckForNull
    public String getCredentialsId() {
        return Util.fixEmpty((String)this.credentialsId);
    }

    @DataBoundSetter
    public void setCredentialsId(@Nullable String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    @CheckForNull
    public String getSubdir() {
        return Util.fixEmpty((String)this.subdir);
    }

    @DataBoundSetter
    public void setSubdir(@Nullable String subdir) {
        this.subdir = Util.fixEmpty((String)subdir);
    }

    public boolean isFallbackToExistingInstallation() {
        return this.fallbackToExistingInstallation;
    }

    @DataBoundSetter
    public void setFallbackToExistingInstallation(boolean fallbackToExistingInstallation) {
        this.fallbackToExistingInstallation = fallbackToExistingInstallation;
    }

    public FilePath performInstallation(@NonNull ToolInstallation tool, @NonNull Node node, @CheckForNull TaskListener log) throws IOException, InterruptedException {
        String subdirOrNull;
        String passwordOrNull;
        String usernameOrNull;
        String urlHost;
        URI uri;
        String url = this.getUrl();
        try {
            uri = new URI(url);
            urlHost = uri.getHost();
        }
        catch (URISyntaxException ex) {
            throw new ExtraToolInstallersException(this, Messages.AuthenticatedZipExtractionInstaller_malformed_url(), ex);
        }
        StandardCredentials credentialsOrNull = this.lookupConfiguredCredentials(urlHost);
        if (credentialsOrNull == null) {
            usernameOrNull = null;
            passwordOrNull = null;
        } else {
            usernameOrNull = AuthenticatedZipExtractionInstaller.getUsernameFromCredentials(credentialsOrNull);
            passwordOrNull = AuthenticatedZipExtractionInstaller.getPasswordFromCredentials(credentialsOrNull);
        }
        FilePath dir = this.preferredLocation(tool, node);
        FilePath timestamp = dir.child(".timestamp");
        Long timestampOfLocalContents = timestamp.exists() ? Long.valueOf(timestamp.lastModified()) : null;
        String nodeName = node.getDisplayName();
        Date timestampOfRemoteResource = this.downloadOnNodeWithFallbackToMaster(uri, timestampOfLocalContents, usernameOrNull, passwordOrNull, nodeName, dir, log);
        if (timestampOfRemoteResource != null) {
            dir.act((FilePath.FileCallable)new ChmodRecAPlusX());
            timestamp.touch(timestampOfRemoteResource.getTime());
        }
        if ((subdirOrNull = this.getSubdir()) == null) {
            return dir;
        }
        return dir.child(subdirOrNull);
    }

    private Date downloadOnNodeWithFallbackToMaster(@NonNull URI uri, @CheckForNull Long timestampOfLocalContents, @CheckForNull String usernameOrNull, @CheckForNull String passwordOrNull, @NonNull String nodeName, @NonNull FilePath dir, @CheckForNull TaskListener logOrNull) throws IOException, InterruptedException {
        block4: {
            if (dir.isRemote()) {
                try {
                    Date timestampOfRemoteResource = this.downloadOnRemoteNode(uri, timestampOfLocalContents, usernameOrNull, passwordOrNull, dir, logOrNull, nodeName);
                    return timestampOfRemoteResource;
                }
                catch (AuthenticatedDownloadCallable.HttpGetException | InterruptedException ex) {
                    throw ex;
                }
                catch (IOException ex) {
                    if (logOrNull == null) break block4;
                    Functions.printStackTrace((Throwable)ex, (PrintWriter)logOrNull.error("Failed to download " + String.valueOf(uri) + " from agent; will try from master instead"));
                }
            }
        }
        Date timestampOfRemoteResource = this.downloadOnFromMaster(uri, timestampOfLocalContents, usernameOrNull, passwordOrNull, dir, logOrNull, nodeName);
        return timestampOfRemoteResource;
    }

    protected StandardCredentials lookupConfiguredCredentials(@CheckForNull String urlHostOrNullOrEmpty) throws ExtraToolInstallersException {
        String credentialsIdOrNull = this.getCredentialsId();
        if (credentialsIdOrNull == null) {
            return null;
        }
        StandardCredentials credentialsOrNull = AuthenticatedZipExtractionInstaller.getCredentialsOrNull(credentialsIdOrNull, urlHostOrNullOrEmpty);
        if (credentialsOrNull == null) {
            throw new ExtraToolInstallersException((ToolInstaller)this, Messages.AuthenticatedZipExtractionInstaller_invalid_credentials(credentialsIdOrNull));
        }
        return credentialsOrNull;
    }

    protected Date downloadOnFromMaster(@NonNull URI uri, @CheckForNull Long timestampOfLocalContents, @CheckForNull String usernameOrNull, @CheckForNull String passwordOrNull, @NonNull FilePath dir, @CheckForNull TaskListener logOrNull, @NonNull String nodeName) throws IOException, InterruptedException {
        Date timestampOfRemoteResource = AuthenticatedDownloadCallable.downloadAndUnpack(uri, usernameOrNull, passwordOrNull, timestampOfLocalContents, nodeName, dir, logOrNull, this.fallbackToExistingInstallation);
        return timestampOfRemoteResource;
    }

    protected Date downloadOnRemoteNode(@NonNull URI uri, @CheckForNull Long timestampOfLocalContents, @CheckForNull String usernameOrNull, @CheckForNull String passwordOrNull, @NonNull FilePath dir, @CheckForNull TaskListener logOrNull, @NonNull String nodeName) throws IOException, InterruptedException {
        AuthenticatedDownloadCallable nodeOperation = new AuthenticatedDownloadCallable(uri, usernameOrNull, passwordOrNull, timestampOfLocalContents, nodeName, logOrNull, this.fallbackToExistingInstallation);
        Date timestampOfRemoteResource = (Date)dir.act((FilePath.FileCallable)nodeOperation);
        return timestampOfRemoteResource;
    }

    @CheckForNull
    private static StandardCredentials getCredentialsOrNull(@NonNull String credentialsId, @CheckForNull String urlHostOrNullOrEmpty) {
        List<DomainRequirement> forOurUrl = AuthenticatedZipExtractionInstaller.getDomainRequirements(urlHostOrNullOrEmpty);
        Jenkins allOfJenkins = Jenkins.getInstanceOrNull();
        CredentialsMatcher onlyOurCredentials = CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CREDENTIAL_TYPES_WE_CAN_HANDLE, CredentialsMatchers.withId((String)credentialsId)});
        List allJenkinsCredentialsForOurUrl = CredentialsProvider.lookupCredentials(StandardCredentials.class, (ItemGroup)allOfJenkins, (Authentication)ACL.SYSTEM, forOurUrl);
        StandardCredentials ourCredentialsOrNull = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)allJenkinsCredentialsForOurUrl, (CredentialsMatcher)onlyOurCredentials);
        return ourCredentialsOrNull;
    }

    @CheckForNull
    private static String getUsernameFromCredentials(@NonNull StandardCredentials credentials) {
        if (credentials instanceof UsernameCredentials) {
            UsernameCredentials userCreds = (UsernameCredentials)credentials;
            return userCreds.getUsername();
        }
        return null;
    }

    @CheckForNull
    private static String getPasswordFromCredentials(@NonNull StandardCredentials credentials) {
        if (credentials instanceof PasswordCredentials) {
            PasswordCredentials pwdCreds = (PasswordCredentials)credentials;
            return Secret.toString((Secret)pwdCreds.getPassword());
        }
        return null;
    }

    @NonNull
    private static List<DomainRequirement> getDomainRequirements(@CheckForNull String urlHostOrNullOrEmpty) {
        if (Util.fixEmpty((String)urlHostOrNullOrEmpty) != null) {
            return Collections.singletonList(new HostnameRequirement(urlHostOrNullOrEmpty));
        }
        return Collections.emptyList();
    }

    static class ChmodRecAPlusX
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;

        ChmodRecAPlusX() {
        }

        public Void invoke(File d, VirtualChannel channel) throws IOException {
            if (!Functions.isWindows()) {
                this.process(d);
            }
            return null;
        }

        private void process(File f) {
            if (f.isFile()) {
                f.setExecutable(true, false);
            } else {
                File[] kids = f.listFiles();
                if (kids != null) {
                    for (File kid : kids) {
                        this.process(kid);
                    }
                }
            }
        }
    }

    @Extension
    @Symbol(value={"authenticatedzip"})
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<AuthenticatedZipExtractionInstaller> {
        public String getDisplayName() {
            return Messages.AuthenticatedZipExtractionInstaller_DescriptorImpl_displayName();
        }

        @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="TODO needs triage")
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String credentialsId, @QueryParameter String url) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (DescriptorImpl.hasPermissionToConfigure()) {
                result.includeEmptyValue();
                String urlHostOrNullOrEmpty = null;
                try {
                    String urlString = Util.fixEmpty((String)url);
                    if (urlString != null) {
                        URI uri = new URI(urlString);
                        urlHostOrNullOrEmpty = uri.getHost();
                    }
                }
                catch (URISyntaxException urlString) {
                    // empty catch block
                }
                Jenkins allOfJenkins = Jenkins.getInstanceOrNull();
                List<DomainRequirement> domainRequirements = AuthenticatedZipExtractionInstaller.getDomainRequirements(urlHostOrNullOrEmpty);
                result.includeMatchingAs(ACL.SYSTEM, (ItemGroup)allOfJenkins, StandardCredentials.class, domainRequirements, CREDENTIAL_TYPES_WE_CAN_HANDLE);
            }
            result.includeCurrentValue(credentialsId);
            return result;
        }

        @RequirePOST
        public FormValidation doCheckCredentialsId(@QueryParameter String value, @QueryParameter String url) {
            String urlOrNull = Util.fixEmpty((String)url);
            String credentialsIdOrNull = Util.fixEmpty((String)value);
            return DescriptorImpl.checkUrlAndCredentialsId(false, credentialsIdOrNull, urlOrNull);
        }

        @RequirePOST
        public FormValidation doCheckUrl(@QueryParameter String credentialsId, @QueryParameter String value) {
            String urlOrNull = Util.fixEmpty((String)value);
            String credentialsIdOrNull = Util.fixEmpty((String)credentialsId);
            return DescriptorImpl.checkUrlAndCredentialsId(true, credentialsIdOrNull, urlOrNull);
        }

        @NonNull
        private static FormValidation checkUrlAndCredentialsId(boolean checkUrl, @CheckForNull String credentialsIdOrNull, @CheckForNull String urlOrNull) {
            String passwordOrNull;
            String usernameOrNull;
            String urlHostOrNullOrEmpty;
            URI uri;
            if (!DescriptorImpl.hasPermissionToConfigure()) {
                return FormValidation.ok();
            }
            if (urlOrNull == null) {
                return DescriptorImpl.urlProblem(checkUrl, FormValidation.validateRequired((String)""));
            }
            try {
                uri = new URI(urlOrNull);
                urlHostOrNullOrEmpty = uri.getHost();
            }
            catch (URISyntaxException ex) {
                return DescriptorImpl.urlProblem(checkUrl, FormValidation.error((Throwable)ex, (String)Messages.AuthenticatedZipExtractionInstaller_malformed_url()));
            }
            if (credentialsIdOrNull == null) {
                usernameOrNull = null;
                passwordOrNull = null;
            } else {
                StandardCredentials credentialsOrNull = AuthenticatedZipExtractionInstaller.getCredentialsOrNull(credentialsIdOrNull, urlHostOrNullOrEmpty);
                if (credentialsOrNull == null) {
                    return DescriptorImpl.credentialProblem(checkUrl, FormValidation.error((String)Messages.AuthenticatedZipExtractionInstaller_invalid_credentials(credentialsIdOrNull)));
                }
                usernameOrNull = AuthenticatedZipExtractionInstaller.getUsernameFromCredentials(credentialsOrNull);
                passwordOrNull = AuthenticatedZipExtractionInstaller.getPasswordFromCredentials(credentialsOrNull);
            }
            try {
                Long timestampOfLocalContents = null;
                String nodeName = "";
                FilePath whereToDownloadToOrNull = null;
                TaskListener log = null;
                AuthenticatedDownloadCallable.downloadAndUnpack(uri, usernameOrNull, passwordOrNull, timestampOfLocalContents, "", whereToDownloadToOrNull, log, false);
            }
            catch (AuthenticatedDownloadCallable.HttpGetException ex) {
                Integer httpStatusCodeOrNull = ex.getHttpStatusCode();
                if (httpStatusCodeOrNull != null) {
                    int httpStatusCode = httpStatusCodeOrNull;
                    if (httpStatusCode == 401) {
                        if (usernameOrNull == null) {
                            return DescriptorImpl.credentialProblem(checkUrl, FormValidation.error((Throwable)ex, (String)Messages.AuthenticatedZipExtractionInstaller_credentials_required()));
                        }
                        return DescriptorImpl.credentialProblem(checkUrl, FormValidation.error((Throwable)ex, (String)Messages.AuthenticatedZipExtractionInstaller_credentials_rejected(usernameOrNull)));
                    }
                    if (httpStatusCode == 404) {
                        return DescriptorImpl.credentialProblem(checkUrl, FormValidation.error((Throwable)ex, (String)Messages.AuthenticatedZipExtractionInstaller_404_http_response_from_server()));
                    }
                }
                return DescriptorImpl.urlProblem(checkUrl, FormValidation.error((Throwable)ex, (String)Messages.AuthenticatedZipExtractionInstaller_bad_http_response_from_server(ex.getMessage())));
            }
            catch (IOException | InterruptedException | RuntimeException ex) {
                return DescriptorImpl.urlProblem(checkUrl, FormValidation.error((Throwable)ex, (String)Messages.AuthenticatedZipExtractionInstaller_could_not_connect(ex.toString())));
            }
            return FormValidation.ok();
        }

        @NonNull
        private static FormValidation urlProblem(boolean checkUrlNotCredentials, @NonNull FormValidation problemWithUrl) {
            return checkUrlNotCredentials ? problemWithUrl : FormValidation.ok();
        }

        @NonNull
        private static FormValidation credentialProblem(boolean checkUrlNotCredentials, @NonNull FormValidation problemWithCredentials) {
            return checkUrlNotCredentials ? FormValidation.ok() : problemWithCredentials;
        }

        private static boolean hasPermissionToConfigure() {
            return Jenkins.get().hasPermission(Jenkins.ADMINISTER);
        }
    }
}

