/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.utils.ExtraToolInstallersException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.model.Node;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.tools.ToolInstaller;
import jenkins.model.Jenkins;

public class EnvStringParseHelper {
    private EnvStringParseHelper() {
    }

    public static String substituteEnvVars(String macroString, EnvVars environment) {
        if (macroString == null) {
            return null;
        }
        if (!macroString.contains("${")) {
            return macroString;
        }
        return environment.expand(macroString);
    }

    @Nullable
    public static String substituteNodeVariables(@CheckForNull String macroString, @NonNull Node node) {
        if (macroString == null) {
            return null;
        }
        if (!macroString.contains("${")) {
            return macroString;
        }
        String substitutedString = macroString;
        for (NodeProperty entry : node.getNodeProperties()) {
            substitutedString = EnvStringParseHelper.substituteNodeProperty(substitutedString, entry);
        }
        Jenkins jenkinsInstance = Jenkins.get();
        for (NodeProperty entry : jenkinsInstance.getGlobalNodeProperties()) {
            substitutedString = EnvStringParseHelper.substituteNodeProperty(substitutedString, entry);
        }
        return substitutedString;
    }

    public static String substituteNodeProperty(String macroString, NodeProperty<?> property) {
        if (property != null && property instanceof EnvironmentVariablesNodeProperty) {
            EnvironmentVariablesNodeProperty prop = (EnvironmentVariablesNodeProperty)property;
            return EnvStringParseHelper.substituteEnvVars(macroString, prop.getEnvVars());
        }
        return macroString;
    }

    public static void checkStringForMacro(ToolInstaller installer, String stringName, String macroString) throws ExtraToolInstallersException {
        if (macroString.contains("${")) {
            throw new ExtraToolInstallersException(installer, "Can't resolve all variables in " + stringName + " string. Final state: " + macroString);
        }
    }
}

