/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers;

import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.AbstractExtraToolInstaller;
import com.synopsys.arc.jenkinsci.plugins.extratoolinstallers.installers.Messages;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import java.io.IOException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BatchCommandInstaller
extends AbstractExtraToolInstaller {
    private final String command;

    @DataBoundConstructor
    public BatchCommandInstaller(String label, String command, String toolHome, boolean failOnSubstitution) {
        super(label, toolHome, failOnSubstitution);
        this.command = BatchCommandInstaller.fixCrLf(command);
    }

    private static String fixCrLf(String s) {
        int idx;
        while ((idx = ((String)s).indexOf("\r\n")) != -1) {
            s = ((String)s).substring(0, idx) + ((String)s).substring(idx + 1);
        }
        return s;
    }

    public String getCommand() {
        return this.command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePath performInstallation(ToolInstallation tool, Node node, TaskListener log) throws IOException, InterruptedException {
        String substitutedHome = this.substituteNodeVariablesValidated("Tool Home", this.getToolHome(), node);
        FilePath dir = this.preferredLocation(tool, node);
        FilePath script = dir.createTextTempFile("hudson", ".bat", this.command);
        try {
            String[] cmd = new String[]{"cmd", "/c", "call", script.getRemote()};
            int r = node.createLauncher(log).launch().cmds(cmd).stdout(log).pwd(dir).join();
            if (r != 0) {
                throw new IOException("Command returned status " + r);
            }
        }
        finally {
            script.delete();
        }
        return dir.child(substitutedHome);
    }

    @Extension
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<BatchCommandInstaller> {
        public String getDisplayName() {
            return Messages.BatchCommandInstaller_DescriptorImpl_displayName();
        }

        public FormValidation doCheckCommand(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.BatchCommandInstaller_no_command());
        }

        public FormValidation doCheckToolHome(@QueryParameter String value) {
            if (value.length() > 0) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.BatchCommandInstaller_no_toolHome());
        }
    }
}

