/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extratoolinstallers.installers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.extratoolinstallers.installers.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.time.Instant;
import java.util.Date;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;

class AuthenticatedDownloadCallable
extends MasterToSlaveFileCallable<Date> {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final URI uri;
    @CheckForNull
    private final String usernameOrNull;
    @CheckForNull
    private final String passwordOrNull;
    @CheckForNull
    private final Long timestampOfLocalContents;
    @NonNull
    private final String nodeName;
    @CheckForNull
    private final TaskListener logOrNull;
    private final boolean fallbackToExistingInstallation;

    AuthenticatedDownloadCallable(@NonNull URI uri, @CheckForNull String usernameOrNull, @CheckForNull String passwordOrNull, @CheckForNull Long timestampOfLocalContents, @NonNull String nodeName, @CheckForNull TaskListener logOrNull, boolean fallbackToExistingInstallation) {
        this.uri = uri;
        this.usernameOrNull = usernameOrNull;
        this.passwordOrNull = passwordOrNull;
        this.timestampOfLocalContents = timestampOfLocalContents;
        this.nodeName = nodeName;
        this.logOrNull = logOrNull;
        this.fallbackToExistingInstallation = fallbackToExistingInstallation;
    }

    public Date invoke(@NonNull File d, VirtualChannel channel) throws IOException, InterruptedException {
        FilePath whereToDownloadTo = new FilePath(d);
        return AuthenticatedDownloadCallable.downloadAndUnpack(this.uri, this.usernameOrNull, this.passwordOrNull, this.timestampOfLocalContents, this.nodeName, whereToDownloadTo, this.logOrNull, this.fallbackToExistingInstallation);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static Date downloadAndUnpack(@NonNull URI uri, @CheckForNull String usernameOrNull, @CheckForNull String passwordOrNull, @CheckForNull Long timestampOfLocalContents, @NonNull String nodeName, @CheckForNull FilePath whereToDownloadToOrNull, @CheckForNull TaskListener logOrNull, boolean fallbackToExistingInstallation) throws IOException, InterruptedException {
        httpClient = HttpClients.createDefault();
        try {
            block27: {
                block25: {
                    block26: {
                        httpClientContext = HttpClientContext.create();
                        httpRequest /* !! */  = whereToDownloadToOrNull == null ? new HttpHead(uri) : new HttpGet(uri);
                        if (usernameOrNull != null && passwordOrNull != null) {
                            AuthenticatedDownloadCallable.setAuthentication(usernameOrNull, passwordOrNull, httpClientContext, uri);
                        }
                        dateOfLocalContents = timestampOfLocalContents == null ? null : new Date(timestampOfLocalContents);
                        ifModifiedSince = "If-Modified-Since";
                        lastModified = "Last-Modified";
                        if (dateOfLocalContents != null) {
                            timestampAsString = DateUtils.formatStandardDate((Instant)dateOfLocalContents.toInstant());
                            httpRequest /* !! */ .addHeader("If-Modified-Since", (Object)timestampAsString);
                        }
                        httpResponse = httpClient.executeOpen(HttpHost.create((URI)uri), (ClassicHttpRequest)httpRequest /* !! */ , (HttpContext)httpClientContext);
                        try {
                            status = httpResponse.getCode();
                            switch (status) {
                                case 304: {
                                    dateOfRemoteContents = null;
                                    break;
                                }
                                case 200: {
                                    lastModifiedResponseHeader = httpResponse.getFirstHeader("Last-Modified");
                                    if (lastModifiedResponseHeader == null) {
                                        throw new HttpGetException(uri.toString(), usernameOrNull, "due to missing Last-Modified header value.");
                                    }
                                    lastModifiedStringValue = lastModifiedResponseHeader.getValue();
                                    dateFromRemoteServer = DateUtils.toDate((Instant)DateUtils.parseStandardDate((String)lastModifiedStringValue));
                                    if (dateFromRemoteServer != null) {
                                        if (dateOfLocalContents == null || dateFromRemoteServer.after(dateOfLocalContents)) {
                                            dateOfRemoteContents = dateFromRemoteServer;
                                            break;
                                        }
                                        dateOfRemoteContents = null;
                                        break;
                                    }
                                    throw new HttpGetException(uri.toString(), usernameOrNull, "due to invalid Last-Modified header value, \"" + lastModifiedStringValue + "\".");
                                }
                                default: {
                                    if (fallbackToExistingInstallation && AuthenticatedDownloadCallable.existingToolInstallationAvailable(whereToDownloadToOrNull)) {
                                        if (logOrNull != null) {
                                            msg = Messages.AuthenticatedDownloadCallable_fallback_to_existing(status);
                                            logOrNull.getLogger().println(msg);
                                        }
                                        dateOfRemoteContents = null;
                                        break;
                                    }
                                    throw new HttpGetException(uri.toString(), usernameOrNull, status);
                                }
                            }
                            if (whereToDownloadToOrNull == null) ** GOTO lbl64
                            if (dateOfRemoteContents != null) break block25;
                            AuthenticatedDownloadCallable.skipDownload(whereToDownloadToOrNull, logOrNull, uri, nodeName);
                            httpRequest /* !! */ .abort();
                            var17_21 = null;
                            if (httpResponse == null) break block26;
                        }
                        catch (Throwable var15_18) {
                            if (httpResponse != null) {
                                try {
                                    httpResponse.close();
                                }
                                catch (Throwable var16_20) {
                                    var15_18.addSuppressed(var16_20);
                                }
                            }
                            throw var15_18;
                        }
                        httpResponse.close();
                    }
                    return var17_21;
                }
                AuthenticatedDownloadCallable.doDownload(httpResponse, whereToDownloadToOrNull, logOrNull, uri, usernameOrNull, nodeName);
lbl64:
                // 2 sources

                var17_21 = dateOfRemoteContents;
                if (httpResponse == null) break block27;
                httpResponse.close();
            }
            return var17_21;
        }
        finally {
            if (httpClient != null) {
                httpClient.close();
            }
        }
    }

    private static boolean existingToolInstallationAvailable(FilePath whereToDownloadToOrNull) throws IOException, InterruptedException {
        return whereToDownloadToOrNull != null && whereToDownloadToOrNull.exists();
    }

    private static void setAuthentication(@NonNull String username, @NonNull String password, @NonNull HttpClientContext httpClientContext, @NonNull URI uri) {
        UsernamePasswordCredentials httpClientCredentials = new UsernamePasswordCredentials(username, password.toCharArray());
        HttpHost targetHost = new HttpHost(uri.getScheme(), uri.getHost(), uri.getPort());
        AuthScope scope = new AuthScope(targetHost);
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(scope, (Credentials)httpClientCredentials);
        httpClientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicScheme = new BasicScheme();
        basicScheme.initPreemptive((Credentials)httpClientCredentials);
        authCache.put(targetHost, (AuthScheme)basicScheme);
        httpClientContext.setAuthCache((AuthCache)authCache);
    }

    private static void skipDownload(@NonNull FilePath whereToDownloadTo, @CheckForNull TaskListener logOrNull, @NonNull URI uri, @NonNull String nodeName) {
        if (logOrNull != null) {
            String folder = whereToDownloadTo.getRemote();
            String msg = Messages.AuthenticatedZipExtractionInstaller_download_skipped(uri, folder, nodeName);
            logOrNull.getLogger().println(msg);
        }
    }

    private static void doDownload(@NonNull ClassicHttpResponse httpResponse, @NonNull FilePath whereToDownloadTo, @CheckForNull TaskListener logOrNull, @NonNull URI uri, @CheckForNull String usernameOrNull, @NonNull String nodeName) throws IOException, InterruptedException {
        if (whereToDownloadTo.exists()) {
            whereToDownloadTo.deleteContents();
            if (logOrNull != null) {
                folder = whereToDownloadTo.getRemote();
                msg = usernameOrNull == null ? Messages.AuthenticatedZipExtractionInstaller_anonymous_download_newer(uri, folder, nodeName) : Messages.AuthenticatedZipExtractionInstaller_authenticated_download_newer(uri, usernameOrNull, folder, nodeName);
                logOrNull.getLogger().println(msg);
            }
        } else {
            whereToDownloadTo.mkdirs();
            if (logOrNull != null) {
                folder = whereToDownloadTo.getRemote();
                msg = usernameOrNull == null ? Messages.AuthenticatedZipExtractionInstaller_anonymous_download_new(uri, folder, nodeName) : Messages.AuthenticatedZipExtractionInstaller_authenticated_download_new(uri, usernameOrNull, folder, nodeName);
                logOrNull.getLogger().println(msg);
            }
        }
        boolean isZipNotGzip = uri.getPath().endsWith(".zip");
        long expectedContentLength = httpResponse.getEntity().getContentLength();
        try (BoundedInputStream bis = ((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(httpResponse.getEntity().getContent())).get();){
            try {
                if (isZipNotGzip) {
                    whereToDownloadTo.unzipFrom((InputStream)bis);
                } else {
                    whereToDownloadTo.untarFrom((InputStream)bis, FilePath.TarCompression.GZIP);
                }
            }
            catch (IOException ex) {
                String msg = Messages.AuthenticatedZipExtractionInstaller_unpack_failed(uri, bis.getCount(), expectedContentLength);
                throw new IOException(msg, ex);
            }
        }
    }

    static class HttpGetException
    extends IOException {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final String uri;
        @CheckForNull
        private final String usernameOrNull;
        @CheckForNull
        private final Integer httpStatusCodeOrNull;

        private HttpGetException(@NonNull String uri, @CheckForNull String usernameOrNull, @CheckForNull Integer httpStatusCodeOrNull, @NonNull String reason, @Nullable Throwable cause) {
            super((usernameOrNull == null ? "Anonymous" : "Authenticated") + " HTTP GET of " + uri + (String)(usernameOrNull == null ? "" : " as " + usernameOrNull) + " failed, " + reason, cause);
            this.uri = uri;
            this.usernameOrNull = usernameOrNull;
            this.httpStatusCodeOrNull = httpStatusCodeOrNull;
        }

        HttpGetException(@NonNull String uri, @CheckForNull String usernameOrNull, int httpStatusCode) {
            this(uri, usernameOrNull, httpStatusCode, Integer.toString(httpStatusCode), null);
        }

        HttpGetException(@NonNull String uri, @CheckForNull String usernameOrNull, @NonNull String reason, @Nullable Throwable cause) {
            this(uri, usernameOrNull, null, reason, cause);
        }

        HttpGetException(@NonNull String uri, @CheckForNull String usernameOrNull, @NonNull String reason) {
            this(uri, usernameOrNull, null, reason, null);
        }

        @NonNull
        public String getUri() {
            return this.uri;
        }

        @CheckForNull
        public String getUsername() {
            return this.usernameOrNull;
        }

        @CheckForNull
        public Integer getHttpStatusCode() {
            return this.httpStatusCodeOrNull;
        }
    }
}

