/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extratoolinstallers.installers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.tools.ToolInstallation;
import hudson.tools.ToolInstaller;
import hudson.tools.ToolInstallerDescriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.extratoolinstallers.installers.FindOnPathCallable;
import io.jenkins.plugins.extratoolinstallers.installers.Messages;
import io.jenkins.plugins.extratoolinstallers.installers.WrongVersionException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class IsAlreadyOnPath
extends ToolInstaller {
    @CheckForNull
    private String executableName;
    @CheckForNull
    private String relativePath;
    @CheckForNull
    private String[] versionCmd;
    @CheckForNull
    private Pattern versionPattern;
    @CheckForNull
    private String versionPatternString;
    @CheckForNull
    private String versionMin;
    @CheckForNull
    private String versionMax;

    @DataBoundConstructor
    public IsAlreadyOnPath(String label) {
        super(label);
    }

    @CheckForNull
    public String getExecutableName() {
        return Util.fixEmpty((String)this.executableName);
    }

    @DataBoundSetter
    public void setExecutableName(@Nullable String executable) {
        this.executableName = Util.fixEmpty((String)executable);
    }

    @CheckForNull
    public String getRelativePath() {
        return Util.fixEmpty((String)this.relativePath);
    }

    @DataBoundSetter
    public void setRelativePath(@Nullable String relativePath) {
        this.relativePath = Util.fixEmpty((String)relativePath);
    }

    @CheckForNull
    public String[] getVersionCmd() {
        return IsAlreadyOnPath.fixEmpty(this.versionCmd);
    }

    @NonNull
    public String getVersionCmdString() {
        CharSequence[] v = this.getVersionCmd();
        if (v == null) {
            return "";
        }
        return String.join((CharSequence)"\n", v);
    }

    public void setVersionCmd(String[] versionCmd) {
        this.versionCmd = versionCmd != null ? Arrays.copyOf(versionCmd, versionCmd.length) : null;
    }

    @DataBoundSetter
    public void setVersionCmdString(String versionCmdString) {
        this.setVersionCmd(Util.fixNull((String)versionCmdString).split("\n"));
    }

    private static String[] fixEmpty(String[] l) {
        if (l == null || l.length == 0) {
            return null;
        }
        return l;
    }

    public Pattern getVersionPattern() {
        return this.versionPattern;
    }

    public void setVersionPattern(Pattern versionPattern) {
        this.versionPattern = versionPattern;
        this.versionPatternString = null;
    }

    @CheckForNull
    public String getVersionPatternString() {
        if (this.versionPattern != null) {
            return Util.fixEmpty((String)this.versionPattern.pattern());
        }
        return Util.fixEmpty((String)this.versionPatternString);
    }

    @DataBoundSetter
    public void setVersionPatternString(String versionPatternString) {
        if (Util.fixEmpty((String)versionPatternString) != null) {
            try {
                this.versionPattern = Pattern.compile(versionPatternString);
                this.versionPatternString = null;
            }
            catch (PatternSyntaxException ex) {
                this.versionPattern = null;
                this.versionPatternString = versionPatternString;
            }
        } else {
            this.versionPattern = null;
            this.versionPatternString = null;
        }
    }

    @CheckForNull
    public String getVersionMin() {
        return this.versionMin;
    }

    @DataBoundSetter
    public void setVersionMin(String versionMin) {
        this.versionMin = versionMin;
    }

    @CheckForNull
    public String getVersionMax() {
        return this.versionMax;
    }

    @DataBoundSetter
    public void setVersionMax(String versionMax) {
        this.versionMax = versionMax;
    }

    public FilePath performInstallation(@NonNull ToolInstallation tool, @NonNull Node node, @CheckForNull TaskListener log) throws IOException, InterruptedException {
        String exeName = this.getExecutableName();
        if (exeName == null) {
            throw new IllegalArgumentException(Messages.IsAlreadyOnPath_executableNameIsEmpty());
        }
        FilePath executablePath = this.findExecutableOnNodeOrThrow(exeName, node, log);
        FilePath parent = executablePath.getParent();
        if (parent == null) {
            throw new IllegalStateException("Executable (" + exeName + ") found at '" + String.valueOf(executablePath) + "' has no parent folder");
        }
        String relPathOrNull = this.getRelativePath();
        FilePath resultToReturn = relPathOrNull == null || relPathOrNull.equals(".") ? parent : parent.child(relPathOrNull);
        String[] vCmd = this.getVersionCmd();
        Pattern vPattern = this.getVersionPattern();
        String vMax = this.getVersionMax();
        String vMin = this.getVersionMin();
        if (vCmd != null && vPattern != null && (vMin != null || vMax != null)) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            Launcher launcher = node.createLauncher(log);
            this.runCommandOnNode(launcher, resultToReturn, vCmd, output);
            String cmdOutput = output.toString(StandardCharsets.UTF_8.name());
            String parsedVersion = IsAlreadyOnPath.parseVersionCmdOutputForVersion(vPattern, cmdOutput);
            int versionComparisonResult = IsAlreadyOnPath.checkVersionIsInRange(vMin, vMax, parsedVersion);
            if (versionComparisonResult != 0) {
                throw new WrongVersionException(exeName, resultToReturn.getRemote(), parsedVersion, vMin, vMax);
            }
        }
        return resultToReturn;
    }

    @NonNull
    private FilePath findExecutableOnNodeOrThrow(@NonNull String exeName, @NonNull Node node, @CheckForNull TaskListener logOrNull) throws IOException, InterruptedException {
        FilePath rootPath = node.getRootPath();
        if (rootPath == null) {
            throw new IllegalStateException(Messages.IsAlreadyOnPath_agentIsOffline());
        }
        FindOnPathCallable nodeOperation = this.mkCallable(exeName, logOrNull);
        String absolutePathToExecutable = (String)rootPath.act((FilePath.FileCallable)nodeOperation);
        FilePath executablePath = node.createPath(absolutePathToExecutable);
        if (executablePath == null) {
            throw new IllegalStateException(Messages.IsAlreadyOnPath_agentIsOffline());
        }
        return executablePath;
    }

    @Restricted(value={NoExternalUse.class})
    void runCommandOnNode(Launcher launcher, FilePath pwd, String[] cmd, OutputStream output) throws IOException, InterruptedException {
        launcher.launch().cmds(cmd).stdout(output).pwd(pwd).join();
    }

    @Restricted(value={NoExternalUse.class})
    @NonNull
    FindOnPathCallable mkCallable(@NonNull String exeName, @CheckForNull TaskListener logOrNull) {
        return new FindOnPathCallable(exeName, logOrNull);
    }

    @Restricted(value={NoExternalUse.class})
    static String parseVersionCmdOutputForVersion(Pattern versionPattern, String cmdOutput) {
        for (String cmdLine : cmdOutput.split("\\R")) {
            Matcher matcher = versionPattern.matcher(cmdLine);
            if (!matcher.matches()) continue;
            int gc = matcher.groupCount();
            StringBuilder result = new StringBuilder();
            for (int g = 1; g <= gc; ++g) {
                String group = matcher.group(g);
                if (group == null) continue;
                result.append(group);
            }
            return result.toString();
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    static int checkVersionIsInRange(@Nullable String versionMin, @Nullable String versionMax, @Nullable String actualVersion) {
        int cmpParsedToMax;
        int cmpParsedToMin;
        if (Util.fixEmpty((String)versionMin) != null && (cmpParsedToMin = IsAlreadyOnPath.compareVersions(actualVersion, versionMin)) < 0) {
            return -1;
        }
        if (Util.fixEmpty((String)versionMax) != null && (cmpParsedToMax = IsAlreadyOnPath.compareVersions(actualVersion, versionMax)) > 0) {
            return 1;
        }
        return 0;
    }

    @Restricted(value={NoExternalUse.class})
    static int compareVersions(@Nullable String compoundVersionA, @Nullable String compoundVersionB) {
        String[] splitA = compoundVersionA == null ? new String[]{} : compoundVersionA.split("\\.", -1);
        String[] splitB = compoundVersionB == null ? new String[]{} : compoundVersionB.split("\\.", -1);
        int lengthA = splitA.length;
        int lengthB = splitB.length;
        int highestLength = Math.max(lengthA, lengthB);
        for (int i = 0; i < highestLength; ++i) {
            String partB;
            String partA = lengthA > i ? splitA[i] : null;
            int result = IsAlreadyOnPath.compareNullableVersionParts(partA, partB = lengthB > i ? splitB[i] : null);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private static int compareNullableVersionParts(@Nullable String partA, @Nullable String partB) {
        if (partA == null) {
            if (partB == null) {
                return 0;
            }
            return -1;
        }
        if (partB == null) {
            return 1;
        }
        return IsAlreadyOnPath.compareVersionParts(partA, partB);
    }

    private static int compareVersionParts(@NonNull String a, @NonNull String b) {
        long bNumber;
        String bRemainder;
        String bNumberString;
        String aRemainder;
        String aNumberString;
        int ai = IsAlreadyOnPath.findIndexOfFirstNonnumericalCharacter(a);
        int bi = IsAlreadyOnPath.findIndexOfFirstNonnumericalCharacter(b);
        if (ai >= 0) {
            aNumberString = a.substring(0, ai);
            aRemainder = a.substring(ai);
        } else {
            aNumberString = a;
            aRemainder = "";
        }
        if (bi >= 0) {
            bNumberString = b.substring(0, bi);
            bRemainder = b.substring(bi);
        } else {
            bNumberString = b;
            bRemainder = "";
        }
        long aNumber = aNumberString.isEmpty() ? -1L : Long.parseLong(aNumberString);
        long l = bNumber = bNumberString.isEmpty() ? -1L : Long.parseLong(bNumberString);
        if (aNumber > bNumber) {
            return 1;
        }
        if (aNumber < bNumber) {
            return -1;
        }
        return aRemainder.compareTo(bRemainder);
    }

    private static int findIndexOfFirstNonnumericalCharacter(@NonNull String s) {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) continue;
            return i;
        }
        return -l;
    }

    @Extension
    @Symbol(value={"findonpath"})
    public static class DescriptorImpl
    extends ToolInstallerDescriptor<IsAlreadyOnPath> {
        public String getDisplayName() {
            return Messages.IsAlreadyOnPath_DescriptorImpl_displayName();
        }

        public FormValidation doCheckExecutableName(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckVersionCmdString(@QueryParameter String value) {
            if (Util.fixEmpty((String)value) == null) {
                return FormValidation.ok((String)Messages.IsAlreadyOnPath_noVersionValidation());
            }
            if (value.contains(" ") && !value.contains("\n")) {
                return FormValidation.warning((String)Messages.IsAlreadyOnPath_versionCmdContainsSpaceButHasNoArguments());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersionPatternString(@QueryParameter String versionCmdString, @QueryParameter String versionPatternString) {
            if (Util.fixEmpty((String)versionCmdString) == null) {
                return FormValidation.ok();
            }
            if (Util.fixEmpty((String)versionPatternString) == null) {
                return FormValidation.error((String)Messages.IsAlreadyOnPath_versionPatternIsEmpty());
            }
            try {
                Pattern.compile(versionPatternString);
            }
            catch (PatternSyntaxException ex) {
                return FormValidation.error((Throwable)ex, (String)Messages.IsAlreadyOnPath_versionPatternIsInvalid(versionPatternString));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersionMin(@QueryParameter String versionCmdString, @QueryParameter String versionPatternString, @QueryParameter String versionMin, @QueryParameter String versionMax) {
            if (Util.fixEmpty((String)versionCmdString) != null && Util.fixEmpty((String)versionPatternString) != null && Util.fixEmpty((String)versionMin) == null && Util.fixEmpty((String)versionMax) == null) {
                return FormValidation.error((String)Messages.IsAlreadyOnPath_versionMinMaxNotSpecified());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersionMax(@QueryParameter String versionMin, @QueryParameter String versionMax) {
            int cmp;
            if (Util.fixEmpty((String)versionMin) != null && Util.fixEmpty((String)versionMax) != null && (cmp = IsAlreadyOnPath.compareVersions(versionMin, versionMax)) > 0) {
                return FormValidation.error((String)Messages.IsAlreadyOnPath_versionMaxMustNotBeLessThanMinimum(versionMin));
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVersionTestString(@QueryParameter String versionTestString, @QueryParameter String versionCmdString, @QueryParameter String versionPatternString, @QueryParameter String versionMin, @QueryParameter String versionMax) {
            Pattern versionPattern;
            if (Util.fixEmpty((String)versionTestString) == null) {
                return FormValidation.ok();
            }
            if (Util.fixEmpty((String)versionCmdString) == null) {
                return FormValidation.warning((String)(Messages.IsAlreadyOnPath_noVersionValidation() + "\n" + Messages.IsAlreadyOnPath_versionCmdIsEmpty()));
            }
            if (Util.fixEmpty((String)versionPatternString) == null) {
                return FormValidation.warning((String)(Messages.IsAlreadyOnPath_noVersionValidation() + "\n" + Messages.IsAlreadyOnPath_versionPatternIsEmpty()));
            }
            if (Util.fixEmpty((String)versionMin) == null && Util.fixEmpty((String)versionMax) == null) {
                return FormValidation.warning((String)(Messages.IsAlreadyOnPath_noVersionValidation() + "\n" + Messages.IsAlreadyOnPath_versionMinMaxNotSpecified()));
            }
            try {
                versionPattern = Pattern.compile(versionPatternString);
            }
            catch (PatternSyntaxException ex) {
                return FormValidation.warning((Throwable)ex, (String)(Messages.IsAlreadyOnPath_noVersionValidation() + "\n" + Messages.IsAlreadyOnPath_versionPatternIsInvalid(versionPatternString)));
            }
            String parsedVersion = IsAlreadyOnPath.parseVersionCmdOutputForVersion(versionPattern, versionTestString);
            if (Util.fixEmpty((String)parsedVersion) == null) {
                return FormValidation.warning((String)Messages.IsAlreadyOnPath_versionPatternDidNotMatch());
            }
            int versionComparisonResult = IsAlreadyOnPath.checkVersionIsInRange(versionMin, versionMax, parsedVersion);
            if (versionComparisonResult < 0) {
                return FormValidation.warning((String)Messages.IsAlreadyOnPath_versionIsTooLow(parsedVersion, versionMin));
            }
            if (versionComparisonResult > 0) {
                return FormValidation.warning((String)Messages.IsAlreadyOnPath_versionIsTooHigh(parsedVersion, versionMax));
            }
            return FormValidation.ok((String)Messages.IsAlreadyOnPath_versionIsOk(parsedVersion));
        }
    }
}

