/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extratoolinstallers.installers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

class FindOnPathCallable
extends MasterToSlaveFileCallable<String> {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String executableName;
    @CheckForNull
    private final TaskListener logOrNull;

    @Restricted(value={NoExternalUse.class})
    FindOnPathCallable(@NonNull String executableName, @CheckForNull TaskListener logOrNull) {
        this.executableName = executableName;
        this.logOrNull = logOrNull;
    }

    public String invoke(@NonNull File d, VirtualChannel channel) throws IOException, InterruptedException {
        return FindOnPathCallable.findOnPath(this.executableName, this.getPath(), this.logOrNull);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    String getPath() {
        return System.getenv("PATH");
    }

    @NonNull
    private static String findOnPath(@NonNull String executableName, @CheckForNull String pathToSearch, @CheckForNull TaskListener logOrNull) throws IOException, InterruptedException {
        String[] pathElements;
        String path = Util.fixNull((String)pathToSearch);
        for (String dirOnPath : pathElements = path.split(File.pathSeparator)) {
            File possibleExecutable = new File(dirOnPath, executableName);
            if (!possibleExecutable.isFile() || !possibleExecutable.canExecute()) continue;
            return possibleExecutable.getAbsolutePath();
        }
        throw new ExecutableNotOnPathException(executableName, path);
    }

    @Restricted(value={NoExternalUse.class})
    static class ExecutableNotOnPathException
    extends IOException {
        private static final long serialVersionUID = 1L;
        @NonNull
        private final String executableName;
        @NonNull
        private final String path;

        private ExecutableNotOnPathException(@NonNull String executableName, @NonNull String path, @Nullable Throwable cause) {
            super("Executable '" + executableName + "' not found on PATH, " + path, cause);
            this.executableName = executableName;
            this.path = path;
        }

        ExecutableNotOnPathException(@NonNull String executableName, @NonNull String path) {
            this(executableName, path, null);
        }

        public String getExecutableName() {
            return this.executableName;
        }

        public String getPath() {
            return this.path;
        }
    }
}

