/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extended_timer_trigger;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.PeriodicWork;
import hudson.scheduler.Hash;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.extended_timer_trigger.CronTabWrapper;
import io.jenkins.plugins.extended_timer_trigger.ExtendedCronTabList;
import io.jenkins.plugins.extended_timer_trigger.Messages;
import io.jenkins.plugins.extended_timer_trigger.ParamStaplerRequest;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.triggers.TriggeredItem;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;

@Restricted(value={NoExternalUse.class})
public class ExtendedTimerTrigger
extends Trigger<Job<?, ?>> {
    private static final Logger LOGGER = Logger.getLogger(ExtendedTimerTrigger.class.getName());
    private transient ExtendedCronTabList extendedCronTabList;
    private final String cronSpec;

    @DataBoundConstructor
    public ExtendedTimerTrigger(@NonNull String cronSpec) {
        this.cronSpec = cronSpec;
        this.extendedCronTabList = ExtendedCronTabList.create(cronSpec, null);
    }

    public String getCronSpec() {
        return this.cronSpec;
    }

    public void start(Job<?, ?> project, boolean newInstance) {
        this.job = project;
        Hash hash = Hash.from((String)project.getFullName());
        if (this.cronSpec != null) {
            try {
                this.extendedCronTabList = ExtendedCronTabList.create(this.cronSpec, hash);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                LOGGER.log(Level.WARNING, String.format("Failed to parse crontab spec %s in job %s", this.cronSpec, project.getFullName()), e);
            }
        }
    }

    public void run() {
    }

    private List<ParameterValue> configureParameterValues(Map<String, String> parameterValues) {
        assert (this.job != null) : "job must not be null if this was 'started'";
        ParametersDefinitionProperty paramDefProp = (ParametersDefinitionProperty)((Job)this.job).getProperty(ParametersDefinitionProperty.class);
        ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
        for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
            ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
            if (parameterValues.containsKey(paramDefinition.getName())) {
                ParamStaplerRequest request = new ParamStaplerRequest(parameterValues.get(paramDefinition.getName()));
                ParameterValue value = paramDefinition.createValue((StaplerRequest2)request);
                if (value != null) {
                    defValues.add(value);
                    continue;
                }
                LOGGER.warning("Cannot create value for " + paramDefinition.getName());
                continue;
            }
            if (defaultValue == null) continue;
            defValues.add(defaultValue);
        }
        return defValues;
    }

    public void checkAndRun(ZonedDateTime time) {
        if (this.extendedCronTabList != null) {
            List<CronTabWrapper> cronTabWrapperList = this.extendedCronTabList.getCronTabWrapperList();
            cronTabWrapperList.stream().filter(it -> it.check(time)).forEach(cronTab -> {
                Item patt0$temp;
                Map<String, String> parameters = cronTab.getParameters();
                ArrayList<Object> actions = new ArrayList<Object>();
                actions.add(new CauseAction((Cause)new ExtendenTimerTriggerCause()));
                if (parameters != null) {
                    actions.add(new ParametersAction(this.configureParameterValues(parameters)));
                }
                if ((patt0$temp = this.job) instanceof AbstractProject) {
                    AbstractProject project = (AbstractProject)patt0$temp;
                    project.scheduleBuild2(0, actions.toArray(new Action[0]));
                } else {
                    Item patt1$temp = this.job;
                    if (patt1$temp instanceof WorkflowJob) {
                        WorkflowJob pipeline = (WorkflowJob)patt1$temp;
                        pipeline.scheduleBuild2(0, actions.toArray(new Action[0]));
                    }
                }
            });
        }
    }

    public static class ExtendenTimerTriggerCause
    extends TimerTrigger.TimerTriggerCause {
        public String getShortDescription() {
            return Messages.ExtendedTimerTriggerTimerTrigger_ExtendedTimerTriggerCause_ShortDescription();
        }
    }

    @Extension
    public static class CronWork
    extends PeriodicWork {
        ZonedDateTime zdt = this.zdt.minusSeconds(this.zdt.getSecond()).plusMinutes(1L);

        public long getRecurrencePeriod() {
            return 60000L;
        }

        public long getInitialDelay() {
            return 60000L - TimeUnit.SECONDS.toMillis(Calendar.getInstance().get(13));
        }

        public void doRun() {
            ZonedDateTime now = ZonedDateTime.now();
            while (now.isAfter(this.zdt)) {
                this.checkTriggers(this.zdt);
                this.zdt = this.zdt.plusMinutes(1L);
            }
        }

        private void checkTriggers(ZonedDateTime time) {
            Jenkins jenkins = Jenkins.get();
            jenkins.allItems(TriggeredItem.class).forEach(item -> {
                for (Trigger t : item.getTriggers().values()) {
                    if (!(t instanceof ExtendedTimerTrigger)) continue;
                    ExtendedTimerTrigger trigger = (ExtendedTimerTrigger)t;
                    trigger.checkAndRun(time);
                }
            });
        }
    }

    @Extension
    @Symbol(value={"extendedCron"})
    public static class DescriptorImpl
    extends TriggerDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.ExtendedTimerTrigger_DisplayName();
        }

        public boolean isApplicable(Item item) {
            return item instanceof BuildableItem;
        }

        @POST
        public FormValidation doCheckCronSpec(@QueryParameter String value, @AncestorInPath Item item) {
            try {
                ExtendedCronTabList ectl = ExtendedCronTabList.create(Util.fixNull((String)value), item != null ? Hash.from((String)item.getFullName()) : null);
                ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
                this.updateValidationsForSanity(validations, ectl);
                this.updateValidationsForNextRun(validations, ectl);
                return FormValidation.aggregate(validations);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalArgumentException e) {
                return FormValidation.error((Throwable)e, (String)e.getMessage());
            }
        }

        private void updateValidationsForSanity(Collection<FormValidation> validations, ExtendedCronTabList ectl) {
            String msg = ectl.checkSanity();
            if (msg != null) {
                validations.add(FormValidation.warning((String)msg));
            }
        }

        private void updateValidationsForNextRun(Collection<FormValidation> validations, ExtendedCronTabList ectl) {
            ZonedDateTime prev = ectl.previous();
            ZonedDateTime next = ectl.next();
            if (prev != null && next != null) {
                Locale locale = Stapler.getCurrentRequest2() != null ? Stapler.getCurrentRequest2().getLocale() : Locale.getDefault();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, d MMM yyyy HH:mm zzz", locale);
                validations.add(FormValidation.ok((String)Messages.ExtendedTimerTrigger_would_last_have_run_at_would_next_run_at(prev.format(formatter), next.format(formatter))));
            } else {
                validations.add(FormValidation.warning((String)Messages.ExtendedTimerTrigger_no_schedules_so_will_never_run()));
            }
        }
    }
}

