/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.extended_timer_trigger;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.scheduler.CronTabList;
import io.jenkins.plugins.extended_timer_trigger.ExtendedCronTab;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;

@Restricted(value={NoExternalUse.class})
public class CronTabWrapper {
    private final CronTabList cronTab;
    private final ExtendedCronTab extendedCronTab;
    private Map<String, String> parameters;

    public CronTabWrapper(CronTabList cronTab) {
        this.cronTab = cronTab;
        this.extendedCronTab = null;
    }

    public CronTabWrapper(ExtendedCronTab extendedCronTab) {
        this.extendedCronTab = extendedCronTab;
        this.cronTab = null;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @CheckForNull
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean check(ZonedDateTime time) {
        if (this.cronTab != null) {
            GregorianCalendar cal = GregorianCalendar.from(time);
            return this.cronTab.check((Calendar)cal);
        }
        if (this.extendedCronTab != null) {
            return this.extendedCronTab.check(time);
        }
        return false;
    }

    @CheckForNull
    @SuppressRestrictedWarnings(value={CronTabList.class})
    public ZonedDateTime previous() {
        if (this.cronTab != null) {
            Calendar scheduled = this.cronTab.previous();
            if (scheduled != null) {
                return ZonedDateTime.ofInstant(scheduled.toInstant(), scheduled.getTimeZone().toZoneId());
            }
        } else if (this.extendedCronTab != null) {
            return this.extendedCronTab.previous();
        }
        return null;
    }

    @SuppressRestrictedWarnings(value={CronTabList.class})
    public ZonedDateTime next() {
        if (this.cronTab != null) {
            Calendar scheduled = this.cronTab.next();
            if (scheduled != null) {
                return ZonedDateTime.ofInstant(scheduled.toInstant(), scheduled.getTimeZone().toZoneId());
            }
        } else if (this.extendedCronTab != null) {
            return this.extendedCronTab.next();
        }
        return null;
    }

    @CheckForNull
    public String checkSanity() {
        if (this.cronTab != null) {
            return this.cronTab.checkSanity();
        }
        return null;
    }
}

