/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error.provider;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.googleai.GoogleAiGeminiChatModel;
import dev.langchain4j.service.AiServices;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class GeminiProvider
extends BaseAIProvider {
    private static final Logger LOGGER = Logger.getLogger(GeminiProvider.class.getName());
    private Secret apiKey;

    @DataBoundConstructor
    public GeminiProvider(String url, String model, Secret apiKey) {
        super(url, model);
        this.apiKey = apiKey;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    @Override
    public BaseAIProvider.Assistant createAssistant() {
        GoogleAiGeminiChatModel model = GoogleAiGeminiChatModel.builder().baseUrl(Util.fixEmptyAndTrim((String)this.getUrl())).apiKey(this.getApiKey().getPlainText()).modelName(this.getModel()).temperature(Double.valueOf(0.3)).logRequests(Boolean.valueOf(LOGGER.isLoggable(Level.FINE))).logResponses(Boolean.valueOf(LOGGER.isLoggable(Level.FINE))).build();
        return (BaseAIProvider.Assistant)AiServices.create(BaseAIProvider.Assistant.class, (ChatModel)model);
    }

    @Override
    public boolean isNotValid(@CheckForNull TaskListener listener) {
        if (listener != null) {
            if (Util.fixEmptyAndTrim((String)Secret.toString((Secret)this.getApiKey())) == null) {
                listener.getLogger().println("No Api key configured for Gemini.");
            } else if (Util.fixEmptyAndTrim((String)this.getModel()) == null) {
                listener.getLogger().println("No Model configured for Gemini.");
            }
        }
        return Util.fixEmptyAndTrim((String)Secret.toString((Secret)this.getApiKey())) == null || Util.fixEmptyAndTrim((String)this.getModel()) == null;
    }

    @Extension
    @Symbol(value={"gemini"})
    public static class DescriptorImpl
    extends BaseAIProvider.BaseProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Google Gemini";
        }

        @Override
        public String getDefaultModel() {
            return "gemini-2.0-flash";
        }

        @POST
        public FormValidation doTestConfiguration(@QueryParameter(value="apiKey") Secret apiKey, @QueryParameter(value="url") String url, @QueryParameter(value="model") String model) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                GeminiProvider provider = new GeminiProvider(url, model, apiKey);
                String testResponse = provider.explainError("Send 'Configuration test successful' to me.");
                if (testResponse != null && testResponse.contains("Configuration test successful")) {
                    return FormValidation.ok((String)"Configuration test successful! API connection is working properly.");
                }
                if (testResponse != null && testResponse.contains("AI API Error:")) {
                    return FormValidation.error((String)testResponse);
                }
                if (testResponse != null && testResponse.contains("Failed to get explanation from AI service")) {
                    return FormValidation.error((String)testResponse);
                }
                if (testResponse != null && testResponse.contains("Unable to create assistant")) {
                    return FormValidation.error((String)testResponse);
                }
                return FormValidation.error((String)"Connection failed: No valid response received from AI service.");
            }
            catch (IOException e) {
                return FormValidation.error((String)("Connection failed: " + e.getMessage() + ". Please check your API URL and network connection."));
            }
            catch (Exception e) {
                return FormValidation.error((String)("Test failed: " + e.getMessage()));
            }
        }
    }
}

