/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import io.jenkins.plugins.explain_error.ErrorExplanationAction;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ErrorExplainer {
    private String providerName;
    private static final Logger LOGGER = Logger.getLogger(ErrorExplainer.class.getName());

    public String getProviderName() {
        return this.providerName;
    }

    public void explainError(Run<?, ?> run, TaskListener listener, String logPattern, int maxLines) {
        String jobInfo = run != null ? "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]" : "[unknown]";
        try {
            GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
            if (!config.isEnableExplanation()) {
                listener.getLogger().println("AI error explanation is disabled in global configuration.");
                return;
            }
            BaseAIProvider provider = config.getAiProvider();
            if (provider.isNotValid(listener)) {
                listener.getLogger().println("ERROR: The provider is not properly configured.");
                return;
            }
            String errorLogs = this.extractErrorLogs(run, logPattern, maxLines);
            if (StringUtils.isBlank((CharSequence)errorLogs)) {
                listener.getLogger().println("No error logs found to explain.");
                return;
            }
            String explanation = provider.explainError(errorLogs);
            LOGGER.fine(jobInfo + " AI error explanation succeeded.");
            ErrorExplanationAction action = new ErrorExplanationAction(explanation, errorLogs, provider.getProviderName());
            run.addOrReplaceAction((Action)action);
        }
        catch (Exception e) {
            LOGGER.severe(jobInfo + " Failed to explain error: " + e.getMessage());
            listener.getLogger().println(jobInfo + " Failed to explain error: " + e.getMessage());
        }
    }

    private String extractErrorLogs(Run<?, ?> run, String logPattern, int maxLines) throws IOException {
        List logLines = run.getLog(maxLines);
        if (StringUtils.isBlank((CharSequence)logPattern)) {
            return String.join((CharSequence)"\n", logLines);
        }
        Pattern pattern = Pattern.compile(logPattern, 2);
        StringBuilder errorLogs = new StringBuilder();
        for (String line : logLines) {
            if (!pattern.matcher(line).find()) continue;
            errorLogs.append(line).append("\n");
        }
        return errorLogs.toString();
    }

    public String explainErrorText(String errorText, Run<?, ?> run) {
        String jobInfo = run != null ? "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]" : "[unknown]";
        try {
            GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
            if (!config.isEnableExplanation()) {
                LOGGER.fine("AI error explanation is disabled in global configuration");
                return "AI error explanation is disabled in global configuration.";
            }
            BaseAIProvider provider = config.getAiProvider();
            if (provider.isNotValid((TaskListener)new LogTaskListener(LOGGER, Level.FINE))) {
                return "ERROR: Provider is not properly configured.";
            }
            if (StringUtils.isBlank((CharSequence)errorText)) {
                LOGGER.fine("No error text provided");
                return "No error text provided to explain.";
            }
            String explanation = provider.explainError(errorText);
            LOGGER.fine(jobInfo + " AI error explanation succeeded.");
            LOGGER.finer("Explanation length: " + (explanation != null ? explanation.length() : 0));
            this.providerName = provider.getProviderName();
            return explanation;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, jobInfo + " Failed to explain error text: " + e.getMessage(), e);
            return "Failed to explain error: " + e.getMessage();
        }
    }
}

