/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.explain_error.AIProvider;
import io.jenkins.plugins.explain_error.AIService;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"explainError"})
public class GlobalConfigurationImpl
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalConfigurationImpl.class.getName());
    private Secret apiKey;
    private AIProvider provider = AIProvider.OPENAI;
    private String apiUrl;
    private String model;
    private boolean enableExplanation = true;

    public GlobalConfigurationImpl() {
        this.load();
    }

    public static GlobalConfigurationImpl get() {
        return (GlobalConfigurationImpl)Jenkins.get().getDescriptorByType(GlobalConfigurationImpl.class);
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        try {
            if (json.has("enableExplanation")) {
                this.enableExplanation = json.getBoolean("enableExplanation");
            }
            if (json.has("provider")) {
                String providerStr = json.getString("provider");
                try {
                    this.provider = AIProvider.valueOf(providerStr);
                }
                catch (IllegalArgumentException e) {
                    throw new Descriptor.FormException("Invalid provider: " + providerStr, "provider");
                }
            }
            if (json.has("apiKey")) {
                String apiKeyStr = json.getString("apiKey");
                this.apiKey = Secret.fromString((String)apiKeyStr);
            }
            if (json.has("apiUrl")) {
                this.apiUrl = json.getString("apiUrl");
            }
            if (json.has("model")) {
                this.model = json.getString("model");
            }
            this.save();
            return true;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Configuration failed", e);
            throw new Descriptor.FormException("Configuration failed: " + e.getMessage(), (Throwable)e, "");
        }
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    @DataBoundSetter
    public void setApiKey(Secret apiKey) {
        this.apiKey = apiKey;
    }

    public AIProvider getProvider() {
        return this.provider != null ? this.provider : AIProvider.OPENAI;
    }

    @DataBoundSetter
    public void setProvider(AIProvider provider) {
        this.provider = provider;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    @DataBoundSetter
    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getModel() {
        return this.model;
    }

    public String getRawModel() {
        return this.model;
    }

    @DataBoundSetter
    public void setModel(String model) {
        this.model = model;
    }

    public boolean isEnableExplanation() {
        return this.enableExplanation;
    }

    @DataBoundSetter
    public void setEnableExplanation(boolean enableExplanation) {
        this.enableExplanation = enableExplanation;
    }

    public String getDisplayName() {
        return "Explain Error Plugin Configuration";
    }

    public AIProvider[] getProviderValues() {
        return AIProvider.values();
    }

    @RequirePOST
    public ListBoxModel doFillProviderItems() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        ListBoxModel model = new ListBoxModel();
        AIProvider currentProvider = this.getProvider();
        for (AIProvider p : AIProvider.values()) {
            model.add((Object)new ListBoxModel.Option(p.getDisplayName(), p.name(), p == currentProvider));
        }
        return model;
    }

    @RequirePOST
    public FormValidation doTestConfiguration(@QueryParameter(value="apiKey") String apiKey, @QueryParameter(value="provider") String provider, @QueryParameter(value="apiUrl") String apiUrl, @QueryParameter(value="model") String model) {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        Secret testApiKeySecret = apiKey != null ? Secret.fromString((String)apiKey) : null;
        AIProvider testProvider = null;
        if (provider != null && !provider.isEmpty()) {
            try {
                testProvider = AIProvider.valueOf(provider);
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)("Invalid provider: " + provider));
            }
        }
        String testApiUrl = apiUrl != null ? apiUrl : "";
        String testModel = model != null ? model : "";
        try {
            GlobalConfigurationImpl tempConfig = new GlobalConfigurationImpl();
            tempConfig.setApiKey(testApiKeySecret);
            if (testProvider != null) {
                tempConfig.setProvider(testProvider);
            }
            tempConfig.setApiUrl(testApiUrl);
            tempConfig.setModel(testModel);
            AIService aiService = new AIService(tempConfig);
            String testResponse = aiService.explainError("Send 'Configuration test successful' to me.");
            if (testResponse != null && testResponse.contains("Configuration test successful")) {
                return FormValidation.ok((String)"Configuration test successful! API connection is working properly.");
            }
            if (testResponse != null && testResponse.contains("AI API Error:")) {
                return FormValidation.error((String)testResponse);
            }
            if (testResponse != null && testResponse.contains("Failed to get explanation from AI service")) {
                return FormValidation.error((String)testResponse);
            }
            if (testResponse != null && testResponse.contains("Unable to create assistant")) {
                return FormValidation.error((String)testResponse);
            }
            return FormValidation.error((String)"Connection failed: No valid response received from AI service.");
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "API test failed", e);
            return FormValidation.error((String)("Connection failed: " + e.getMessage() + ". Please check your API URL and network connection."));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Configuration test failed", e);
            return FormValidation.error((String)("Test failed: " + e.getMessage()));
        }
    }
}

