/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseAIService {
    protected static final Logger LOGGER = Logger.getLogger(BaseAIService.class.getName());
    protected final GlobalConfigurationImpl config;

    public BaseAIService(GlobalConfigurationImpl config) {
        this.config = config;
    }

    public String explainError(String errorLogs) throws IOException {
        Assistant assistant;
        if (StringUtils.isBlank((CharSequence)errorLogs)) {
            return "No error logs provided for explanation.";
        }
        try {
            assistant = this.createAssistant();
        }
        catch (Exception e) {
            return "Unable to create assistant api-key or model is invalid.";
        }
        PromptTemplate promptTemplate = PromptTemplate.from((String)"You are an expert Jenkins administrator and software engineer. Please analyze the following Jenkins build error logs and provide a clear, actionable explanation of what went wrong and how to fix it:\n\nERROR LOGS:\n{{errorLogs}}\n\nPlease provide:\n1. A summary of what caused the error\n2. Specific steps to resolve the issue\n3. Any relevant best practices to prevent similar issues\n\nKeep your response concise and focused on actionable solutions. Use plain text formatting only - no markdown, bold text, italic text, or special symbols for formatting.");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("errorLogs", errorLogs);
        Prompt prompt = promptTemplate.apply(variables);
        try {
            return assistant.chat(prompt.text());
        }
        catch (Exception e) {
            LOGGER.severe("AI API request failed: " + e.getMessage());
            return "Failed to communicate with AI service: " + e.getMessage();
        }
    }

    protected String determineBaseUrl(String providerName) {
        String baseUrl;
        String string = baseUrl = this.config.getApiUrl() != null && !this.config.getApiUrl().trim().isEmpty() ? this.config.getApiUrl() : null;
        if (baseUrl != null) {
            LOGGER.info("Using custom " + providerName + " API URL: " + baseUrl);
        }
        return baseUrl;
    }

    protected abstract Assistant createAssistant();

    static interface Assistant {
        public String chat(String var1);
    }
}

