/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.Extension;
import hudson.model.PageDecorator;
import hudson.model.Run;
import io.jenkins.plugins.explain_error.ErrorExplanationAction;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.Stapler;

@Extension
public class ConsolePageDecorator
extends PageDecorator {
    public boolean isExplainErrorEnabled() {
        GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
        if (!config.isEnableExplanation()) {
            return false;
        }
        return !config.getAiProvider().isNotValid(null);
    }

    public String getProviderName() {
        return GlobalConfigurationImpl.get().getAiProvider().getProviderName();
    }

    public boolean isPluginActive() {
        String uri = Stapler.getCurrentRequest2().getRequestURI();
        return uri.matches(".*/console(Full)?$");
    }

    public String getRunUrl() {
        Object object;
        Ancestor ancestor = Stapler.getCurrentRequest2().findAncestor(Run.class);
        if (ancestor != null && (object = ancestor.getObject()) instanceof Run) {
            Run run = (Run)object;
            return run.getUrl();
        }
        return null;
    }

    public ErrorExplanationAction getExistingExplanation() {
        Object object;
        Ancestor ancestor = Stapler.getCurrentRequest2().findAncestor(Run.class);
        if (ancestor != null && (object = ancestor.getObject()) instanceof Run) {
            Run run = (Run)object;
            return (ErrorExplanationAction)run.getAction(ErrorExplanationAction.class);
        }
        return null;
    }
}

