/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import io.jenkins.plugins.explain_error.ErrorExplanationAction;
import io.jenkins.plugins.explain_error.ExplainErrorFolderProperty;
import io.jenkins.plugins.explain_error.ExplanationException;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import io.jenkins.plugins.explain_error.PipelineLogExtractor;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ErrorExplainer {
    private String providerName;
    private String urlString;
    private static final Logger LOGGER = Logger.getLogger(ErrorExplainer.class.getName());

    public String getProviderName() {
        return this.providerName;
    }

    public String explainError(Run<?, ?> run, TaskListener listener, String logPattern, int maxLines) {
        return this.explainError(run, listener, logPattern, maxLines, null);
    }

    public String explainError(Run<?, ?> run, TaskListener listener, String logPattern, int maxLines, String language) {
        String jobInfo = run != null ? "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]" : "[unknown]";
        try {
            if (!this.isExplanationEnabled(run)) {
                listener.getLogger().println("AI error explanation is disabled.");
                return null;
            }
            BaseAIProvider provider = this.resolveProvider(run);
            if (provider == null) {
                listener.getLogger().println("No AI provider configured.");
                return null;
            }
            String errorLogs = this.extractErrorLogs(run, logPattern, maxLines);
            try {
                String explanation = provider.explainError(errorLogs, listener, language);
                LOGGER.fine(jobInfo + " AI error explanation succeeded.");
                ErrorExplanationAction action = new ErrorExplanationAction(explanation, this.urlString, errorLogs, provider.getProviderName());
                run.addOrReplaceAction((Action)action);
                return explanation;
            }
            catch (ExplanationException ee) {
                listener.getLogger().println(ee.getMessage());
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.severe(jobInfo + " Failed to explain error: " + e.getMessage());
            listener.getLogger().println(jobInfo + " Failed to explain error: " + e.getMessage());
            return null;
        }
    }

    private String extractErrorLogs(Run<?, ?> run, String logPattern, int maxLines) throws IOException {
        PipelineLogExtractor logExtractor = new PipelineLogExtractor(run, maxLines);
        List<String> logLines = logExtractor.getFailedStepLog();
        this.urlString = logExtractor.getUrl();
        if (StringUtils.isBlank((CharSequence)logPattern)) {
            return String.join((CharSequence)"\n", logLines);
        }
        Pattern pattern = Pattern.compile(logPattern, 2);
        StringBuilder errorLogs = new StringBuilder();
        for (String line : logLines) {
            if (!pattern.matcher(line).find()) continue;
            errorLogs.append(line).append("\n");
        }
        return errorLogs.toString();
    }

    public ErrorExplanationAction explainErrorText(String errorText, String url, @NonNull Run<?, ?> run) throws IOException, ExplanationException {
        String jobInfo = "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]";
        if (!this.isExplanationEnabled(run)) {
            throw new ExplanationException("error", "AI error explanation is disabled.");
        }
        BaseAIProvider provider = this.resolveProvider(run);
        if (provider == null) {
            throw new ExplanationException("error", "No AI provider configured.");
        }
        String explanation = provider.explainError(errorText, (TaskListener)new LogTaskListener(LOGGER, Level.FINE));
        LOGGER.fine(jobInfo + " AI error explanation succeeded.");
        LOGGER.finer("Explanation length: " + explanation.length());
        this.providerName = provider.getProviderName();
        ErrorExplanationAction action = new ErrorExplanationAction(explanation, url, errorText, provider.getProviderName());
        run.addOrReplaceAction((Action)action);
        run.save();
        return action;
    }

    @CheckForNull
    private BaseAIProvider resolveProvider(@CheckForNull Run<?, ?> run) {
        BaseAIProvider folderProvider;
        if (run != null && (folderProvider = ExplainErrorFolderProperty.findFolderProvider(run.getParent().getParent())) != null) {
            String jobInfo = "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]";
            LOGGER.fine(jobInfo + " Using FOLDER-LEVEL AI provider: " + folderProvider.getProviderName() + ", Model: " + folderProvider.getModel());
            return folderProvider;
        }
        GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
        BaseAIProvider globalProvider = config.getAiProvider();
        if (globalProvider != null) {
            String jobInfo = run != null ? "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]" : "[unknown]";
            LOGGER.fine(jobInfo + " Using GLOBAL AI provider: " + globalProvider.getProviderName() + ", Model: " + globalProvider.getModel());
        }
        return globalProvider;
    }

    private boolean isExplanationEnabled(@CheckForNull Run<?, ?> run) {
        if (run != null) {
            ExplainErrorFolderProperty folderProperty = this.findFolderPropertyWithProvider(run.getParent().getParent());
            if (folderProperty != null) {
                boolean folderEnabled = folderProperty.isEnableExplanation();
                if (!folderEnabled) {
                    LOGGER.info("Error explanation explicitly disabled at folder level for " + run.getParent().getFullName());
                } else {
                    LOGGER.info("Error explanation enabled at folder level for " + run.getParent().getFullName());
                }
                return folderEnabled;
            }
            LOGGER.info("No folder-level provider found for " + run.getParent().getFullName() + ", falling back to global configuration");
        }
        GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
        boolean globalEnabled = config.isEnableExplanation();
        LOGGER.info("Global configuration enabled: " + globalEnabled);
        return globalEnabled;
    }

    @CheckForNull
    private ExplainErrorFolderProperty findFolderPropertyWithProvider(@CheckForNull ItemGroup<?> itemGroup) {
        if (itemGroup == null) {
            return null;
        }
        if (itemGroup instanceof AbstractFolder) {
            AbstractFolder folder = (AbstractFolder)itemGroup;
            ExplainErrorFolderProperty property = (ExplainErrorFolderProperty)folder.getProperties().get(ExplainErrorFolderProperty.class);
            if (property != null) {
                LOGGER.info("Found folder property for " + folder.getFullName() + ", enableExplanation=" + property.isEnableExplanation() + ", hasProvider=" + (property.getAiProvider() != null));
            }
            if (property != null && property.getAiProvider() != null) {
                LOGGER.info("Using folder-level provider from " + folder.getFullName());
                return property;
            }
            return this.findFolderPropertyWithProvider(folder.getParent());
        }
        return null;
    }
}

