/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error.provider;

import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.openai.OpenAiChatModel;
import dev.langchain4j.service.AiServices;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AutoCompletionCandidates;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.explain_error.ExplanationException;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.GET;
import org.kohsuke.stapler.verb.POST;

public class DeepSeekProvider
extends BaseAIProvider {
    private static final Logger LOGGER = Logger.getLogger(DeepSeekProvider.class.getName());
    private static final String DEFAULT_URL = "https://api.deepseek.com";
    protected Secret apiKey;

    @DataBoundConstructor
    public DeepSeekProvider(String url, String model, Secret apiKey) {
        super(url, model);
        this.apiKey = apiKey;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    @Override
    public BaseAIProvider.Assistant createAssistant() {
        String baseUrl = Util.fixEmptyAndTrim((String)this.getUrl());
        if (baseUrl == null) {
            baseUrl = DEFAULT_URL;
        }
        OpenAiChatModel model = OpenAiChatModel.builder().baseUrl(baseUrl).apiKey(this.getApiKey().getPlainText()).modelName(this.getModel()).temperature(Double.valueOf(0.3)).responseFormat(ResponseFormat.JSON).strictJsonSchema(Boolean.valueOf(true)).logRequests(Boolean.valueOf(LOGGER.isLoggable(Level.FINE))).logResponses(Boolean.valueOf(LOGGER.isLoggable(Level.FINE))).build();
        return (BaseAIProvider.Assistant)AiServices.create(BaseAIProvider.Assistant.class, (ChatModel)model);
    }

    @Override
    public boolean isNotValid(@CheckForNull TaskListener listener) {
        if (listener != null) {
            if (Util.fixEmptyAndTrim((String)Secret.toString((Secret)this.getApiKey())) == null) {
                listener.getLogger().println("No Api key configured for DeepSeek.");
            } else if (Util.fixEmptyAndTrim((String)this.getModel()) == null) {
                listener.getLogger().println("No Model configured for DeepSeek.");
            }
        }
        return Util.fixEmptyAndTrim((String)Secret.toString((Secret)this.getApiKey())) == null || Util.fixEmptyAndTrim((String)this.getModel()) == null;
    }

    @Extension
    @Symbol(value={"deepseek"})
    public static class DescriptorImpl
    extends BaseAIProvider.BaseProviderDescriptor {
        private static final String[] MODELS = new String[]{"deepseek-chat", "deepseek-coder", "deepseek-reasoner"};

        @NonNull
        public String getDisplayName() {
            return "DeepSeek";
        }

        @Override
        public String getDefaultModel() {
            return "deepseek-chat";
        }

        @GET
        public AutoCompletionCandidates doAutoCompleteModel(@QueryParameter String value) {
            AutoCompletionCandidates c = new AutoCompletionCandidates();
            for (String model : MODELS) {
                if (!model.toLowerCase().startsWith(value.toLowerCase())) continue;
                c.add(model);
            }
            return c;
        }

        @POST
        public FormValidation doTestConfiguration(@QueryParameter(value="apiKey") Secret apiKey, @QueryParameter(value="url") String url, @QueryParameter(value="model") String model) throws ExplanationException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            DeepSeekProvider provider = new DeepSeekProvider(url, model, apiKey);
            try {
                provider.explainError("Send 'Configuration test successful' to me.", null);
                return FormValidation.ok((String)"Configuration test successful! API connection is working properly.");
            }
            catch (ExplanationException e) {
                return FormValidation.error((String)("Configuration test failed: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
    }
}

