/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.Extension;
import hudson.util.Secret;
import io.jenkins.plugins.explain_error.AIProvider;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import io.jenkins.plugins.explain_error.provider.GeminiProvider;
import io.jenkins.plugins.explain_error.provider.OllamaProvider;
import io.jenkins.plugins.explain_error.provider.OpenAIProvider;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
@Symbol(value={"explainError"})
public class GlobalConfigurationImpl
extends GlobalConfiguration {
    private transient Secret apiKey;
    private transient AIProvider provider;
    private transient String apiUrl;
    private transient String model;
    private boolean enableExplanation = true;
    private String customContext;
    private BaseAIProvider aiProvider;

    public GlobalConfigurationImpl() {
        this.load();
    }

    public static GlobalConfigurationImpl get() {
        return (GlobalConfigurationImpl)Jenkins.get().getDescriptorByType(GlobalConfigurationImpl.class);
    }

    public Object readResolve() {
        if (this.aiProvider == null && this.provider != null) {
            this.aiProvider = switch (this.provider) {
                default -> throw new IncompatibleClassChangeError();
                case AIProvider.OPENAI -> new OpenAIProvider(this.apiUrl, this.model, this.apiKey);
                case AIProvider.GEMINI -> new GeminiProvider(this.apiUrl, this.model, this.apiKey);
                case AIProvider.OLLAMA -> new OllamaProvider(this.apiUrl, this.model);
            };
            this.save();
        }
        return this;
    }

    public BaseAIProvider getAiProvider() {
        if (this.aiProvider == null) {
            this.readResolve();
        }
        return this.aiProvider;
    }

    public void setAiProvider(BaseAIProvider aiProvider) {
        this.aiProvider = aiProvider;
        this.save();
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    @DataBoundSetter
    public void setApiKey(Secret apiKey) {
        this.apiKey = apiKey;
    }

    public AIProvider getProvider() {
        return this.provider;
    }

    @DataBoundSetter
    public void setProvider(AIProvider provider) {
        this.provider = provider;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    @DataBoundSetter
    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getModel() {
        return this.model;
    }

    public String getRawModel() {
        return this.model;
    }

    @DataBoundSetter
    public void setModel(String model) {
        this.model = model;
    }

    public boolean isEnableExplanation() {
        return this.enableExplanation;
    }

    @DataBoundSetter
    public void setEnableExplanation(boolean enableExplanation) {
        this.enableExplanation = enableExplanation;
    }

    public String getCustomContext() {
        return this.customContext;
    }

    @DataBoundSetter
    public void setCustomContext(String customContext) {
        this.customContext = customContext;
        this.save();
    }

    public String getDisplayName() {
        return "Explain Error Plugin Configuration";
    }
}

