/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import io.jenkins.plugins.explain_error.ErrorExplanationAction;
import io.jenkins.plugins.explain_error.ExplanationException;
import io.jenkins.plugins.explain_error.GlobalConfigurationImpl;
import io.jenkins.plugins.explain_error.PipelineLogExtractor;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ErrorExplainer {
    private String providerName;
    private String urlString;
    private static final Logger LOGGER = Logger.getLogger(ErrorExplainer.class.getName());

    public String getProviderName() {
        return this.providerName;
    }

    public String explainError(Run<?, ?> run, TaskListener listener, String logPattern, int maxLines) {
        return this.explainError(run, listener, logPattern, maxLines, null, null);
    }

    public String explainError(Run<?, ?> run, TaskListener listener, String logPattern, int maxLines, String language) {
        return this.explainError(run, listener, logPattern, maxLines, language, null);
    }

    public String explainError(Run<?, ?> run, TaskListener listener, String logPattern, int maxLines, String language, String customContext) {
        String jobInfo = run != null ? "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]" : "[unknown]";
        try {
            GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
            if (!config.isEnableExplanation()) {
                listener.getLogger().println("AI error explanation is disabled in global configuration.");
                return null;
            }
            BaseAIProvider provider = config.getAiProvider();
            String errorLogs = this.extractErrorLogs(run, logPattern, maxLines);
            String effectiveCustomContext = StringUtils.isNotBlank((CharSequence)customContext) ? customContext : config.getCustomContext();
            try {
                String explanation = provider.explainError(errorLogs, listener, language, effectiveCustomContext);
                LOGGER.fine(jobInfo + " AI error explanation succeeded.");
                ErrorExplanationAction action = new ErrorExplanationAction(explanation, this.urlString, errorLogs, provider.getProviderName());
                run.addOrReplaceAction((Action)action);
                return explanation;
            }
            catch (ExplanationException ee) {
                listener.getLogger().println(ee.getMessage());
                return null;
            }
        }
        catch (IOException e) {
            LOGGER.severe(jobInfo + " Failed to explain error: " + e.getMessage());
            listener.getLogger().println(jobInfo + " Failed to explain error: " + e.getMessage());
            return null;
        }
    }

    private String extractErrorLogs(Run<?, ?> run, String logPattern, int maxLines) throws IOException {
        PipelineLogExtractor logExtractor = new PipelineLogExtractor(run, maxLines);
        List<String> logLines = logExtractor.getFailedStepLog();
        this.urlString = logExtractor.getUrl();
        if (StringUtils.isBlank((CharSequence)logPattern)) {
            return String.join((CharSequence)"\n", logLines);
        }
        Pattern pattern = Pattern.compile(logPattern, 2);
        StringBuilder errorLogs = new StringBuilder();
        for (String line : logLines) {
            if (!pattern.matcher(line).find()) continue;
            errorLogs.append(line).append("\n");
        }
        return errorLogs.toString();
    }

    public ErrorExplanationAction explainErrorText(String errorText, String url, @NonNull Run<?, ?> run) throws IOException, ExplanationException {
        String jobInfo = "[" + run.getParent().getFullName() + " #" + run.getNumber() + "]";
        GlobalConfigurationImpl config = GlobalConfigurationImpl.get();
        BaseAIProvider provider = config.getAiProvider();
        String explanation = provider.explainError(errorText, (TaskListener)new LogTaskListener(LOGGER, Level.FINE), null, config.getCustomContext());
        LOGGER.fine(jobInfo + " AI error explanation succeeded.");
        LOGGER.finer("Explanation length: " + explanation.length());
        this.providerName = provider.getProviderName();
        ErrorExplanationAction action = new ErrorExplanationAction(explanation, url, errorText, provider.getProviderName());
        run.addOrReplaceAction((Action)action);
        run.save();
        return action;
    }
}

