/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error.provider;

import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import dev.langchain4j.service.V;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.jenkins.plugins.explain_error.ExplanationException;
import io.jenkins.plugins.explain_error.JenkinsLogAnalysis;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class BaseAIProvider
extends AbstractDescribableImpl<BaseAIProvider>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(BaseAIProvider.class.getName());
    protected String url;
    protected String model;

    public BaseAIProvider(String url, String model) {
        this.url = url;
        this.model = model;
    }

    public abstract Assistant createAssistant();

    public abstract boolean isNotValid(@CheckForNull TaskListener var1);

    public String getUrl() {
        return this.url;
    }

    public String getModel() {
        return this.model;
    }

    public final String explainError(String errorLogs, TaskListener listener) throws ExplanationException {
        return this.explainError(errorLogs, listener, null, null);
    }

    public final String explainError(String errorLogs, TaskListener listener, String language) throws ExplanationException {
        return this.explainError(errorLogs, listener, language, null);
    }

    public final String explainError(String errorLogs, TaskListener listener, String language, String customContext) throws ExplanationException {
        Assistant assistant;
        if (StringUtils.isBlank((CharSequence)errorLogs)) {
            throw new ExplanationException("warning", "No error logs provided for explanation.");
        }
        if (this.isNotValid(listener)) {
            throw new ExplanationException("error", "The provider is not properly configured.");
        }
        try {
            assistant = this.createAssistant();
        }
        catch (Exception e) {
            throw new ExplanationException("error", "Failed to create assistant", e);
        }
        String responseLanguage = StringUtils.isBlank((CharSequence)language) ? "English" : language.trim();
        String additionalContext = StringUtils.isBlank((CharSequence)customContext) ? "" : "\n\nIMPORTANT - ADDITIONAL INSTRUCTIONS (You MUST address these in your response):\n" + customContext.trim();
        LOGGER.fine("Explaining error with language: " + responseLanguage + ", customContext length: " + additionalContext.length());
        try {
            return assistant.analyzeLogs(errorLogs, responseLanguage, additionalContext).toString();
        }
        catch (Exception e) {
            LOGGER.severe("AI API request failed: " + e.getMessage());
            throw new ExplanationException("error", "API request failed: " + e.getMessage(), e);
        }
    }

    public BaseProviderDescriptor getDescriptor() {
        return (BaseProviderDescriptor)super.getDescriptor();
    }

    public String getProviderName() {
        return this.getDescriptor().getDisplayName();
    }

    public static interface Assistant {
        @SystemMessage(value={"You are an expert Jenkins administrator and software engineer.\nYou MUST follow ALL instructions provided by the user, including any additional context or requirements.\nWhen additional instructions are provided, you MUST incorporate them into your analysis fields,\nespecially in errorSummary and resolutionSteps.\n"})
        @UserMessage(value={"Analyze the following Jenkins build error logs and provide a clear, actionable explanation.\n\nCRITICAL: You MUST respond ONLY in {{language}}. ALL text in your response must be in {{language}}.\nThis includes: error summaries, resolution steps, best practices, and any other text.\n{{customContext}}\n\nERROR LOGS:\n{{errorLogs}}\n\nRemember: Your ENTIRE response must be in {{language}}, including all field values.\nIf additional instructions were provided above, you MUST address them in your errorSummary or resolutionSteps.\n"})
        public JenkinsLogAnalysis analyzeLogs(@V(value="errorLogs") String var1, @V(value="language") String var2, @V(value="customContext") String var3);
    }

    public static abstract class BaseProviderDescriptor
    extends Descriptor<BaseAIProvider> {
        public abstract String getDefaultModel();

        @POST
        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (value == null || value.isBlank()) {
                return FormValidation.ok();
            }
            try {
                URI uri = new URL(value).toURI();
                String scheme = uri.getScheme();
                if (uri.getHost() == null) {
                    return FormValidation.error((String)"url is not well formed.");
                }
                if (!"http".equals(scheme) && !"https".equals(scheme)) {
                    return FormValidation.error((String)"URL must use http or https");
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                return FormValidation.error((Throwable)e, (String)"URL is not well formed.");
            }
            return FormValidation.ok();
        }
    }
}

