/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleNote;
import hudson.model.Result;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.actions.WarningAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.BlockStartNode;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineLogExtractor {
    private static final Logger LOGGER = Logger.getLogger(PipelineLogExtractor.class.getName());
    public static final String URL_NAME = "stages";
    private static final Pattern ERROR_PATTERN = Pattern.compile("(?i)\\b(error|exception|failed|fatal)\\b", 8);
    private static final int ERROR_CONTEXT_LINES = 5;
    private boolean isGraphViewPluginAvailable = false;
    private transient String url;
    private transient Run<?, ?> run;
    private int maxLines;

    private List<String> readLimitedLog(AnnotatedLargeText<? extends FlowNode> logText, int maxLines) {
        StringWriter writer = new StringWriter();
        try {
            String line;
            long offset = logText.writeLogTo(0L, (Writer)writer);
            if (offset <= 0L) {
                return Collections.emptyList();
            }
            String cleanLog = ConsoleNote.removeNotes((String)writer.toString());
            BufferedReader reader = new BufferedReader(new StringReader(cleanLog));
            LinkedList<String> queue = new LinkedList<String>();
            while ((line = reader.readLine()) != null) {
                if (queue.size() >= maxLines) {
                    queue.removeFirst();
                }
                queue.add(line);
            }
            return new ArrayList<String>(queue);
        }
        catch (IOException e) {
            LOGGER.severe("Unable to serialize the flow node log: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    private List<String> getErrorPatternLines() {
        ArrayList<String> allLines = new ArrayList<String>();
        try (InputStream inputStream = this.run.getLogInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                allLines.add(ConsoleNote.removeNotes((String)line));
            }
        }
        catch (IOException e) {
            LOGGER.warning("Could not read full log for error pattern scan: " + e.getMessage());
            return Collections.emptyList();
        }
        if (allLines.isEmpty()) {
            return Collections.emptyList();
        }
        boolean[] include = new boolean[allLines.size()];
        for (int i = 0; i < allLines.size(); ++i) {
            if (!ERROR_PATTERN.matcher((CharSequence)allLines.get(i)).find()) continue;
            int start = Math.max(0, i - 5);
            int end = Math.min(allLines.size() - 1, i + 5);
            for (int j = start; j <= end; ++j) {
                include[j] = true;
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < allLines.size() && result.size() < this.maxLines; ++i) {
            if (!include[i]) continue;
            result.add((String)allLines.get(i));
        }
        return result;
    }

    public List<String> getFailedStepLog() throws IOException {
        List<String> patternLines;
        int budget;
        FlowExecution execution;
        ArrayList<String> accumulated = new ArrayList<String>();
        String primaryNodeId = null;
        if (this.run instanceof WorkflowRun && (execution = ((WorkflowRun)this.run).getExecution()) != null) {
            HashSet<String> seenOriginIds = new HashSet<String>();
            FlowGraphWalker walker = new FlowGraphWalker(execution);
            for (Object node : walker) {
                Object stepLog;
                LogAction logAction;
                FlowNode origin;
                ErrorAction errorAction = (ErrorAction)node.getAction(ErrorAction.class);
                if (errorAction == null || (origin = ErrorAction.findOrigin((Throwable)errorAction.getError(), (FlowExecution)execution)) == null || seenOriginIds.contains(origin.getId()) || (logAction = (LogAction)origin.getAction(LogAction.class)) == null || (stepLog = this.readLimitedLog((AnnotatedLargeText<? extends FlowNode>)logAction.getLogText(), this.maxLines)) == null || stepLog.isEmpty()) continue;
                seenOriginIds.add(origin.getId());
                if (primaryNodeId == null) {
                    primaryNodeId = origin.getId();
                }
                accumulated.addAll((Collection<String>)stepLog);
            }
            if (accumulated.size() > this.maxLines) {
                accumulated = new ArrayList(accumulated.subList(0, this.maxLines));
            }
            if (accumulated.isEmpty()) {
                FlowGraphWalker warningWalker = new FlowGraphWalker(execution);
                for (FlowNode node : warningWalker) {
                    long errorLineCount;
                    List<String> result;
                    LogAction logAction = (LogAction)node.getAction(LogAction.class);
                    if (logAction == null) continue;
                    BlockStartNode catchErrorBlock = null;
                    for (BlockStartNode enclosing : node.getEnclosingBlocks()) {
                        WarningAction warningAction = (WarningAction)enclosing.getAction(WarningAction.class);
                        if (warningAction == null || !warningAction.getResult().isWorseThan(Result.SUCCESS)) continue;
                        catchErrorBlock = enclosing;
                        break;
                    }
                    if (catchErrorBlock == null || (result = this.readLimitedLog((AnnotatedLargeText<? extends FlowNode>)logAction.getLogText(), this.maxLines)) == null || result.isEmpty() || (errorLineCount = result.stream().filter(line -> ERROR_PATTERN.matcher((CharSequence)line).find()).count()) < 2L) continue;
                    accumulated.addAll(result);
                    primaryNodeId = catchErrorBlock.getId();
                    break;
                }
            }
        }
        if ((budget = this.maxLines - accumulated.size()) > 0 && !(patternLines = this.getErrorPatternLines()).isEmpty()) {
            HashSet<String> existingLines = new HashSet<String>(accumulated);
            for (String line2 : patternLines) {
                if (budget <= 0) break;
                if (!existingLines.add(line2)) continue;
                accumulated.add(line2);
                --budget;
            }
            LOGGER.info("Strategy 3 scan complete: " + accumulated.size() + " total lines accumulated");
        }
        if (!accumulated.isEmpty()) {
            this.setUrl(primaryNodeId != null ? primaryNodeId : "0");
            return accumulated;
        }
        this.setUrl("0");
        return this.run.getLog(this.maxLines);
    }

    private void setUrl(String node) {
        String rootUrl = Jenkins.get().getRootUrl();
        this.url = this.isGraphViewPluginAvailable ? rootUrl + this.run.getUrl() + "stages?selected-node=" + node : rootUrl + this.run.getUrl() + "console";
    }

    public String getUrl() {
        return this.url;
    }

    public PipelineLogExtractor(Run<?, ?> run, int maxLines) {
        this.run = run;
        this.maxLines = maxLines;
        if (Jenkins.get().getPlugin("pipeline-graph-view") != null) {
            this.isGraphViewPluginAvailable = true;
        }
    }
}

