/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error.provider;

import dev.langchain4j.model.bedrock.BedrockChatModel;
import dev.langchain4j.model.bedrock.BedrockChatRequestParameters;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.service.AiServices;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.jenkins.plugins.explain_error.ExplanationException;
import io.jenkins.plugins.explain_error.provider.BaseAIProvider;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import software.amazon.awssdk.regions.Region;

public class BedrockProvider
extends BaseAIProvider {
    private static final Logger LOGGER = Logger.getLogger(BedrockProvider.class.getName());
    private String region;

    @DataBoundConstructor
    public BedrockProvider(String url, String model, String region) {
        super(url, model);
        this.region = Util.fixEmptyAndTrim((String)region);
    }

    public String getRegion() {
        return this.region;
    }

    @Override
    public BaseAIProvider.Assistant createAssistant() {
        BedrockChatModel.Builder builder = (BedrockChatModel.Builder)((BedrockChatModel.Builder)((BedrockChatModel.Builder)((BedrockChatModel.Builder)((BedrockChatModel.Builder)BedrockChatModel.builder().modelId(this.getModel())).defaultRequestParameters((ChatRequestParameters)((BedrockChatRequestParameters.Builder)BedrockChatRequestParameters.builder().temperature(Double.valueOf(0.3))).build())).timeout(Duration.ofSeconds(180L))).logRequests(Boolean.valueOf(LOGGER.isLoggable(Level.FINE)))).logResponses(Boolean.valueOf(LOGGER.isLoggable(Level.FINE)));
        if (this.region != null) {
            builder.region(Region.of((String)this.region));
        }
        BedrockChatModel model = builder.build();
        return (BaseAIProvider.Assistant)AiServices.create(BaseAIProvider.Assistant.class, (ChatModel)model);
    }

    @Override
    public boolean isNotValid(@CheckForNull TaskListener listener) {
        if (listener != null && Util.fixEmptyAndTrim((String)this.getModel()) == null) {
            listener.getLogger().println("No Model configured for AWS Bedrock.");
        }
        return Util.fixEmptyAndTrim((String)this.getModel()) == null;
    }

    @Extension
    @Symbol(value={"bedrock"})
    public static class DescriptorImpl
    extends BaseAIProvider.BaseProviderDescriptor {
        @NonNull
        public String getDisplayName() {
            return "AWS Bedrock";
        }

        @Override
        public String getDefaultModel() {
            return "eu.anthropic.claude-3-5-sonnet-20240620-v1:0";
        }

        public String getDefaultRegion() {
            return "eu-west-1";
        }

        @POST
        public FormValidation doTestConfiguration(@QueryParameter(value="model") String model, @QueryParameter(value="region") String region) throws ExplanationException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            BedrockProvider provider = new BedrockProvider(null, model, region);
            try {
                provider.explainError("Send 'Configuration test successful' to me.", null);
                return FormValidation.ok((String)"Configuration test successful! AWS Bedrock connection is working properly.");
            }
            catch (ExplanationException e) {
                return FormValidation.error((String)("Configuration test failed: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
    }
}

