/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error.provider;

import dev.langchain4j.service.SystemMessage;
import dev.langchain4j.service.UserMessage;
import dev.langchain4j.service.V;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import io.jenkins.plugins.explain_error.ExplanationException;
import io.jenkins.plugins.explain_error.JenkinsLogAnalysis;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class BaseAIProvider
extends AbstractDescribableImpl<BaseAIProvider>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(BaseAIProvider.class.getName());
    protected String url;
    protected String model;

    public BaseAIProvider(String url, String model) {
        this.url = url;
        this.model = model;
    }

    public abstract Assistant createAssistant();

    public abstract boolean isNotValid(@CheckForNull TaskListener var1);

    public String getUrl() {
        return this.url;
    }

    public String getModel() {
        return this.model;
    }

    public final String explainError(String errorLogs, TaskListener listener) throws ExplanationException {
        return this.explainError(errorLogs, listener, null, null);
    }

    public final String explainError(String errorLogs, TaskListener listener, String language) throws ExplanationException {
        return this.explainError(errorLogs, listener, language, null);
    }

    public final String explainError(String errorLogs, TaskListener listener, String language, String customContext) throws ExplanationException {
        Assistant assistant;
        if (StringUtils.isBlank((CharSequence)errorLogs)) {
            throw new ExplanationException("warning", "No error logs provided for explanation.");
        }
        if (this.isNotValid(listener)) {
            throw new ExplanationException("error", "The provider is not properly configured.");
        }
        try {
            assistant = this.createAssistant();
        }
        catch (Exception e) {
            throw new ExplanationException("error", "Failed to create assistant", e);
        }
        String responseLanguage = StringUtils.isBlank((CharSequence)language) ? "English" : language.trim();
        String additionalContext = StringUtils.isBlank((CharSequence)customContext) ? "" : "\n\nADDITIONAL CONTEXT AND INSTRUCTIONS:\n" + customContext.trim();
        LOGGER.fine("Explaining error with language: " + responseLanguage + ", customContext length: " + additionalContext.length());
        if (!additionalContext.isEmpty()) {
            LOGGER.fine("Custom context content: " + additionalContext);
        }
        try {
            return assistant.analyzeLogs(errorLogs, responseLanguage, additionalContext).toString();
        }
        catch (Exception e) {
            LOGGER.severe("AI API request failed: " + e.getMessage());
            throw new ExplanationException("error", "API request failed: " + e.getMessage(), e);
        }
    }

    public BaseProviderDescriptor getDescriptor() {
        return (BaseProviderDescriptor)super.getDescriptor();
    }

    public String getProviderName() {
        return this.getDescriptor().getDisplayName();
    }

    public static interface Assistant {
        @SystemMessage(value={"You are an expert Jenkins administrator and software engineer.\nCRITICAL: If additional context or custom instructions are provided below, you MUST prioritize and follow those instructions exactly.\nCustom instructions take absolute priority and may completely override the default task.\n"})
        @UserMessage(value={"{{customContext}}\n\nDefault Task (if no custom instructions override this):\nAnalyze the following Jenkins build error logs and provide a clear, actionable explanation.\n\nLANGUAGE REQUIREMENT: You MUST respond ONLY in {{language}}. ALL text in your response must be in {{language}}.\n\nERROR LOGS:\n{{errorLogs}}\n\nRemember:\n1. If custom instructions are provided above, follow them exactly\n2. Your ENTIRE response must be in {{language}}\n"})
        public JenkinsLogAnalysis analyzeLogs(@V(value="errorLogs") String var1, @V(value="language") String var2, @V(value="customContext") String var3);
    }

    public static abstract class BaseProviderDescriptor
    extends Descriptor<BaseAIProvider> {
        public abstract String getDefaultModel();

        @POST
        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (value == null || value.isBlank()) {
                return FormValidation.ok();
            }
            try {
                URI uri = new URL(value).toURI();
                String scheme = uri.getScheme();
                if (uri.getHost() == null) {
                    return FormValidation.error((String)"url is not well formed.");
                }
                if (!"http".equals(scheme) && !"https".equals(scheme)) {
                    return FormValidation.error((String)"URL must use http or https");
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                return FormValidation.error((Throwable)e, (String)"URL is not well formed.");
            }
            return FormValidation.ok();
        }
    }
}

