/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import hudson.Extension;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.explain_error.ErrorExplainer;
import java.util.Set;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class ExplainErrorStep
extends Step {
    private String logPattern = "";
    private int maxLines = 100;
    private String language = "";

    @DataBoundConstructor
    public ExplainErrorStep() {
    }

    public String getLogPattern() {
        return this.logPattern;
    }

    @DataBoundSetter
    public void setLogPattern(String logPattern) {
        this.logPattern = logPattern != null ? logPattern : "";
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    @DataBoundSetter
    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines > 0 ? maxLines : 100;
    }

    public String getLanguage() {
        return this.language;
    }

    @DataBoundSetter
    public void setLanguage(String language) {
        this.language = language != null ? language : "";
    }

    public StepExecution start(StepContext context) throws Exception {
        return new ExplainErrorStepExecution(context, this);
    }

    private static class ExplainErrorStepExecution
    extends SynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient ExplainErrorStep step;

        ExplainErrorStepExecution(StepContext context, ExplainErrorStep step) {
            super(context);
            this.step = step;
        }

        protected Void run() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            ErrorExplainer explainer = new ErrorExplainer();
            explainer.explainError(run, listener, this.step.getLogPattern(), this.step.getMaxLines(), this.step.getLanguage());
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(Run.class, TaskListener.class);
        }

        public String getFunctionName() {
            return "explainError";
        }

        public String getDisplayName() {
            return "Explain Error with AI";
        }
    }
}

