/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error.provider;

import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.PromptTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public abstract class BaseAIProvider
extends AbstractDescribableImpl<BaseAIProvider>
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(BaseAIProvider.class.getName());
    protected String url;
    protected String model;

    public BaseAIProvider(String url, String model) {
        this.url = url;
        this.model = model;
    }

    public abstract Assistant createAssistant();

    public abstract boolean isNotValid(@CheckForNull TaskListener var1);

    public String getUrl() {
        return this.url;
    }

    public String getModel() {
        return this.model;
    }

    public final String explainError(String errorLogs) throws IOException {
        Assistant assistant;
        if (StringUtils.isBlank((CharSequence)errorLogs)) {
            return "No error logs provided for explanation.";
        }
        if (this.isNotValid(null)) {
            return "Configuration is not valid.";
        }
        try {
            assistant = this.createAssistant();
        }
        catch (Exception e) {
            return "Unable to create assistant api-key or model is invalid.";
        }
        PromptTemplate promptTemplate = PromptTemplate.from((String)"You are an expert Jenkins administrator and software engineer. Please analyze the following Jenkins build error logs and provide a clear, actionable explanation of what went wrong and how to fix it:\n\nERROR LOGS:\n{{errorLogs}}\n\nPlease provide:\n1. A summary of what caused the error\n2. Specific steps to resolve the issue\n3. Any relevant best practices to prevent similar issues\n\nKeep your response concise and focused on actionable solutions. Use plain text formatting only - no markdown, bold text, italic text, or special symbols for formatting.");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("errorLogs", errorLogs);
        Prompt prompt = promptTemplate.apply(variables);
        try {
            return assistant.chat(prompt.text());
        }
        catch (Exception e) {
            LOGGER.severe("AI API request failed: " + e.getMessage());
            return "Failed to communicate with AI service: " + e.getMessage();
        }
    }

    public BaseProviderDescriptor getDescriptor() {
        return (BaseProviderDescriptor)super.getDescriptor();
    }

    public String getProviderName() {
        return this.getDescriptor().getDisplayName();
    }

    public static interface Assistant {
        public String chat(String var1);
    }

    public static abstract class BaseProviderDescriptor
    extends Descriptor<BaseAIProvider> {
        public abstract String getDefaultModel();

        @POST
        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (value == null || value.isBlank()) {
                return FormValidation.ok();
            }
            try {
                URI uri = new URL(value).toURI();
                String scheme = uri.getScheme();
                if (uri.getHost() == null) {
                    return FormValidation.error((String)"url is not well formed.");
                }
                if (!"http".equals(scheme) && !"https".equals(scheme)) {
                    return FormValidation.error((String)"URL must use http or https");
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                return FormValidation.error((Throwable)e, (String)"URL is not well formed.");
            }
            return FormValidation.ok();
        }
    }
}

