/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.console.AnnotatedLargeText;
import hudson.console.ConsoleNote;
import hudson.model.Run;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jenkinsci.plugins.workflow.actions.ErrorAction;
import org.jenkinsci.plugins.workflow.actions.LogAction;
import org.jenkinsci.plugins.workflow.flow.FlowExecution;
import org.jenkinsci.plugins.workflow.graph.FlowGraphWalker;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class PipelineLogExtractor {
    private static List<String> readLimitedLog(AnnotatedLargeText<? extends FlowNode> logText, int maxLines) {
        StringWriter writer = new StringWriter();
        try {
            String line;
            long offset = logText.writeLogTo(0L, (Writer)writer);
            if (offset <= 0L) {
                return Collections.emptyList();
            }
            String cleanLog = ConsoleNote.removeNotes((String)writer.toString());
            BufferedReader reader = new BufferedReader(new StringReader(cleanLog));
            LinkedList<String> queue = new LinkedList<String>();
            while ((line = reader.readLine()) != null) {
                if (queue.size() >= maxLines) {
                    queue.removeFirst();
                }
                line = line.replace("\n", "").replace("\r", "");
                queue.add(line);
            }
            return new ArrayList<String>(queue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    public static List<String> getFailedStepLog(@NonNull Run<?, ?> run, int maxLines) throws IOException {
        if (run instanceof WorkflowRun) {
            FlowExecution execution = ((WorkflowRun)run).getExecution();
            FlowGraphWalker walker = new FlowGraphWalker(execution);
            for (FlowNode node : walker) {
                AnnotatedLargeText logText;
                List<String> result;
                LogAction logAction;
                FlowNode nodeThatThrewException;
                ErrorAction errorAction = (ErrorAction)node.getAction(ErrorAction.class);
                if (errorAction == null || (nodeThatThrewException = ErrorAction.findOrigin((Throwable)errorAction.getError(), (FlowExecution)execution)) == null || (logAction = (LogAction)nodeThatThrewException.getAction(LogAction.class)) == null || (result = PipelineLogExtractor.readLimitedLog((AnnotatedLargeText<? extends FlowNode>)(logText = logAction.getLogText()), maxLines)) == null || result.isEmpty()) continue;
                return result;
            }
        }
        return run.getLog(maxLines);
    }
}

