/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.hm.hafner.echarts.Build;
import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.ChartModelConfiguration;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.echarts.LocalDateLabel;
import edu.hm.hafner.echarts.ResultTime;
import edu.hm.hafner.echarts.TimeFacade;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class SeriesBuilder<T> {
    private final ResultTime resultTime;

    protected SeriesBuilder() {
        this(new ResultTime());
    }

    @VisibleForTesting
    SeriesBuilder(ResultTime resultTime) {
        this.resultTime = resultTime;
    }

    public LinesDataSet createAggregatedDataSet(ChartModelConfiguration configuration, List<Iterable<? extends BuildResult<T>>> results) {
        return this.createDataSetPerDay(this.averageByDate(configuration, results));
    }

    public LinesDataSet createDataSet(ChartModelConfiguration configuration, Iterable<? extends BuildResult<T>> results) {
        SortedMap<Build, Map<String, Integer>> seriesPerBuild = this.createSeriesPerBuild(configuration, results);
        if (configuration.getAxisType() == ChartModelConfiguration.AxisType.BUILD) {
            return this.createDataSetPerBuildNumber(seriesPerBuild);
        }
        return this.createDataSetPerDay(this.averageByDate(seriesPerBuild));
    }

    private SortedMap<Build, Map<String, Integer>> createSeriesPerBuild(ChartModelConfiguration configuration, Iterable<? extends BuildResult<T>> results) {
        int buildCount = 0;
        TreeMap<Build, Map<String, Integer>> valuesPerBuildNumber = new TreeMap<Build, Map<String, Integer>>();
        for (BuildResult<T> current : results) {
            if (this.resultTime.isResultTooOld(configuration, current)) break;
            Map<String, Integer> series = this.computeSeries(current.getResult());
            if (!series.isEmpty()) {
                valuesPerBuildNumber.put(current.getBuild(), series);
            }
            if (!configuration.isBuildCountDefined() || ++buildCount < configuration.getBuildCount()) continue;
            break;
        }
        this.fillMissingValues(valuesPerBuildNumber);
        return valuesPerBuildNumber;
    }

    private void fillMissingValues(SortedMap<Build, Map<String, Integer>> valuesPerBuildNumber) {
        Set<String> dataSets = valuesPerBuildNumber.values().stream().flatMap(values -> Stream.of(values.keySet())).flatMap(Collection::stream).collect(Collectors.toSet());
        for (Map<String, Integer> series : valuesPerBuildNumber.values()) {
            dataSets.forEach(dataSet -> series.putIfAbsent((String)dataSet, 0));
        }
    }

    protected abstract Map<String, Integer> computeSeries(T var1);

    private LinesDataSet createDataSetPerBuildNumber(SortedMap<Build, Map<String, Integer>> valuesPerBuild) {
        LinesDataSet model = new LinesDataSet();
        for (Map.Entry<Build, Map<String, Integer>> series : valuesPerBuild.entrySet()) {
            model.add(series.getKey().getDisplayName(), series.getValue(), series.getKey().getNumber());
        }
        return model;
    }

    private LinesDataSet createDataSetPerDay(SortedMap<LocalDate, Map<String, Integer>> averagePerDay) {
        LinesDataSet model = new LinesDataSet();
        for (Map.Entry<LocalDate, Map<String, Integer>> series : averagePerDay.entrySet()) {
            String label = new LocalDateLabel(series.getKey()).toString();
            model.add(label, series.getValue());
        }
        return model;
    }

    private SortedMap<LocalDate, Map<String, Integer>> createSeriesPerDay(Map<LocalDate, List<Map<String, Integer>>> multiSeriesPerDate) {
        TreeMap<LocalDate, Map<String, Integer>> seriesPerDate = new TreeMap<LocalDate, Map<String, Integer>>();
        for (Map.Entry<LocalDate, List<Map<String, Integer>>> entry : multiSeriesPerDate.entrySet()) {
            List<Map<String, Integer>> seriesPerDay = entry.getValue();
            Map<String, Integer> mapOfDay = seriesPerDay.stream().flatMap(m -> m.entrySet().stream()).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.summingInt(Map.Entry::getValue)));
            Map<String, Integer> averagePerDay = mapOfDay.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (Integer)e.getValue() / seriesPerDay.size()));
            seriesPerDate.put(entry.getKey(), averagePerDay);
        }
        return seriesPerDate;
    }

    private SortedMap<LocalDate, Map<String, Integer>> averageByDate(SortedMap<Build, Map<String, Integer>> valuesPerBuild) {
        return this.createSeriesPerDay(this.createMultiSeriesPerDay(valuesPerBuild));
    }

    private SortedMap<LocalDate, Map<String, Integer>> averageByDate(ChartModelConfiguration configuration, List<Iterable<? extends BuildResult<T>>> results) {
        TreeMap<LocalDate, List<Map<String, Integer>>> valuesPerDate = new TreeMap<LocalDate, List<Map<String, Integer>>>();
        for (Iterable<BuildResult<T>> iterable : results) {
            valuesPerDate.putAll(this.createMultiSeriesPerDay(this.createSeriesPerBuild(configuration, iterable)));
        }
        return this.createSeriesPerDay(valuesPerDate);
    }

    @SuppressFBWarnings(value={"WMI"})
    private Map<LocalDate, List<Map<String, Integer>>> createMultiSeriesPerDay(Map<Build, Map<String, Integer>> valuesPerBuild) {
        TreeMap<LocalDate, List<Map<String, Integer>>> valuesPerDate = new TreeMap<LocalDate, List<Map<String, Integer>>>();
        for (Build build : valuesPerBuild.keySet()) {
            LocalDate buildDate = TimeFacade.getInstance().getBuildDate(build);
            valuesPerDate.computeIfAbsent(buildDate, k -> new ArrayList()).add(valuesPerBuild.get(build));
        }
        return valuesPerDate;
    }
}

