/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.echarts;

import edu.hm.hafner.echarts.BuildResult;
import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LinesChartModel;
import hudson.model.Job;
import io.jenkins.plugins.echarts.AsyncTrendChart;
import io.jenkins.plugins.echarts.BuildActionIterator;
import io.jenkins.plugins.util.BuildAction;
import io.jenkins.plugins.util.JobAction;
import java.util.Iterator;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public abstract class AsyncTrendJobAction<T extends BuildAction<?>>
extends JobAction<T>
implements AsyncTrendChart {
    protected AsyncTrendJobAction(Job<?, ?> owner, Class<T> buildActionClass) {
        super(owner, buildActionClass);
    }

    @Override
    @JavaScriptMethod
    public String getBuildTrendModel() {
        return new JacksonFacade().toJson(this.createChartModel());
    }

    @Override
    public boolean isTrendVisible() {
        return this.hasAtLeastTwoResults();
    }

    private boolean hasAtLeastTwoResults() {
        Iterable<BuildResult<T>> results = this.createBuildHistory();
        Iterator<BuildResult<T>> iterator = results.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        return iterator.hasNext();
    }

    protected abstract LinesChartModel createChartModel();

    protected Iterable<? extends BuildResult<T>> createBuildHistory() {
        return () -> new BuildActionIterator(this.getBuildActionClass(), this.getLatestAction());
    }
}

