// CHECKSTYLE:OFF

package io.jenkins.plugins.designlibrary;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Localization.message}: {@code How to localize text in
     * Java}.
     * 
     * @return
     *     {@code How to localize text in Java}
     */
    public static String Localization_message() {
        return holder.format("Localization.message");
    }

    /**
     * Key {@code Localization.message}: {@code How to localize text in
     * Java}.
     * 
     * @return
     *     {@code How to localize text in Java}
     */
    public static Localizable _Localization_message() {
        return new Localizable(holder, "Localization.message");
    }

    /**
     * Key {@code Localization.description}: {@code Ensures texts can be
     * displayed in the user''s language.}.
     * 
     * @return
     *     {@code Ensures texts can be displayed in the user''s language.}
     */
    public static String Localization_description() {
        return holder.format("Localization.description");
    }

    /**
     * Key {@code Localization.description}: {@code Ensures texts can be
     * displayed in the user''s language.}.
     * 
     * @return
     *     {@code Ensures texts can be displayed in the user''s language.}
     */
    public static Localizable _Localization_description() {
        return new Localizable(holder, "Localization.description");
    }

    /**
     * Key {@code Localization.greet}: {@code Hello {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Hello {0}}
     */
    public static String Localization_greet(Object arg0) {
        return holder.format("Localization.greet", arg0);
    }

    /**
     * Key {@code Localization.greet}: {@code Hello {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Hello {0}}
     */
    public static Localizable _Localization_greet(Object arg0) {
        return new Localizable(holder, "Localization.greet", arg0);
    }

}
