/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.DefectDojo;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.util.FormValidation;
import io.jenkins.plugins.DefectDojo.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

final class PluginUtil {
    @NonNull
    static FormValidation doCheckUrl(String value) {
        if (StringUtils.isBlank((String)value)) {
            return FormValidation.ok();
        }
        try {
            URL url = new URL(value);
            if (!url.getProtocol().toLowerCase().matches("https?")) {
                return FormValidation.error((String)Messages.Publisher_ConnectionTest_InvalidProtocols());
            }
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)Messages.Publisher_ConnectionTest_UrlMalformed());
        }
        return FormValidation.ok();
    }

    @Nullable
    static String parseBaseUrl(String baseUrl) {
        return StringUtils.removeEnd((String)StringUtils.trimToNull((String)baseUrl), (String)"/");
    }

    static boolean areAllElementsOfType(@NonNull Collection<?> coll, @NonNull Class<?> type) {
        try {
            Validate.allElementsOfType(coll, type);
        }
        catch (IllegalArgumentException invalid) {
            return false;
        }
        return true;
    }

    @Generated
    private PluginUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

