/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.DefectDojo;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.DefectDojo.ApiClient;
import io.jenkins.plugins.DefectDojo.ApiClientException;
import io.jenkins.plugins.DefectDojo.ApiClientFactory;
import io.jenkins.plugins.DefectDojo.ConsoleLogger;
import io.jenkins.plugins.DefectDojo.DefectDojoPublisher;
import io.jenkins.plugins.DefectDojo.Messages;
import io.jenkins.plugins.DefectDojo.PluginUtil;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import lombok.Generated;
import lombok.NonNull;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"defectDojoPublisher"})
public class DescriptorImpl
extends BuildStepDescriptor<Publisher>
implements Serializable {
    private static final long serialVersionUID = -2018722914973282748L;
    private final transient ApiClientFactory clientFactory;
    private String defectDojoUrl;
    private String defectDojoCredentialsId;
    private boolean defectDojoAutoCreateProducts;
    private boolean defectDojoAutoCreateEngagements;
    private boolean defectDojoReuploadScan;
    private int defectDojoConnectionTimeout;
    private int defectDojoReadTimeout;

    public DescriptorImpl() {
        this(ApiClient::new);
    }

    DescriptorImpl(@NonNull ApiClientFactory clientFactory) {
        super(DefectDojoPublisher.class);
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
        this.clientFactory = clientFactory;
        this.load();
    }

    public boolean isApplicable(Class<? extends AbstractProject> aClass) {
        return true;
    }

    @POST
    public ListBoxModel doFillProductIdItems(@QueryParameter String defectDojoUrl, @QueryParameter String defectDojoCredentialsId, @AncestorInPath @Nullable Item item) {
        ListBoxModel projects = new ListBoxModel();
        try {
            String url = Optional.ofNullable(PluginUtil.parseBaseUrl(defectDojoUrl)).orElseGet(this::getDefectDojoUrl);
            Secret apiKey = this.lookupApiKey(Optional.ofNullable(StringUtils.trimToNull((String)defectDojoCredentialsId)).orElseGet(this::getDefectDojoCredentialsId), item);
            ApiClient apiClient = this.getClient(url, apiKey);
            List options = apiClient.getProducts().stream().map(p -> new ListBoxModel.Option(p.getString("name"), p.getString("id"))).sorted(Comparator.comparing(o -> o.name)).collect(Collectors.toList());
            projects.add((Object)new ListBoxModel.Option(Messages.Publisher_ProductList_Placeholder(), ""));
            projects.addAll(options);
        }
        catch (ApiClientException e) {
            projects.add(Messages.Builder_Error_Products(e.getLocalizedMessage()), "");
        }
        return projects;
    }

    @POST
    public ListBoxModel doFillEngagementIdItems(@QueryParameter String defectDojoUrl, @QueryParameter String defectDojoCredentialsId, @QueryParameter(value="productId") String productId, @AncestorInPath @Nullable Item item) {
        ListBoxModel engagements = new ListBoxModel();
        try {
            String url = Optional.ofNullable(PluginUtil.parseBaseUrl(defectDojoUrl)).orElseGet(this::getDefectDojoUrl);
            Secret apiKey = this.lookupApiKey(Optional.ofNullable(StringUtils.trimToNull((String)defectDojoCredentialsId)).orElseGet(this::getDefectDojoCredentialsId), item);
            ApiClient apiClient = this.getClient(url, apiKey);
            engagements.add((Object)new ListBoxModel.Option(Messages.Publisher_EngagementList_Placeholder(), ""));
            if (!StringUtils.isBlank((String)productId)) {
                List options = apiClient.getEngagements(productId).stream().map(p -> new ListBoxModel.Option(p.getString("name"), p.getString("id"))).sorted(Comparator.comparing(o -> o.name)).collect(Collectors.toList());
                engagements.addAll(options);
            }
        }
        catch (ApiClientException e) {
            engagements.add(Messages.Builder_Error_Products(e.getLocalizedMessage()), "");
        }
        return engagements;
    }

    @POST
    public ListBoxModel doFillScanTypeItems(@QueryParameter String defectDojoUrl, @QueryParameter String defectDojoCredentialsId, @AncestorInPath @Nullable Item item) {
        ListBoxModel projects = new ListBoxModel();
        try {
            String url = Optional.ofNullable(PluginUtil.parseBaseUrl(defectDojoUrl)).orElseGet(this::getDefectDojoUrl);
            Secret apiKey = this.lookupApiKey(Optional.ofNullable(StringUtils.trimToNull((String)defectDojoCredentialsId)).orElseGet(this::getDefectDojoCredentialsId), item);
            ApiClient apiClient = this.getClient(url, apiKey);
            List options = apiClient.getScanTypes().stream().map(p -> new ListBoxModel.Option(p.getString("name"))).sorted(Comparator.comparing(o -> o.name)).collect(Collectors.toList());
            projects.add((Object)new ListBoxModel.Option(Messages.Publisher_ScanTypeList_Placeholder(), ""));
            projects.addAll(options);
        }
        catch (ApiClientException e) {
            projects.add(Messages.Builder_Error_Products(e.getLocalizedMessage()), "");
        }
        return projects;
    }

    @POST
    public ListBoxModel doFillDefectDojoCredentialsIdItems(@QueryParameter String credentialsId, @AncestorInPath Item item) {
        StandardListBoxModel result = new StandardListBoxModel();
        if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
            return result.includeCurrentValue(credentialsId);
        }
        return result.includeEmptyValue().includeAs(ACL.SYSTEM, item, StringCredentials.class, List.of()).includeCurrentValue(credentialsId);
    }

    @POST
    public FormValidation doCheckDefectDojoUrl(@QueryParameter String value, @AncestorInPath @Nullable Item item) {
        if (item == null) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        } else {
            item.checkPermission(Item.CONFIGURE);
        }
        return PluginUtil.doCheckUrl(value);
    }

    @POST
    public FormValidation doTestConnectionGlobal(@QueryParameter String defectDojoUrl, @QueryParameter String defectDojoCredentialsId, @AncestorInPath @Nullable Item item) {
        return this.testConnection(defectDojoUrl, defectDojoCredentialsId, item);
    }

    @POST
    public FormValidation doTestConnectionJob(@QueryParameter String defectDojoUrl, @QueryParameter String defectDojoCredentialsId, @AncestorInPath @Nullable Item item) {
        return this.testConnection(defectDojoUrl, defectDojoCredentialsId, item);
    }

    private FormValidation testConnection(String defectDojoUrl, String defectDojoCredentialsId, @AncestorInPath @Nullable Item item) {
        if (item == null) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        } else {
            item.checkPermission(Item.CONFIGURE);
        }
        FormValidation.Kind formValid = FormValidation.Kind.OK;
        String url = Optional.ofNullable(PluginUtil.parseBaseUrl(defectDojoUrl)).orElseGet(this::getDefectDojoUrl);
        Secret apiKey = this.lookupApiKey(Optional.ofNullable(StringUtils.trimToNull((String)defectDojoCredentialsId)).orElseGet(this::getDefectDojoCredentialsId), item);
        if (this.doCheckDefectDojoUrl((String)url, (Item)item).kind == formValid && apiKey != null) {
            try {
                ApiClient apiClient = this.getClient(url, apiKey);
                boolean status = apiClient.testConnection();
                if (!status) {
                    return FormValidation.error((String)Messages.Publisher_ConnectionTest_Error("Something went wrong"));
                }
                return FormValidation.respond((FormValidation.Kind)formValid, (String)String.format("<div class=\"%s\">%s</div>", formValid.name().toLowerCase(Locale.ENGLISH), "Connection OK"));
            }
            catch (ApiClientException e) {
                return FormValidation.error((Throwable)e, (String)Messages.Publisher_ConnectionTest_Error(e.getMessage()));
            }
        }
        return FormValidation.error((String)Messages.Publisher_ConnectionTest_InputError());
    }

    public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        this.save();
        return super.configure(req, formData);
    }

    @CheckForNull
    public String getDefectDojoUrl() {
        return PluginUtil.parseBaseUrl(this.defectDojoUrl);
    }

    private ApiClient getClient(String baseUrl, Secret apiKey) {
        return this.clientFactory.create(baseUrl, apiKey, new ConsoleLogger(), Math.max(this.defectDojoConnectionTimeout, 0), Math.max(this.defectDojoReadTimeout, 0));
    }

    private Secret lookupApiKey(String credentialId, Item item) {
        if (item == null) {
            Jenkins.get().checkPermission(CredentialsProvider.USE_ITEM);
        } else {
            item.checkPermission(CredentialsProvider.USE_ITEM);
        }
        return CredentialsProvider.lookupCredentials(StringCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null}).stream().filter(c -> c.getId().equals(credentialId)).map(StringCredentials::getSecret).findFirst().orElse(null);
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoUrl(String defectDojoUrl) {
        this.defectDojoUrl = defectDojoUrl;
    }

    @CheckForNull
    @Generated
    public String getDefectDojoCredentialsId() {
        return this.defectDojoCredentialsId;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoCredentialsId(String defectDojoCredentialsId) {
        this.defectDojoCredentialsId = defectDojoCredentialsId;
    }

    @Generated
    public boolean isDefectDojoAutoCreateProducts() {
        return this.defectDojoAutoCreateProducts;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoAutoCreateProducts(boolean defectDojoAutoCreateProducts) {
        this.defectDojoAutoCreateProducts = defectDojoAutoCreateProducts;
    }

    @Generated
    public boolean isDefectDojoAutoCreateEngagements() {
        return this.defectDojoAutoCreateEngagements;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoAutoCreateEngagements(boolean defectDojoAutoCreateEngagements) {
        this.defectDojoAutoCreateEngagements = defectDojoAutoCreateEngagements;
    }

    @Generated
    public boolean isDefectDojoReuploadScan() {
        return this.defectDojoReuploadScan;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoReuploadScan(boolean defectDojoReuploadScan) {
        this.defectDojoReuploadScan = defectDojoReuploadScan;
    }

    @Generated
    public int getDefectDojoConnectionTimeout() {
        return this.defectDojoConnectionTimeout;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoConnectionTimeout(int defectDojoConnectionTimeout) {
        this.defectDojoConnectionTimeout = defectDojoConnectionTimeout;
    }

    @Generated
    public int getDefectDojoReadTimeout() {
        return this.defectDojoReadTimeout;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoReadTimeout(int defectDojoReadTimeout) {
        this.defectDojoReadTimeout = defectDojoReadTimeout;
    }
}

