/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.DefectDojo;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import hudson.util.Secret;
import io.jenkins.plugins.DefectDojo.ApiClient;
import io.jenkins.plugins.DefectDojo.ApiClientFactory;
import io.jenkins.plugins.DefectDojo.ConsoleLogger;
import io.jenkins.plugins.DefectDojo.DescriptorImpl;
import io.jenkins.plugins.DefectDojo.Messages;
import io.jenkins.plugins.DefectDojo.PluginUtil;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Optional;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public final class DefectDojoPublisher
extends Recorder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 480115440498217963L;
    private String productId;
    private String productName;
    private String engagementId;
    private String engagementName;
    private String sourceCodeUrl;
    private String commitHash;
    private String branchTag;
    private final String artifact;
    private final String scanType;
    private String defectDojoUrl;
    private String defectDojoCredentialsId;
    private Boolean defectDojoReuploadScan;
    private Integer defectDojoConnectionTimeout;
    private Integer defectDojoReadTimeout;
    private Boolean autoCreateProducts;
    private Boolean autoCreateEngagements;
    private transient ApiClientFactory clientFactory;
    private transient DescriptorImpl descriptor;
    private transient boolean overrideGlobals;
    private transient String projectIdCache;

    @DataBoundConstructor
    public DefectDojoPublisher(String artifact, String scanType) {
        this(artifact, scanType, ApiClient::new);
    }

    DefectDojoPublisher(String artifact, String scanType, @NonNull ApiClientFactory clientFactory) {
        if (clientFactory == null) {
            throw new NullPointerException("clientFactory is marked non-null but is null");
        }
        this.artifact = artifact;
        this.scanType = scanType;
        this.clientFactory = clientFactory;
        this.descriptor = this.getDescriptor();
    }

    public void perform(@edu.umd.cs.findbugs.annotations.NonNull Run<?, ?> run, @edu.umd.cs.findbugs.annotations.NonNull FilePath workspace, @edu.umd.cs.findbugs.annotations.NonNull EnvVars env, @edu.umd.cs.findbugs.annotations.NonNull Launcher launcher, @edu.umd.cs.findbugs.annotations.NonNull TaskListener listener) throws InterruptedException, IOException {
        ConsoleLogger logger = new ConsoleLogger(listener.getLogger());
        String effectiveProductName = env.expand(this.productName);
        String effectiveEngagementName = env.expand(this.engagementName);
        String effectiveSourceCodeUrl = env.expand(this.sourceCodeUrl);
        String effectiveCommitHash = env.expand(this.commitHash);
        String effectiveBranchTag = env.expand(this.branchTag);
        String effectiveArtifact = env.expand(this.artifact);
        String effectiveScanType = env.expand(this.scanType);
        boolean effectiveAutoCreateProduct = this.isEffectiveAutoCreateProducts();
        boolean effectiveAutoCreateEngagement = this.isEffectiveAutoCreateEngagements();
        boolean effectiveReupload = this.isEffectiveReuploadScan();
        this.projectIdCache = null;
        if (StringUtils.isBlank((String)effectiveArtifact)) {
            logger.log(Messages.Builder_Artifact_Unspecified());
            throw new AbortException(Messages.Builder_Artifact_Unspecified());
        }
        if (StringUtils.isBlank((String)effectiveScanType)) {
            logger.log(Messages.Builder_ScanType_Unspecified());
            throw new AbortException(Messages.Builder_ScanType_Unspecified());
        }
        if (StringUtils.isBlank((String)this.productId) && StringUtils.isBlank((String)effectiveProductName)) {
            logger.log(Messages.Builder_Result_InvalidArguments());
            throw new AbortException(Messages.Builder_Result_InvalidArguments());
        }
        if (StringUtils.isBlank((String)this.engagementId) && StringUtils.isBlank((String)effectiveEngagementName)) {
            logger.log(Messages.Builder_Result_InvalidArguments());
            throw new AbortException(Messages.Builder_Result_InvalidArguments());
        }
        FilePath artifactFilePath = new FilePath(workspace, effectiveArtifact);
        if (!artifactFilePath.exists()) {
            logger.log(Messages.Builder_Artifact_NonExist(effectiveArtifact));
            throw new AbortException(Messages.Builder_Artifact_NonExist(effectiveArtifact));
        }
        Node node = null;
        Computer computer = workspace.toComputer();
        if (computer != null) {
            node = computer.getNode();
        }
        if (!(node instanceof Jenkins)) {
            logger.log(Messages.Publisher_Agent_Anouncement());
            FilePath tempDirOnMaster = new FilePath(Jenkins.get().getRootPath(), "temp-upload-dir");
            FilePath artifactOnMaster = tempDirOnMaster.child(artifactFilePath.getName());
            logger.log(Messages.Publisher_Agent_CopyToMaster(artifactFilePath, artifactOnMaster));
            tempDirOnMaster.mkdirs();
            artifactFilePath.copyTo(artifactOnMaster);
            artifactFilePath = artifactOnMaster;
        }
        String effectiveUrl = this.getEffectiveUrl();
        Secret effectiveApiKey = this.getEffectiveApiKey(run);
        ApiClient apiClient = this.clientFactory.create(effectiveUrl, effectiveApiKey, logger, this.getEffectiveConnectionTimeout(), this.getEffectiveReadTimeout());
        if (StringUtils.isNotBlank((String)effectiveProductName) && StringUtils.isBlank((String)this.productId)) {
            logger.log(Messages.Builder_Fetching_Product(effectiveProductName));
            this.productId = apiClient.getProductId(effectiveProductName);
        }
        if (effectiveAutoCreateProduct && StringUtils.isBlank((String)this.productId) && StringUtils.isNotBlank((String)effectiveProductName)) {
            logger.log(Messages.Builder_Publishing_Product(effectiveProductName));
            this.productId = apiClient.createProduct(effectiveProductName, null);
        }
        if (StringUtils.isBlank((String)this.productId)) {
            logger.log(Messages.Builder_Result_ProductIdMissing());
            throw new AbortException(Messages.Builder_Result_ProductIdMissing());
        }
        if (StringUtils.isNotBlank((String)effectiveEngagementName) && StringUtils.isBlank((String)this.engagementId)) {
            logger.log(Messages.Builder_Fetching_Engagement(effectiveEngagementName));
            this.engagementId = apiClient.getEngagementId(this.productId, effectiveEngagementName);
        }
        if (effectiveAutoCreateEngagement && StringUtils.isNotBlank((String)effectiveEngagementName) && StringUtils.isBlank((String)this.engagementId)) {
            logger.log(Messages.Builder_Publishing_Engagement(effectiveProductName, effectiveEngagementName));
            this.engagementId = apiClient.createEngagement(effectiveEngagementName, this.productId, effectiveSourceCodeUrl);
        }
        if (StringUtils.isBlank((String)this.engagementId)) {
            logger.log(Messages.Builder_Result_EngagementIdMissing());
            throw new AbortException(Messages.Builder_Result_EngagementIdMissing());
        }
        logger.log(Messages.Builder_Publishing(effectiveUrl));
        boolean uploadResult = apiClient.upload(this.productId, this.engagementId, effectiveSourceCodeUrl, effectiveBranchTag, effectiveCommitHash, artifactFilePath, this.scanType, effectiveReupload);
        if (!uploadResult) {
            throw new AbortException(Messages.Builder_Upload_Failed());
        }
        logger.log(Messages.Builder_Success(String.format("%s/engagement/%s", this.getEffectiveUrl(), StringUtils.isNotBlank((String)this.engagementId) ? this.engagementId : "")));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.clientFactory == null) {
            this.clientFactory = ApiClient::new;
        }
        if (this.descriptor == null) {
            this.descriptor = this.getDescriptor();
        }
        this.overrideGlobals = StringUtils.isNotBlank((String)this.defectDojoUrl) || StringUtils.isNotBlank((String)this.defectDojoCredentialsId) || this.autoCreateProducts != null;
        return this;
    }

    private Object writeReplace() throws ObjectStreamException {
        if (!this.overrideGlobals) {
            this.defectDojoUrl = null;
            this.defectDojoCredentialsId = null;
            this.autoCreateProducts = null;
            this.autoCreateEngagements = null;
            this.defectDojoConnectionTimeout = null;
            this.defectDojoReadTimeout = null;
        }
        if (!this.isEffectiveAutoCreateProducts()) {
            this.productName = null;
        }
        if (!this.isEffectiveAutoCreateEngagements()) {
            this.engagementName = null;
        }
        return this;
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private String getEffectiveUrl() {
        String url = Optional.ofNullable(PluginUtil.parseBaseUrl(this.defectDojoUrl)).orElseGet(this.descriptor::getDefectDojoUrl);
        return Optional.ofNullable(url).orElse("");
    }

    private Secret getEffectiveApiKey(@edu.umd.cs.findbugs.annotations.NonNull Run<?, ?> run) {
        String credId = Optional.ofNullable(StringUtils.trimToNull((String)this.defectDojoCredentialsId)).orElseGet(this.descriptor::getDefectDojoCredentialsId);
        if (credId != null) {
            StringCredentials cred = (StringCredentials)CredentialsProvider.findCredentialById((String)credId, StringCredentials.class, run);
            return Optional.ofNullable((StringCredentials)CredentialsProvider.track(run, (Credentials)cred)).map(StringCredentials::getSecret).orElse(null);
        }
        return null;
    }

    public boolean isEffectiveAutoCreateProducts() {
        return Optional.ofNullable(this.autoCreateProducts).orElseGet(this.descriptor::isDefectDojoAutoCreateProducts);
    }

    public boolean isEffectiveAutoCreateEngagements() {
        return Optional.ofNullable(this.autoCreateEngagements).orElseGet(this.descriptor::isDefectDojoAutoCreateEngagements);
    }

    public boolean isEffectiveReuploadScan() {
        return Optional.ofNullable(this.defectDojoReuploadScan).orElseGet(this.descriptor::isDefectDojoReuploadScan);
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private int getEffectiveConnectionTimeout() {
        return Optional.ofNullable(this.defectDojoConnectionTimeout).filter(v -> v >= 0).orElseGet(this.descriptor::getDefectDojoConnectionTimeout);
    }

    @edu.umd.cs.findbugs.annotations.NonNull
    private int getEffectiveReadTimeout() {
        return Optional.ofNullable(this.defectDojoReadTimeout).filter(v -> v >= 0).orElseGet(this.descriptor::getDefectDojoReadTimeout);
    }

    @Generated
    public String getProductId() {
        return this.productId;
    }

    @Generated
    public String getProductName() {
        return this.productName;
    }

    @Generated
    public String getEngagementId() {
        return this.engagementId;
    }

    @Generated
    public String getEngagementName() {
        return this.engagementName;
    }

    @Generated
    public String getSourceCodeUrl() {
        return this.sourceCodeUrl;
    }

    @Generated
    public String getCommitHash() {
        return this.commitHash;
    }

    @Generated
    public String getBranchTag() {
        return this.branchTag;
    }

    @Generated
    public String getArtifact() {
        return this.artifact;
    }

    @Generated
    public String getScanType() {
        return this.scanType;
    }

    @Generated
    public String getDefectDojoUrl() {
        return this.defectDojoUrl;
    }

    @Generated
    public String getDefectDojoCredentialsId() {
        return this.defectDojoCredentialsId;
    }

    @Generated
    public Boolean getDefectDojoReuploadScan() {
        return this.defectDojoReuploadScan;
    }

    @Generated
    public Integer getDefectDojoConnectionTimeout() {
        return this.defectDojoConnectionTimeout;
    }

    @Generated
    public Integer getDefectDojoReadTimeout() {
        return this.defectDojoReadTimeout;
    }

    @Generated
    public Boolean getAutoCreateProducts() {
        return this.autoCreateProducts;
    }

    @Generated
    public Boolean getAutoCreateEngagements() {
        return this.autoCreateEngagements;
    }

    @Generated
    public boolean isOverrideGlobals() {
        return this.overrideGlobals;
    }

    @DataBoundSetter
    @Generated
    public void setProductId(String productId) {
        this.productId = productId;
    }

    @DataBoundSetter
    @Generated
    public void setProductName(String productName) {
        this.productName = productName;
    }

    @DataBoundSetter
    @Generated
    public void setEngagementId(String engagementId) {
        this.engagementId = engagementId;
    }

    @DataBoundSetter
    @Generated
    public void setEngagementName(String engagementName) {
        this.engagementName = engagementName;
    }

    @DataBoundSetter
    @Generated
    public void setSourceCodeUrl(String sourceCodeUrl) {
        this.sourceCodeUrl = sourceCodeUrl;
    }

    @DataBoundSetter
    @Generated
    public void setCommitHash(String commitHash) {
        this.commitHash = commitHash;
    }

    @DataBoundSetter
    @Generated
    public void setBranchTag(String branchTag) {
        this.branchTag = branchTag;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoUrl(String defectDojoUrl) {
        this.defectDojoUrl = defectDojoUrl;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoCredentialsId(String defectDojoCredentialsId) {
        this.defectDojoCredentialsId = defectDojoCredentialsId;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoReuploadScan(Boolean defectDojoReuploadScan) {
        this.defectDojoReuploadScan = defectDojoReuploadScan;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoConnectionTimeout(Integer defectDojoConnectionTimeout) {
        this.defectDojoConnectionTimeout = defectDojoConnectionTimeout;
    }

    @DataBoundSetter
    @Generated
    public void setDefectDojoReadTimeout(Integer defectDojoReadTimeout) {
        this.defectDojoReadTimeout = defectDojoReadTimeout;
    }

    @DataBoundSetter
    @Generated
    public void setAutoCreateProducts(Boolean autoCreateProducts) {
        this.autoCreateProducts = autoCreateProducts;
    }

    @DataBoundSetter
    @Generated
    public void setAutoCreateEngagements(Boolean autoCreateEngagements) {
        this.autoCreateEngagements = autoCreateEngagements;
    }

    @DataBoundSetter
    @Generated
    public void setOverrideGlobals(boolean overrideGlobals) {
        this.overrideGlobals = overrideGlobals;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefectDojoPublisher)) {
            return false;
        }
        DefectDojoPublisher other = (DefectDojoPublisher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$defectDojoReuploadScan = this.getDefectDojoReuploadScan();
        Boolean other$defectDojoReuploadScan = other.getDefectDojoReuploadScan();
        if (this$defectDojoReuploadScan == null ? other$defectDojoReuploadScan != null : !((Object)this$defectDojoReuploadScan).equals(other$defectDojoReuploadScan)) {
            return false;
        }
        Integer this$defectDojoConnectionTimeout = this.getDefectDojoConnectionTimeout();
        Integer other$defectDojoConnectionTimeout = other.getDefectDojoConnectionTimeout();
        if (this$defectDojoConnectionTimeout == null ? other$defectDojoConnectionTimeout != null : !((Object)this$defectDojoConnectionTimeout).equals(other$defectDojoConnectionTimeout)) {
            return false;
        }
        Integer this$defectDojoReadTimeout = this.getDefectDojoReadTimeout();
        Integer other$defectDojoReadTimeout = other.getDefectDojoReadTimeout();
        if (this$defectDojoReadTimeout == null ? other$defectDojoReadTimeout != null : !((Object)this$defectDojoReadTimeout).equals(other$defectDojoReadTimeout)) {
            return false;
        }
        Boolean this$autoCreateProducts = this.getAutoCreateProducts();
        Boolean other$autoCreateProducts = other.getAutoCreateProducts();
        if (this$autoCreateProducts == null ? other$autoCreateProducts != null : !((Object)this$autoCreateProducts).equals(other$autoCreateProducts)) {
            return false;
        }
        Boolean this$autoCreateEngagements = this.getAutoCreateEngagements();
        Boolean other$autoCreateEngagements = other.getAutoCreateEngagements();
        if (this$autoCreateEngagements == null ? other$autoCreateEngagements != null : !((Object)this$autoCreateEngagements).equals(other$autoCreateEngagements)) {
            return false;
        }
        String this$productId = this.getProductId();
        String other$productId = other.getProductId();
        if (this$productId == null ? other$productId != null : !this$productId.equals(other$productId)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        String this$engagementId = this.getEngagementId();
        String other$engagementId = other.getEngagementId();
        if (this$engagementId == null ? other$engagementId != null : !this$engagementId.equals(other$engagementId)) {
            return false;
        }
        String this$engagementName = this.getEngagementName();
        String other$engagementName = other.getEngagementName();
        if (this$engagementName == null ? other$engagementName != null : !this$engagementName.equals(other$engagementName)) {
            return false;
        }
        String this$sourceCodeUrl = this.getSourceCodeUrl();
        String other$sourceCodeUrl = other.getSourceCodeUrl();
        if (this$sourceCodeUrl == null ? other$sourceCodeUrl != null : !this$sourceCodeUrl.equals(other$sourceCodeUrl)) {
            return false;
        }
        String this$commitHash = this.getCommitHash();
        String other$commitHash = other.getCommitHash();
        if (this$commitHash == null ? other$commitHash != null : !this$commitHash.equals(other$commitHash)) {
            return false;
        }
        String this$branchTag = this.getBranchTag();
        String other$branchTag = other.getBranchTag();
        if (this$branchTag == null ? other$branchTag != null : !this$branchTag.equals(other$branchTag)) {
            return false;
        }
        String this$artifact = this.getArtifact();
        String other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact)) {
            return false;
        }
        String this$scanType = this.getScanType();
        String other$scanType = other.getScanType();
        if (this$scanType == null ? other$scanType != null : !this$scanType.equals(other$scanType)) {
            return false;
        }
        String this$defectDojoUrl = this.getDefectDojoUrl();
        String other$defectDojoUrl = other.getDefectDojoUrl();
        if (this$defectDojoUrl == null ? other$defectDojoUrl != null : !this$defectDojoUrl.equals(other$defectDojoUrl)) {
            return false;
        }
        String this$defectDojoCredentialsId = this.getDefectDojoCredentialsId();
        String other$defectDojoCredentialsId = other.getDefectDojoCredentialsId();
        return !(this$defectDojoCredentialsId == null ? other$defectDojoCredentialsId != null : !this$defectDojoCredentialsId.equals(other$defectDojoCredentialsId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefectDojoPublisher;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $defectDojoReuploadScan = this.getDefectDojoReuploadScan();
        result = result * 59 + ($defectDojoReuploadScan == null ? 43 : ((Object)$defectDojoReuploadScan).hashCode());
        Integer $defectDojoConnectionTimeout = this.getDefectDojoConnectionTimeout();
        result = result * 59 + ($defectDojoConnectionTimeout == null ? 43 : ((Object)$defectDojoConnectionTimeout).hashCode());
        Integer $defectDojoReadTimeout = this.getDefectDojoReadTimeout();
        result = result * 59 + ($defectDojoReadTimeout == null ? 43 : ((Object)$defectDojoReadTimeout).hashCode());
        Boolean $autoCreateProducts = this.getAutoCreateProducts();
        result = result * 59 + ($autoCreateProducts == null ? 43 : ((Object)$autoCreateProducts).hashCode());
        Boolean $autoCreateEngagements = this.getAutoCreateEngagements();
        result = result * 59 + ($autoCreateEngagements == null ? 43 : ((Object)$autoCreateEngagements).hashCode());
        String $productId = this.getProductId();
        result = result * 59 + ($productId == null ? 43 : $productId.hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        String $engagementId = this.getEngagementId();
        result = result * 59 + ($engagementId == null ? 43 : $engagementId.hashCode());
        String $engagementName = this.getEngagementName();
        result = result * 59 + ($engagementName == null ? 43 : $engagementName.hashCode());
        String $sourceCodeUrl = this.getSourceCodeUrl();
        result = result * 59 + ($sourceCodeUrl == null ? 43 : $sourceCodeUrl.hashCode());
        String $commitHash = this.getCommitHash();
        result = result * 59 + ($commitHash == null ? 43 : $commitHash.hashCode());
        String $branchTag = this.getBranchTag();
        result = result * 59 + ($branchTag == null ? 43 : $branchTag.hashCode());
        String $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
        String $scanType = this.getScanType();
        result = result * 59 + ($scanType == null ? 43 : $scanType.hashCode());
        String $defectDojoUrl = this.getDefectDojoUrl();
        result = result * 59 + ($defectDojoUrl == null ? 43 : $defectDojoUrl.hashCode());
        String $defectDojoCredentialsId = this.getDefectDojoCredentialsId();
        result = result * 59 + ($defectDojoCredentialsId == null ? 43 : $defectDojoCredentialsId.hashCode());
        return result;
    }
}

