/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.DefectDojo;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.util.Secret;
import io.jenkins.plugins.DefectDojo.ApiClientException;
import io.jenkins.plugins.DefectDojo.ApiClientExceptionClassifier;
import io.jenkins.plugins.DefectDojo.ConsoleLogger;
import io.jenkins.plugins.DefectDojo.HttpClientFactory;
import io.jenkins.plugins.DefectDojo.Messages;
import io.jenkins.plugins.okhttp.api.JenkinsOkHttpClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.http.HttpStatus;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.UniformRandomBackOffPolicy;
import org.springframework.retry.policy.BinaryExceptionClassifierRetryPolicy;
import org.springframework.retry.policy.CompositeRetryPolicy;
import org.springframework.retry.policy.MaxAttemptsRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class ApiClient {
    private static final String API_URL = "/api/v2";
    static final String API_KEY_HEADER = "Authorization";
    static final String ENGAGEMENT_URL = "/api/v2/engagements/";
    static final String UPLOAD_URL = "/api/v2/import-scan/";
    static final String REUPLOAD_URL = "/api/v2/reimport-scan/";
    static final String PRODUCT_URL = "/api/v2/products/";
    static final String SCAN_TYPE_URL = "/api/v2/test_types";
    static final String TESTS_URL = "/api/v2/tests";
    static final String LOOKUP_TEST_BY_EGAGEMENT_ID_PARAM = "engagement";
    static final String LOOKUP_TEST_PARAM = "scan_type";
    static final String LOOKUP_NAME_PARAM = "name";
    static final String LOOKUP_NAME_EXACT_PARAM = "name_exact";
    static final String LOOKUP_BY_PRODUCT_ID_PARAM = "product";
    static final String LOOKUP_ID_PARAM = "id";
    private final String baseUrl;
    private final Secret apiKey;
    private final ConsoleLogger logger;
    private final OkHttpClient httpClient;

    public ApiClient(@NonNull String baseUrl, @NonNull Secret apiKey, @NonNull ConsoleLogger logger, int connectionTimeout, int readTimeout) {
        this(baseUrl, apiKey, logger, () -> JenkinsOkHttpClient.newClientBuilder((OkHttpClient)new OkHttpClient()).connectTimeout(Duration.ofSeconds(connectionTimeout)).readTimeout(Duration.ofSeconds(readTimeout)).build());
    }

    ApiClient(@NonNull String baseUrl, @NonNull Secret apiKey, @NonNull ConsoleLogger logger, @NonNull HttpClientFactory factory) {
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
        this.logger = logger;
        this.httpClient = factory.create();
    }

    @NonNull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public boolean testConnection() throws ApiClientException {
        Request request = this.createRequest(URI.create(PRODUCT_URL));
        return this.executeWithRetry(() -> {
            try (Response response = this.httpClient.newCall(request).execute();){
                this.logger.log(response.toString());
                if (response.isSuccessful()) {
                    Boolean bl = true;
                    return bl;
                }
                int status = response.code();
                this.logger.log(response.body().string());
                throw new ApiClientException(Messages.ApiClient_Error_Connection(status, HttpStatus.valueOf((int)status).getReasonPhrase()));
            }
            catch (ApiClientException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ApiClientException(Messages.ApiClient_Error_Connection("", ""), e);
            }
        });
    }

    @NonNull
    public List<JSONObject> getProducts() throws ApiClientException {
        return this.getData(PRODUCT_URL);
    }

    @NonNull
    public List<JSONObject> getEngagements(String productId) throws ApiClientException {
        String url = "/api/v2/engagements/?product=" + productId;
        return this.getData(url);
    }

    @NonNull
    public List<JSONObject> getScanTypes() throws ApiClientException {
        return this.getData(SCAN_TYPE_URL);
    }

    @NonNull
    public String getProductId(String productName) throws ApiClientException {
        URI uri = UriComponentsBuilder.fromUriString((String)PRODUCT_URL).queryParam(LOOKUP_NAME_EXACT_PARAM, new Object[]{"{productName}"}).build(new Object[]{productName});
        return this.getIdFromDojo(this.createRequest(uri));
    }

    @NonNull
    public String getEngagementId(@Nullable String productId, String engagementName) throws ApiClientException {
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)ENGAGEMENT_URL).queryParam(LOOKUP_NAME_PARAM, new Object[]{"{engagementName}"});
        URI uri = uriBuilder.build(new Object[]{engagementName});
        if (productId != null) {
            uriBuilder.queryParam(LOOKUP_BY_PRODUCT_ID_PARAM, new Object[]{"{productId}"});
            uri = uriBuilder.build(new Object[]{engagementName, productId});
        }
        return this.getIdFromDojo(this.createRequest(uri));
    }

    @NonNull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Boolean upload(String projectId, String engagementId, @Nullable String sourceCodeUri, @Nullable String branchTag, @Nullable String commitHash, @NonNull FilePath artifact, @NonNull String scanType, boolean reuploadScan) throws IOException, InterruptedException {
        if (!artifact.exists()) {
            this.logger.log(Messages.Builder_Error_Processing(artifact.getRemote()));
            return false;
        }
        String scanId = null;
        String url = UPLOAD_URL;
        JSONObject jsonBody = new JSONObject();
        jsonBody.put(LOOKUP_TEST_PARAM, (Object)scanType);
        jsonBody.put(LOOKUP_TEST_BY_EGAGEMENT_ID_PARAM, (Object)engagementId);
        jsonBody.put("product_id", (Object)projectId);
        if (StringUtils.isNotBlank((String)sourceCodeUri)) {
            jsonBody.put("source_code_management_uri", (Object)sourceCodeUri);
        }
        if (StringUtils.isNotBlank((String)branchTag)) {
            jsonBody.put("branch_tag", (Object)branchTag);
        }
        if (StringUtils.isNotBlank((String)commitHash)) {
            jsonBody.put("commit_hash", (Object)commitHash);
        }
        jsonBody.put("do_not_reactivate", (Object)"true");
        jsonBody.put("active", (Object)"false");
        jsonBody.put("verified", (Object)"false");
        jsonBody.put("environment", (Object)"");
        jsonBody.put("minimum_severity", (Object)"Low");
        RequestBody fileRequestBody = RequestBody.create((File)new File(artifact.getRemote()), (MediaType)MediaType.parse((String)"application/octet-stream"));
        if (StringUtils.isNotBlank((String)engagementId)) {
            scanId = this.getScanId(engagementId, scanType);
        }
        if (reuploadScan && StringUtils.isNotBlank(scanId)) {
            url = REUPLOAD_URL;
            jsonBody.put("test", (Object)scanId);
            jsonBody.remove("active");
            jsonBody.remove("verified");
        }
        RequestBody uploadBody = this.createMultipartBody(jsonBody, fileRequestBody);
        Request request = this.createRequest(URI.create(url), "POST", uploadBody);
        return this.executeWithRetry(() -> {
            try (Response response = this.httpClient.newCall(request).execute();){
                String body = response.body().string();
                int status = response.code();
                switch (status) {
                    case 200: 
                    case 201: 
                    case 202: {
                        Boolean bl = true;
                        return bl;
                    }
                    case 400: {
                        this.logger.log(Messages.Builder_Payload_Invalid());
                        break;
                    }
                    case 401: {
                        this.logger.log(Messages.Builder_Unauthorized());
                        break;
                    }
                    case 404: {
                        this.logger.log(Messages.Builder_Product_NotFound());
                        break;
                    }
                    default: {
                        this.logger.log(Messages.ApiClient_Error_Connection(status, HttpStatus.valueOf((int)status).getReasonPhrase()));
                    }
                }
                this.logger.log(body);
                Boolean bl = false;
                return bl;
            }
        });
    }

    public String createEngagement(String engagementName, String productId, @Nullable String sourceCodeUrl) throws IOException {
        String defaultValues = "{\"description\": \"Auto-created via Jenkins\",\"engagement_type\":\"Interactive\",\"status\": \"In Progress\",\"deduplication_on_engagement\": \"true\"}";
        JSONObject jsonBody = JSONObject.fromObject((Object)"{\"description\": \"Auto-created via Jenkins\",\"engagement_type\":\"Interactive\",\"status\": \"In Progress\",\"deduplication_on_engagement\": \"true\"}");
        LocalDate currentDate = LocalDate.now();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        jsonBody.put(LOOKUP_NAME_PARAM, (Object)engagementName);
        jsonBody.put(LOOKUP_BY_PRODUCT_ID_PARAM, (Object)productId);
        jsonBody.put("target_start", (Object)currentDate.format(dateFormatter));
        jsonBody.put("target_end", (Object)currentDate.plusDays(30L).format(dateFormatter));
        if (StringUtils.isNotBlank((String)sourceCodeUrl)) {
            jsonBody.put("source_code_management_uri", (Object)sourceCodeUrl);
        }
        Request request = this.createRequest(URI.create(ENGAGEMENT_URL), "POST", RequestBody.create((String)jsonBody.toString(), (MediaType)MediaType.parse((String)"application/json")));
        return this.executeWithRetry(() -> {
            try (Response response = this.httpClient.newCall(request).execute();){
                String body = response.body().string();
                int status = response.code();
                switch (status) {
                    case 201: {
                        String string = JSONObject.fromObject((Object)body).get(LOOKUP_ID_PARAM).toString();
                        return string;
                    }
                    case 400: {
                        this.logger.log(Messages.Builder_Payload_Invalid());
                        break;
                    }
                    case 401: {
                        this.logger.log(Messages.Builder_Unauthorized());
                        break;
                    }
                    default: {
                        this.logger.log(Messages.ApiClient_Error_Connection(status, HttpStatus.valueOf((int)status).getReasonPhrase()));
                    }
                }
                this.logger.log(body);
                String string = null;
                return string;
            }
        });
    }

    public String createProduct(String productName, @Nullable String origin) throws IOException {
        String defaultValues = "{\"description\": \"Auto-created via Jenkins\",\"prod_type\":\"1\"}";
        JSONObject jsonBody = JSONObject.fromObject((Object)"{\"description\": \"Auto-created via Jenkins\",\"prod_type\":\"1\"}");
        jsonBody.put(LOOKUP_NAME_PARAM, (Object)productName);
        if (StringUtils.isNotBlank((String)origin)) {
            jsonBody.put("origin", (Object)origin);
        }
        Request request = this.createRequest(URI.create(PRODUCT_URL), "POST", RequestBody.create((String)jsonBody.toString(), (MediaType)MediaType.parse((String)"application/json")));
        return this.executeWithRetry(() -> {
            try (Response response = this.httpClient.newCall(request).execute();){
                String body = response.body().string();
                int status = response.code();
                switch (status) {
                    case 201: {
                        String string = JSONObject.fromObject((Object)body).get(LOOKUP_ID_PARAM).toString();
                        return string;
                    }
                    case 400: {
                        this.logger.log(Messages.Builder_Payload_Invalid());
                        break;
                    }
                    case 401: {
                        this.logger.log(Messages.Builder_Unauthorized());
                        break;
                    }
                    default: {
                        this.logger.log(Messages.ApiClient_Error_Connection(status, HttpStatus.valueOf((int)status).getReasonPhrase()));
                    }
                }
                this.logger.log(body);
                String string = null;
                return string;
            }
        });
    }

    @NonNull
    private List<JSONObject> getData(String URL2) throws ApiClientException {
        ArrayList<JSONObject> data = new ArrayList<JSONObject>();
        int offset = 0;
        boolean fetchMore = true;
        while (fetchMore) {
            JSONArray pagedData = (JSONArray)this.getPaged(offset, offset += 500, URL2);
            List fetchedData = pagedData.stream().map(JSONObject.class::cast).collect(Collectors.toList());
            fetchMore = !fetchedData.isEmpty();
            data.addAll(fetchedData);
        }
        return data;
    }

    @NonNull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private List<Object> getPaged(int offset, int limit, String URL2) throws ApiClientException {
        URI uri = UriComponentsBuilder.fromUriString((String)URL2).queryParam("limit", new Object[]{"{limit}"}).queryParam("offset", new Object[]{"{offset}"}).build(new Object[]{limit, offset});
        Request request = this.createRequest(uri);
        return (List)this.executeWithRetry(() -> {
            try (Response response = this.httpClient.newCall(request).execute();){
                if (response.isSuccessful()) {
                    JSONArray jSONArray2 = this.getRequestResult(response.body().string());
                    return jSONArray2;
                }
                JSONArray jSONArray = new JSONArray();
                return jSONArray;
            }
            catch (IOException e) {
                throw new ApiClientException(Messages.ApiClient_Error_Connection("", ""), e);
            }
        });
    }

    @NonNull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private String getScanId(@NonNull String engagmentId, @NonNull String scanType) throws ApiClientException {
        URI uri = UriComponentsBuilder.fromUriString((String)TESTS_URL).queryParam(LOOKUP_TEST_BY_EGAGEMENT_ID_PARAM, new Object[]{"{id}"}).queryParam(LOOKUP_TEST_PARAM, new Object[]{"{scanType}"}).build(new Object[]{engagmentId, scanType});
        return this.getIdFromDojo(this.createRequest(uri));
    }

    private String getIdFromDojo(Request request) throws ApiClientException {
        return this.executeWithRetry(() -> {
            try (Response response = this.httpClient.newCall(request).execute();){
                JSONArray results;
                String body = response.body().string();
                if (!response.isSuccessful()) {
                    this.logger.log(body);
                }
                if ((results = this.getRequestResult(body)).size() > 0) {
                    String string2 = ((JSONObject)results.get(0)).getString(LOOKUP_ID_PARAM);
                    return string2;
                }
                String string = null;
                return string;
            }
            catch (ApiClientException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ApiClientException(Messages.ApiClient_Error_Connection("", ""), e);
            }
        });
    }

    private JSONArray getRequestResult(String response) {
        return JSONObject.fromObject((Object)response).getJSONArray("results");
    }

    private RequestBody createMultipartBody(JSONObject json, @Nullable RequestBody filePart) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        json.keySet().forEach(key -> {
            Object value = json.get(key);
            builder.addFormDataPart(key.toString(), value.toString());
        });
        if (filePart != null) {
            builder.addFormDataPart("file", "file.json", filePart);
        }
        return builder.build();
    }

    private Request createRequest(URI uri) {
        return this.createRequest(uri, "GET", null);
    }

    private Request createRequest(URI uri, String method, RequestBody bodyPublisher) {
        return new Request.Builder().url(this.baseUrl + String.valueOf(uri)).addHeader(API_KEY_HEADER, "Token " + this.apiKey.getPlainText()).addHeader("Accept", "application/json").method(method, bodyPublisher).build();
    }

    private <T, E extends IOException> T executeWithRetry(RetryAction<T, E> action) throws E {
        ApiClientExceptionClassifier exceptionClassifier = new ApiClientExceptionClassifier();
        CompositeRetryPolicy retryPolicy = new CompositeRetryPolicy();
        UniformRandomBackOffPolicy backOffPolicy = new UniformRandomBackOffPolicy();
        RetryTemplate template = new RetryTemplate();
        backOffPolicy.setMinBackOffPeriod(50L);
        backOffPolicy.setMaxBackOffPeriod(500L);
        retryPolicy.setPolicies(new RetryPolicy[]{new MaxAttemptsRetryPolicy(2), new BinaryExceptionClassifierRetryPolicy((BinaryExceptionClassifier)exceptionClassifier)});
        template.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        template.setRetryPolicy((RetryPolicy)retryPolicy);
        return (T)template.execute(ctx -> action.executeWithRetry());
    }

    private static interface RetryAction<T, E extends IOException> {
        public T executeWithRetry() throws E;
    }
}

