// CHECKSTYLE:OFF

package io.jenkins.plugins.DefectDojo;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Builder.Fetching.Engagement}: {@code Fetching engagement
     * from DefectDojo - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fetching engagement from DefectDojo - {0}}
     */
    public static String Builder_Fetching_Engagement(Object arg0) {
        return holder.format("Builder.Fetching.Engagement", arg0);
    }

    /**
     * Key {@code Builder.Fetching.Engagement}: {@code Fetching engagement
     * from DefectDojo - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fetching engagement from DefectDojo - {0}}
     */
    public static Localizable _Builder_Fetching_Engagement(Object arg0) {
        return new Localizable(holder, "Builder.Fetching.Engagement", arg0);
    }

    /**
     * Key {@code Builder.Upload.Failed}: {@code Uploading artifact failed}.
     * 
     * @return
     *     {@code Uploading artifact failed}
     */
    public static String Builder_Upload_Failed() {
        return holder.format("Builder.Upload.Failed");
    }

    /**
     * Key {@code Builder.Upload.Failed}: {@code Uploading artifact failed}.
     * 
     * @return
     *     {@code Uploading artifact failed}
     */
    public static Localizable _Builder_Upload_Failed() {
        return new Localizable(holder, "Builder.Upload.Failed");
    }

    /**
     * Key {@code ApiClient.Error.Connection}: {@code An error occurred
     * connecting to DefectDojo - HTTP response code: {0} {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred connecting to DefectDojo - HTTP response
     *     code: {0} {1}}
     */
    public static String ApiClient_Error_Connection(Object arg0, Object arg1) {
        return holder.format("ApiClient.Error.Connection", arg0, arg1);
    }

    /**
     * Key {@code ApiClient.Error.Connection}: {@code An error occurred
     * connecting to DefectDojo - HTTP response code: {0} {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred connecting to DefectDojo - HTTP response
     *     code: {0} {1}}
     */
    public static Localizable _ApiClient_Error_Connection(Object arg0, Object arg1) {
        return new Localizable(holder, "ApiClient.Error.Connection", arg0, arg1);
    }

    /**
     * Key {@code Builder.Product.NotFound}: {@code The specified product
     * could not be found}.
     * 
     * @return
     *     {@code The specified product could not be found}
     */
    public static String Builder_Product_NotFound() {
        return holder.format("Builder.Product.NotFound");
    }

    /**
     * Key {@code Builder.Product.NotFound}: {@code The specified product
     * could not be found}.
     * 
     * @return
     *     {@code The specified product could not be found}
     */
    public static Localizable _Builder_Product_NotFound() {
        return new Localizable(holder, "Builder.Product.NotFound");
    }

    /**
     * Key {@code Builder.Publishing}: {@code Uploading scan to DefectDojo -
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Uploading scan to DefectDojo - {0}}
     */
    public static String Builder_Publishing(Object arg0) {
        return holder.format("Builder.Publishing", arg0);
    }

    /**
     * Key {@code Builder.Publishing}: {@code Uploading scan to DefectDojo -
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Uploading scan to DefectDojo - {0}}
     */
    public static Localizable _Builder_Publishing(Object arg0) {
        return new Localizable(holder, "Builder.Publishing", arg0);
    }

    /**
     * Key {@code Builder.Publishing.Engagement}: {@code Creating engagement
     * in DefectDojo - {0}/{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Creating engagement in DefectDojo - {0}/{1}}
     */
    public static String Builder_Publishing_Engagement(Object arg0, Object arg1) {
        return holder.format("Builder.Publishing.Engagement", arg0, arg1);
    }

    /**
     * Key {@code Builder.Publishing.Engagement}: {@code Creating engagement
     * in DefectDojo - {0}/{1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Creating engagement in DefectDojo - {0}/{1}}
     */
    public static Localizable _Builder_Publishing_Engagement(Object arg0, Object arg1) {
        return new Localizable(holder, "Builder.Publishing.Engagement", arg0, arg1);
    }

    /**
     * Key {@code Builder.Connection.Failed}: {@code Could not connect to
     * DefectDojo. Please check the plugin configuration.}.
     * 
     * @return
     *     {@code Could not connect to DefectDojo. Please check the plugin
     *     configuration.}
     */
    public static String Builder_Connection_Failed() {
        return holder.format("Builder.Connection.Failed");
    }

    /**
     * Key {@code Builder.Connection.Failed}: {@code Could not connect to
     * DefectDojo. Please check the plugin configuration.}.
     * 
     * @return
     *     {@code Could not connect to DefectDojo. Please check the plugin
     *     configuration.}
     */
    public static Localizable _Builder_Connection_Failed() {
        return new Localizable(holder, "Builder.Connection.Failed");
    }

    /**
     * Key {@code Builder.ScanType.Unspecified}: {@code A scan type was not
     * specified}.
     * 
     * @return
     *     {@code A scan type was not specified}
     */
    public static String Builder_ScanType_Unspecified() {
        return holder.format("Builder.ScanType.Unspecified");
    }

    /**
     * Key {@code Builder.ScanType.Unspecified}: {@code A scan type was not
     * specified}.
     * 
     * @return
     *     {@code A scan type was not specified}
     */
    public static Localizable _Builder_ScanType_Unspecified() {
        return new Localizable(holder, "Builder.ScanType.Unspecified");
    }

    /**
     * Key {@code Builder.Error.Engagements}: {@code Unable to retrieve
     * engagements. Error was: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to retrieve engagements. Error was: {0}}
     */
    public static String Builder_Error_Engagements(Object arg0) {
        return holder.format("Builder.Error.Engagements", arg0);
    }

    /**
     * Key {@code Builder.Error.Engagements}: {@code Unable to retrieve
     * engagements. Error was: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to retrieve engagements. Error was: {0}}
     */
    public static Localizable _Builder_Error_Engagements(Object arg0) {
        return new Localizable(holder, "Builder.Error.Engagements", arg0);
    }

    /**
     * Key {@code Publisher.ProductList.Placeholder}: {@code -- Select
     * Product --}.
     * 
     * @return
     *     {@code -- Select Product --}
     */
    public static String Publisher_ProductList_Placeholder() {
        return holder.format("Publisher.ProductList.Placeholder");
    }

    /**
     * Key {@code Publisher.ProductList.Placeholder}: {@code -- Select
     * Product --}.
     * 
     * @return
     *     {@code -- Select Product --}
     */
    public static Localizable _Publisher_ProductList_Placeholder() {
        return new Localizable(holder, "Publisher.ProductList.Placeholder");
    }

    /**
     * Key {@code Publisher.ConnectionTest.Error}: {@code Connection failed -
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection failed - {0}}
     */
    public static String Publisher_ConnectionTest_Error(Object arg0) {
        return holder.format("Publisher.ConnectionTest.Error", arg0);
    }

    /**
     * Key {@code Publisher.ConnectionTest.Error}: {@code Connection failed -
     * {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection failed - {0}}
     */
    public static Localizable _Publisher_ConnectionTest_Error(Object arg0) {
        return new Localizable(holder, "Publisher.ConnectionTest.Error", arg0);
    }

    /**
     * Key {@code ApiClient.Error.ProductLoad}: {@code An error occurred
     * while loading project with id "{0}" - HTTP response code: {1} {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred while loading project with id "{0}" - HTTP
     *     response code: {1} {2}}
     */
    public static String ApiClient_Error_ProductLoad(Object arg0, Object arg1, Object arg2) {
        return holder.format("ApiClient.Error.ProductLoad", arg0, arg1, arg2);
    }

    /**
     * Key {@code ApiClient.Error.ProductLoad}: {@code An error occurred
     * while loading project with id "{0}" - HTTP response code: {1} {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred while loading project with id "{0}" - HTTP
     *     response code: {1} {2}}
     */
    public static Localizable _ApiClient_Error_ProductLoad(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ApiClient.Error.ProductLoad", arg0, arg1, arg2);
    }

    /**
     * Key {@code Builder.Artifact.NonExist}: {@code The specified artifact
     * "{0}" does not exist}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The specified artifact "{0}" does not exist}
     */
    public static String Builder_Artifact_NonExist(Object arg0) {
        return holder.format("Builder.Artifact.NonExist", arg0);
    }

    /**
     * Key {@code Builder.Artifact.NonExist}: {@code The specified artifact
     * "{0}" does not exist}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The specified artifact "{0}" does not exist}
     */
    public static Localizable _Builder_Artifact_NonExist(Object arg0) {
        return new Localizable(holder, "Builder.Artifact.NonExist", arg0);
    }

    /**
     * Key {@code Builder.Result.EngagementIdMissing}: {@code The
     * engagementId has to be specified when auto create engagements is not
     * enabled}.
     * 
     * @return
     *     {@code The engagementId has to be specified when auto create
     *     engagements is not enabled}
     */
    public static String Builder_Result_EngagementIdMissing() {
        return holder.format("Builder.Result.EngagementIdMissing");
    }

    /**
     * Key {@code Builder.Result.EngagementIdMissing}: {@code The
     * engagementId has to be specified when auto create engagements is not
     * enabled}.
     * 
     * @return
     *     {@code The engagementId has to be specified when auto create
     *     engagements is not enabled}
     */
    public static Localizable _Builder_Result_EngagementIdMissing() {
        return new Localizable(holder, "Builder.Result.EngagementIdMissing");
    }

    /**
     * Key {@code ApiClient.Error.EngagementLookup}: {@code An error occurred
     * while looking up engagement id for name "{0}"" - HTTP response code:
     * {1} {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred while looking up engagement id for name
     *     "{0}"" - HTTP response code: {1} {2}}
     */
    public static String ApiClient_Error_EngagementLookup(Object arg0, Object arg1, Object arg2) {
        return holder.format("ApiClient.Error.EngagementLookup", arg0, arg1, arg2);
    }

    /**
     * Key {@code ApiClient.Error.EngagementLookup}: {@code An error occurred
     * while looking up engagement id for name "{0}"" - HTTP response code:
     * {1} {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred while looking up engagement id for name
     *     "{0}"" - HTTP response code: {1} {2}}
     */
    public static Localizable _ApiClient_Error_EngagementLookup(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ApiClient.Error.EngagementLookup", arg0, arg1, arg2);
    }

    /**
     * Key {@code Builder.Product.Lookup}: {@code Looking up id of newly
     * created product with name "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Looking up id of newly created product with name "{0}"}
     */
    public static String Builder_Product_Lookup(Object arg0) {
        return holder.format("Builder.Product.Lookup", arg0);
    }

    /**
     * Key {@code Builder.Product.Lookup}: {@code Looking up id of newly
     * created product with name "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Looking up id of newly created product with name "{0}"}
     */
    public static Localizable _Builder_Product_Lookup(Object arg0) {
        return new Localizable(holder, "Builder.Product.Lookup", arg0);
    }

    /**
     * Key {@code Builder.Unauthorized}: {@code Unauthorized. Ensure a valid
     * API key is specified.}.
     * 
     * @return
     *     {@code Unauthorized. Ensure a valid API key is specified.}
     */
    public static String Builder_Unauthorized() {
        return holder.format("Builder.Unauthorized");
    }

    /**
     * Key {@code Builder.Unauthorized}: {@code Unauthorized. Ensure a valid
     * API key is specified.}.
     * 
     * @return
     *     {@code Unauthorized. Ensure a valid API key is specified.}
     */
    public static Localizable _Builder_Unauthorized() {
        return new Localizable(holder, "Builder.Unauthorized");
    }

    /**
     * Key {@code Publisher.ConnectionTest.InputError}: {@code URL must be
     * valid and Api-Key must not be empty}.
     * 
     * @return
     *     {@code URL must be valid and Api-Key must not be empty}
     */
    public static String Publisher_ConnectionTest_InputError() {
        return holder.format("Publisher.ConnectionTest.InputError");
    }

    /**
     * Key {@code Publisher.ConnectionTest.InputError}: {@code URL must be
     * valid and Api-Key must not be empty}.
     * 
     * @return
     *     {@code URL must be valid and Api-Key must not be empty}
     */
    public static Localizable _Publisher_ConnectionTest_InputError() {
        return new Localizable(holder, "Publisher.ConnectionTest.InputError");
    }

    /**
     * Key {@code Publisher.Agent.Anouncement}: {@code Artifact on agent
     * node}.
     * 
     * @return
     *     {@code Artifact on agent node}
     */
    public static String Publisher_Agent_Anouncement() {
        return holder.format("Publisher.Agent.Anouncement");
    }

    /**
     * Key {@code Publisher.Agent.Anouncement}: {@code Artifact on agent
     * node}.
     * 
     * @return
     *     {@code Artifact on agent node}
     */
    public static Localizable _Publisher_Agent_Anouncement() {
        return new Localizable(holder, "Publisher.Agent.Anouncement");
    }

    /**
     * Key {@code Builder.Artifact.Unspecified}: {@code An artifact was not
     * specified}.
     * 
     * @return
     *     {@code An artifact was not specified}
     */
    public static String Builder_Artifact_Unspecified() {
        return holder.format("Builder.Artifact.Unspecified");
    }

    /**
     * Key {@code Builder.Artifact.Unspecified}: {@code An artifact was not
     * specified}.
     * 
     * @return
     *     {@code An artifact was not specified}
     */
    public static Localizable _Builder_Artifact_Unspecified() {
        return new Localizable(holder, "Builder.Artifact.Unspecified");
    }

    /**
     * Key {@code Publisher.ConnectionTest.Success}: {@code Connection
     * successful - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection successful - {0}}
     */
    public static String Publisher_ConnectionTest_Success(Object arg0) {
        return holder.format("Publisher.ConnectionTest.Success", arg0);
    }

    /**
     * Key {@code Publisher.ConnectionTest.Success}: {@code Connection
     * successful - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection successful - {0}}
     */
    public static Localizable _Publisher_ConnectionTest_Success(Object arg0) {
        return new Localizable(holder, "Publisher.ConnectionTest.Success", arg0);
    }

    /**
     * Key {@code ApiClient.Error.ProductLookup}: {@code An error occurred
     * while looking up project id for name "{0}"" - HTTP response code: {1}
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred while looking up project id for name "{0}"" -
     *     HTTP response code: {1} {2}}
     */
    public static String ApiClient_Error_ProductLookup(Object arg0, Object arg1, Object arg2) {
        return holder.format("ApiClient.Error.ProductLookup", arg0, arg1, arg2);
    }

    /**
     * Key {@code ApiClient.Error.ProductLookup}: {@code An error occurred
     * while looking up project id for name "{0}"" - HTTP response code: {1}
     * {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred while looking up project id for name "{0}"" -
     *     HTTP response code: {1} {2}}
     */
    public static Localizable _ApiClient_Error_ProductLookup(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ApiClient.Error.ProductLookup", arg0, arg1, arg2);
    }

    /**
     * Key {@code Builder.Error.Processing}: {@code An error occurred
     * processing artifact "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred processing artifact "{0}"}
     */
    public static String Builder_Error_Processing(Object arg0) {
        return holder.format("Builder.Error.Processing", arg0);
    }

    /**
     * Key {@code Builder.Error.Processing}: {@code An error occurred
     * processing artifact "{0}"}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred processing artifact "{0}"}
     */
    public static Localizable _Builder_Error_Processing(Object arg0) {
        return new Localizable(holder, "Builder.Error.Processing", arg0);
    }

    /**
     * Key {@code Publisher.ConnectionTest.InvalidProtocols}: {@code Only
     * URLs with http and https are supported}.
     * 
     * @return
     *     {@code Only URLs with http and https are supported}
     */
    public static String Publisher_ConnectionTest_InvalidProtocols() {
        return holder.format("Publisher.ConnectionTest.InvalidProtocols");
    }

    /**
     * Key {@code Publisher.ConnectionTest.InvalidProtocols}: {@code Only
     * URLs with http and https are supported}.
     * 
     * @return
     *     {@code Only URLs with http and https are supported}
     */
    public static Localizable _Publisher_ConnectionTest_InvalidProtocols() {
        return new Localizable(holder, "Publisher.ConnectionTest.InvalidProtocols");
    }

    /**
     * Key {@code Publisher.ConnectionTest.Warning}: {@code Connection
     * successful with warnings - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection successful with warnings - {0}}
     */
    public static String Publisher_ConnectionTest_Warning(Object arg0) {
        return holder.format("Publisher.ConnectionTest.Warning", arg0);
    }

    /**
     * Key {@code Publisher.ConnectionTest.Warning}: {@code Connection
     * successful with warnings - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Connection successful with warnings - {0}}
     */
    public static Localizable _Publisher_ConnectionTest_Warning(Object arg0) {
        return new Localizable(holder, "Publisher.ConnectionTest.Warning", arg0);
    }

    /**
     * Key {@code Publisher.Agent.CopyToMaster}: {@code Copying artifact {0}
     * from agent to master {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Copying artifact {0} from agent to master {1}}
     */
    public static String Publisher_Agent_CopyToMaster(Object arg0, Object arg1) {
        return holder.format("Publisher.Agent.CopyToMaster", arg0, arg1);
    }

    /**
     * Key {@code Publisher.Agent.CopyToMaster}: {@code Copying artifact {0}
     * from agent to master {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Copying artifact {0} from agent to master {1}}
     */
    public static Localizable _Publisher_Agent_CopyToMaster(Object arg0, Object arg1) {
        return new Localizable(holder, "Publisher.Agent.CopyToMaster", arg0, arg1);
    }

    /**
     * Key {@code Publisher.DefectDojo.Name}: {@code Upload to DefectDojo}.
     * 
     * @return
     *     {@code Upload to DefectDojo}
     */
    public static String Publisher_DefectDojo_Name() {
        return holder.format("Publisher.DefectDojo.Name");
    }

    /**
     * Key {@code Publisher.DefectDojo.Name}: {@code Upload to DefectDojo}.
     * 
     * @return
     *     {@code Upload to DefectDojo}
     */
    public static Localizable _Publisher_DefectDojo_Name() {
        return new Localizable(holder, "Publisher.DefectDojo.Name");
    }

    /**
     * Key {@code Builder.Result.InvalidArguments}: {@code Either the
     * productId with engagementId or the productName with engagementName
     * have to be specified}.
     * 
     * @return
     *     {@code Either the productId with engagementId or the productName with
     *     engagementName have to be specified}
     */
    public static String Builder_Result_InvalidArguments() {
        return holder.format("Builder.Result.InvalidArguments");
    }

    /**
     * Key {@code Builder.Result.InvalidArguments}: {@code Either the
     * productId with engagementId or the productName with engagementName
     * have to be specified}.
     * 
     * @return
     *     {@code Either the productId with engagementId or the productName with
     *     engagementName have to be specified}
     */
    public static Localizable _Builder_Result_InvalidArguments() {
        return new Localizable(holder, "Builder.Result.InvalidArguments");
    }

    /**
     * Key {@code Builder.Error.Products}: {@code Unable to retrieve
     * products. Error was: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to retrieve products. Error was: {0}}
     */
    public static String Builder_Error_Products(Object arg0) {
        return holder.format("Builder.Error.Products", arg0);
    }

    /**
     * Key {@code Builder.Error.Products}: {@code Unable to retrieve
     * products. Error was: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Unable to retrieve products. Error was: {0}}
     */
    public static Localizable _Builder_Error_Products(Object arg0) {
        return new Localizable(holder, "Builder.Error.Products", arg0);
    }

    /**
     * Key {@code Publisher.ConnectionTest.UrlMalformed}: {@code The
     * specified value is not a valid URL}.
     * 
     * @return
     *     {@code The specified value is not a valid URL}
     */
    public static String Publisher_ConnectionTest_UrlMalformed() {
        return holder.format("Publisher.ConnectionTest.UrlMalformed");
    }

    /**
     * Key {@code Publisher.ConnectionTest.UrlMalformed}: {@code The
     * specified value is not a valid URL}.
     * 
     * @return
     *     {@code The specified value is not a valid URL}
     */
    public static Localizable _Publisher_ConnectionTest_UrlMalformed() {
        return new Localizable(holder, "Publisher.ConnectionTest.UrlMalformed");
    }

    /**
     * Key {@code Publisher.EngagementList.Placeholder}: {@code -- Select
     * Engagement --}.
     * 
     * @return
     *     {@code -- Select Engagement --}
     */
    public static String Publisher_EngagementList_Placeholder() {
        return holder.format("Publisher.EngagementList.Placeholder");
    }

    /**
     * Key {@code Publisher.EngagementList.Placeholder}: {@code -- Select
     * Engagement --}.
     * 
     * @return
     *     {@code -- Select Engagement --}
     */
    public static Localizable _Publisher_EngagementList_Placeholder() {
        return new Localizable(holder, "Publisher.EngagementList.Placeholder");
    }

    /**
     * Key {@code Publisher.ScanTypeList.Placeholder}: {@code -- Select Scan
     * Type --}.
     * 
     * @return
     *     {@code -- Select Scan Type --}
     */
    public static String Publisher_ScanTypeList_Placeholder() {
        return holder.format("Publisher.ScanTypeList.Placeholder");
    }

    /**
     * Key {@code Publisher.ScanTypeList.Placeholder}: {@code -- Select Scan
     * Type --}.
     * 
     * @return
     *     {@code -- Select Scan Type --}
     */
    public static Localizable _Publisher_ScanTypeList_Placeholder() {
        return new Localizable(holder, "Publisher.ScanTypeList.Placeholder");
    }

    /**
     * Key {@code ApiClient.Error.ProductUpdate}: {@code An error occurred
     * while updating project with id "{0}" - HTTP response code: {1} {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred while updating project with id "{0}" - HTTP
     *     response code: {1} {2}}
     */
    public static String ApiClient_Error_ProductUpdate(Object arg0, Object arg1, Object arg2) {
        return holder.format("ApiClient.Error.ProductUpdate", arg0, arg1, arg2);
    }

    /**
     * Key {@code ApiClient.Error.ProductUpdate}: {@code An error occurred
     * while updating project with id "{0}" - HTTP response code: {1} {2}}.
     * 
     * @param arg2
     *      3rd format parameter, {@code {2}}, as {@link String#valueOf(Object)}.
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred while updating project with id "{0}" - HTTP
     *     response code: {1} {2}}
     */
    public static Localizable _ApiClient_Error_ProductUpdate(Object arg0, Object arg1, Object arg2) {
        return new Localizable(holder, "ApiClient.Error.ProductUpdate", arg0, arg1, arg2);
    }

    /**
     * Key {@code Builder.Fetching.Product}: {@code Fetching product from
     * DefectDojo - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fetching product from DefectDojo - {0}}
     */
    public static String Builder_Fetching_Product(Object arg0) {
        return holder.format("Builder.Fetching.Product", arg0);
    }

    /**
     * Key {@code Builder.Fetching.Product}: {@code Fetching product from
     * DefectDojo - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Fetching product from DefectDojo - {0}}
     */
    public static Localizable _Builder_Fetching_Product(Object arg0) {
        return new Localizable(holder, "Builder.Fetching.Product", arg0);
    }

    /**
     * Key {@code Builder.Publishing.Product}: {@code Creating product in
     * DefectDojo - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Creating product in DefectDojo - {0}}
     */
    public static String Builder_Publishing_Product(Object arg0) {
        return holder.format("Builder.Publishing.Product", arg0);
    }

    /**
     * Key {@code Builder.Publishing.Product}: {@code Creating product in
     * DefectDojo - {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Creating product in DefectDojo - {0}}
     */
    public static Localizable _Builder_Publishing_Product(Object arg0) {
        return new Localizable(holder, "Builder.Publishing.Product", arg0);
    }

    /**
     * Key {@code Builder.Payload.Invalid}: {@code Invalid payload submitted
     * to server}.
     * 
     * @return
     *     {@code Invalid payload submitted to server}
     */
    public static String Builder_Payload_Invalid() {
        return holder.format("Builder.Payload.Invalid");
    }

    /**
     * Key {@code Builder.Payload.Invalid}: {@code Invalid payload submitted
     * to server}.
     * 
     * @return
     *     {@code Invalid payload submitted to server}
     */
    public static Localizable _Builder_Payload_Invalid() {
        return new Localizable(holder, "Builder.Payload.Invalid");
    }

    /**
     * Key {@code Builder.Success}: {@code The scan was successfully
     * published. You may now navigate to {0} to view the results.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The scan was successfully published. You may now navigate to
     *     {0} to view the results.}
     */
    public static String Builder_Success(Object arg0) {
        return holder.format("Builder.Success", arg0);
    }

    /**
     * Key {@code Builder.Success}: {@code The scan was successfully
     * published. You may now navigate to {0} to view the results.}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code The scan was successfully published. You may now navigate to
     *     {0} to view the results.}
     */
    public static Localizable _Builder_Success(Object arg0) {
        return new Localizable(holder, "Builder.Success", arg0);
    }

    /**
     * Key {@code Builder.Result.ProductIdMissing}: {@code The productId has
     * to be specified when auto create products is not enabled}.
     * 
     * @return
     *     {@code The productId has to be specified when auto create products is
     *     not enabled}
     */
    public static String Builder_Result_ProductIdMissing() {
        return holder.format("Builder.Result.ProductIdMissing");
    }

    /**
     * Key {@code Builder.Result.ProductIdMissing}: {@code The productId has
     * to be specified when auto create products is not enabled}.
     * 
     * @return
     *     {@code The productId has to be specified when auto create products is
     *     not enabled}
     */
    public static Localizable _Builder_Result_ProductIdMissing() {
        return new Localizable(holder, "Builder.Result.ProductIdMissing");
    }

}
