/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.database.sqlserver;

import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.database.AbstractRemoteDatabase;
import org.jenkinsci.plugins.database.AbstractRemoteDatabaseDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SQLServerDatabase
extends AbstractRemoteDatabase {
    private static final long serialVersionUID = 1L;

    @DataBoundConstructor
    public SQLServerDatabase(String hostname, String database, String username, Secret password, String properties) {
        super(hostname, database, username, password, properties);
    }

    protected Class<? extends Driver> getDriverClass() {
        return SQLServerDriver.class;
    }

    protected String getJdbcUrl() {
        return "jdbc:sqlserver://" + this.hostname + ";databaseName=" + this.database;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractRemoteDatabaseDescriptor {
        @NonNull
        public String getDisplayName() {
            return "Microsoft SQL Server";
        }

        @POST
        public FormValidation doCheckProperties(@QueryParameter String properties) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            try {
                HashSet<String> validPropertyNames = new HashSet<String>();
                Properties props = Util.loadProperties((String)properties);
                for (DriverPropertyInfo p : new SQLServerDriver().getPropertyInfo("jdbc:sqlserver://localhost;databaseName=dummy", props)) {
                    validPropertyNames.add(p.name);
                }
                for (Map.Entry entry : props.entrySet()) {
                    String key = entry.getKey().toString();
                    if (validPropertyNames.contains(key)) continue;
                    return FormValidation.error((String)("Unrecognized property: " + key));
                }
                return FormValidation.ok();
            }
            catch (Throwable e) {
                return FormValidation.warning((Throwable)e, (String)"Failed to validate the connection properties");
            }
        }
    }
}

