/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.formatter;

import hudson.Extension;
import hudson.util.FormValidation;
import io.jenkins.plugins.formatter.CustomPolicyBuilder;
import io.jenkins.plugins.formatter.DefinedException;
import java.lang.reflect.InvocationTargetException;
import jenkins.model.GlobalConfiguration;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@Extension
public class PolicyConfiguration
extends GlobalConfiguration {
    private String policyDefinition;
    public static final String DEFAULT_POLICY = "[\n\t{\n\t\t\"type\": \"inbuilt\",\n\t\t\"name\": \"blocks, formatting, styles, links, tables, images\"\n\t},\n\t{\n\t\t\"type\": \"new\",\n\t\t\"allow\": {\n\t\t\t\"dl, dt, dd, hr, pre\": \"\"\n\t\t}\n\t}\n]";

    public static PolicyConfiguration get() {
        return (PolicyConfiguration)((Object)GlobalConfiguration.all().get(PolicyConfiguration.class));
    }

    public PolicyConfiguration() {
        this.load();
        if (this.getPolicyDefinition() == null || this.getPolicyDefinition().equals("")) {
            this.setPolicyDefinition(DEFAULT_POLICY);
        }
    }

    public String getPolicyDefinition() {
        return this.policyDefinition;
    }

    @DataBoundSetter
    public void setPolicyDefinition(String policyDefinition) {
        this.policyDefinition = policyDefinition;
        this.save();
    }

    public FormValidation doCheckPolicyDefinition(@QueryParameter String value) {
        if (StringUtils.isEmpty((String)value)) {
            return FormValidation.warning((String)"Please specify a value.");
        }
        try {
            CustomPolicyBuilder.build(value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return FormValidation.error((String)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            return FormValidation.error((String)("No such method " + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            return FormValidation.error((String)e.getMessage());
        }
        catch (DefinedException e) {
            e.printStackTrace();
            return FormValidation.error((String)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            return FormValidation.error((String)e.getMessage());
        }
        return FormValidation.ok();
    }
}

