/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.formatter;

import io.jenkins.plugins.formatter.DefinedException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;
import org.owasp.html.Sanitizers;

public class CustomPolicyBuilder {
    public static final String INBUILT_TYPE = "inbuilt";
    public static final String NEW_TYPE = "new";
    public static final String DEFAULT_TYPE = "default";
    public static final PolicyFactory ADDITIONS = new HtmlPolicyBuilder().allowElements(new String[]{"dl", "dt", "dd", "hr", "pre"}).allowElements(new String[]{"font"}).allowWithoutAttributes(new String[]{"font"}).allowAttributes(new String[]{"size", "color"}).onElements(new String[]{"font"}).allowStandardUrlProtocols().allowElements(new String[]{"a"}).allowAttributes(new String[]{"href", "target"}).onElements(new String[]{"a"}).toFactory();

    public static void trimArray(String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = arr[i].trim();
        }
    }

    private static PolicyFactory getInbuiltPolicy(String name) throws DefinedException {
        switch (name = name.toUpperCase().trim()) {
            case "BLOCKS": {
                return Sanitizers.BLOCKS;
            }
            case "TABLES": {
                return Sanitizers.TABLES;
            }
            case "LINKS": {
                return Sanitizers.LINKS;
            }
            case "FORMATTING": {
                return Sanitizers.FORMATTING;
            }
            case "IMAGES": {
                return Sanitizers.IMAGES;
            }
            case "STYLES": {
                return Sanitizers.STYLES;
            }
        }
        throw new DefinedException("No inbuilt policy named \"" + name + "\" found");
    }

    public static PolicyFactory build(String jsonArrayString) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException, DefinedException {
        JSONArray policyJsonArray = new JSONArray(jsonArrayString);
        PolicyFactory policyFactory = CustomPolicyBuilder.parseJsonPolicy(policyJsonArray.getJSONObject(0));
        for (int policyNumber = 1; policyNumber < policyJsonArray.length(); ++policyNumber) {
            JSONObject policyJson = policyJsonArray.getJSONObject(policyNumber);
            PolicyFactory policy = CustomPolicyBuilder.parseJsonPolicy(policyJson);
            policyFactory = policyFactory.and(policy);
        }
        return policyFactory;
    }

    public static PolicyFactory parseJsonPolicy(JSONObject policyJson) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException, DefinedException {
        String type;
        switch (type = policyJson.getString("type")) {
            case "inbuilt": {
                String[] inbuiltPolicyNames = policyJson.getString("name").split(",");
                PolicyFactory policyFactory = CustomPolicyBuilder.getInbuiltPolicy(inbuiltPolicyNames[0]);
                for (int inbuiltPolicyNumber = 1; inbuiltPolicyNumber < inbuiltPolicyNames.length; ++inbuiltPolicyNumber) {
                    policyFactory = policyFactory.and(CustomPolicyBuilder.getInbuiltPolicy(inbuiltPolicyNames[inbuiltPolicyNumber]));
                }
                return policyFactory;
            }
            case "new": {
                HtmlPolicyBuilder policyBuilder = new HtmlPolicyBuilder();
                if (policyJson.has("allow")) {
                    JSONObject allowedTags = policyJson.getJSONObject("allow");
                    for (String tagListStr : allowedTags.keySet()) {
                        String[] tagList = tagListStr.split(",");
                        Object tagAttrConfigValue = allowedTags.get(tagListStr);
                        JSONArray attrConfigList = new JSONArray();
                        if (tagAttrConfigValue instanceof String) {
                            String[] attributeList = allowedTags.getString(tagListStr).split(",");
                            CustomPolicyBuilder.trimArray(attributeList);
                            String[] stringArray = attributeList;
                            int n = stringArray.length;
                            for (int i = 0; i < n; ++i) {
                                String attr = stringArray[i];
                                String[] a = attr.split("::", 2);
                                JSONObject jsonObject = new JSONObject();
                                jsonObject.put("name", (Object)a[0]);
                                if (a.length > 1) {
                                    jsonObject.put("pattern", (Object)a[1]);
                                }
                                attrConfigList.put((Object)jsonObject);
                            }
                        } else if (tagAttrConfigValue instanceof JSONArray) {
                            String[] attrJSONArrayList = (String[])tagAttrConfigValue;
                            for (int i = 0; i < attrJSONArrayList.length(); ++i) {
                                Object attr = attrJSONArrayList.get(i);
                                if (attr instanceof String) {
                                    String[] a = ((String)attr).trim().split("::", 2);
                                    JSONObject jsonObject = new JSONObject();
                                    jsonObject.put("name", (Object)a[0]);
                                    if (a.length > 1) {
                                        jsonObject.put("pattern", (Object)a[1]);
                                    }
                                    attrConfigList.put((Object)jsonObject);
                                    continue;
                                }
                                if (attr instanceof JSONObject) {
                                    attrConfigList.put(attr);
                                    continue;
                                }
                                throw new DefinedException("Invalid value " + attrJSONArrayList.getString(i));
                            }
                        } else {
                            throw new DefinedException("Invalid value for tag: " + tagListStr);
                        }
                        CustomPolicyBuilder.trimArray(tagList);
                        for (String tag : tagList) {
                            policyBuilder = policyBuilder.allowElements(new String[]{tag});
                            if (attrConfigList.length() <= 0) continue;
                            policyBuilder = policyBuilder.allowWithoutAttributes(new String[]{tag});
                            for (int attrNum = 0; attrNum < attrConfigList.length(); ++attrNum) {
                                JSONObject attrConfig = attrConfigList.getJSONObject(attrNum);
                                if (attrConfig.has("pattern")) {
                                    Pattern pattern = Pattern.compile(attrConfig.getString("pattern"));
                                    policyBuilder = policyBuilder.allowAttributes(new String[]{attrConfig.getString("name")}).matching(pattern).onElements(new String[]{tag});
                                    continue;
                                }
                                policyBuilder = policyBuilder.allowAttributes(new String[]{attrConfig.getString("name")}).onElements(new String[]{tag});
                            }
                        }
                    }
                }
                if (policyJson.has("methods")) {
                    JSONObject methods = policyJson.getJSONObject("methods");
                    for (String methodName : methods.keySet()) {
                        String[] args = methods.getString(methodName).split(",");
                        CustomPolicyBuilder.trimArray(args);
                        Method method = args[0].equals("") ? policyBuilder.getClass().getMethod(methodName, new Class[0]) : policyBuilder.getClass().getMethod(methodName, String[].class);
                        Class<?> returnType = method.getReturnType();
                        if (returnType == HtmlPolicyBuilder.class && args[0].equals("")) {
                            policyBuilder = (HtmlPolicyBuilder)method.invoke((Object)policyBuilder, new Object[0]);
                            continue;
                        }
                        if (returnType == HtmlPolicyBuilder.class) {
                            policyBuilder = (HtmlPolicyBuilder)method.invoke((Object)policyBuilder, new Object[]{args});
                            continue;
                        }
                        if (returnType != HtmlPolicyBuilder.AttributeBuilder.class) continue;
                        String tagName = policyJson.getString("name");
                        HtmlPolicyBuilder.AttributeBuilder attrPolicy = (HtmlPolicyBuilder.AttributeBuilder)method.invoke((Object)policyBuilder, new Object[]{args});
                        policyBuilder = attrPolicy.onElements(new String[]{tagName});
                    }
                }
                return policyBuilder.toFactory();
            }
            case "default": {
                String name = policyJson.getString("name");
                if (name.equals("1")) {
                    String defaultJsonPolicy = "[\n\t{\n\t\t\"type\": \"inbuilt\",\n\t\t\"name\": \"blocks, formatting, styles, tables, images\"\n\t},\n\t{\n\t\t\"type\": \"new\",\n\t\t\"allow\": {\n\t\t\t\"dl, dt, dd, hr, pre\": \"\",\n\t\t\t\"font\": \"size, color\",\n\t\t\t\"a\": \"href, target\"\n\t\t},\n\t\t\"methods\": {\n\t\t\t\"allowStandardUrlProtocols\": \"\"\n\t\t}\n\t}\n]";
                    return CustomPolicyBuilder.build(defaultJsonPolicy);
                }
                if (name.equals("2")) {
                    String defaultJsonPolicy = "[\n\t{\n\t\t\"type\": \"inbuilt\",\n\t\t\"name\": \"blocks, formatting, styles, links, tables, images\"\n\t},\n\t{\n\t\t\"type\": \"new\",\n\t\t\"allow\": {\n\t\t\t\"dl, dt, dd, hr, pre\": \"\"\n\t\t}\n\t}\n]";
                    return CustomPolicyBuilder.build(defaultJsonPolicy);
                }
                throw new DefinedException("No such Default policy found");
            }
        }
        return null;
    }

    public static void main(String[] args) {
        String jsonString = "[\n\t{\n\t\t\"type\": \"inbuilt\",\n\t\t\"name\": \"blocks, formatting, blocks, tables, images\"\n\t},\n\t{\n\t\t\"type\": \"new\",\n\t\t\"methods\": {\n\t\t\t\"allowElements\": \"dl, dt, dd, hr, pre\"\n\t\t}\n\t},\n\t{\n\t\t\"type\": \"new\",\n\t\t\"name\": \"font\",\n\t\t\"methods\": {\n\t\t\t\"allowElements\": \"font\",\n\t\t\t\"allowWithoutAttributes\": \"font\",\n\t\t\t\"allowAttributes\": \"size, color\"\n\t\t}\n\t},\n\t{\n\t\t\"type\": \"new\",\n\t\t\"name\": \"a\",\n\t\t\"methods\": {\n\t\t\t\"allowStandardUrlProtocols\": \"\",\n\t\t\t\"allowElements\": \"a\",\n\t\t\t\"allowAttributes\": \"href, target\"\n\t\t}\n\t}\n]";
        String htmlString = "<font color=\"red\" size = \"5\"> hello";
        try {
            PolicyFactory policyFactory = CustomPolicyBuilder.build(jsonString);
            System.out.println(policyFactory.sanitize(htmlString));
        }
        catch (DefinedException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

