/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.formatter;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.markup.MarkupFormatter;
import hudson.markup.MarkupFormatterDescriptor;
import io.jenkins.plugins.formatter.CustomPolicyBuilder;
import io.jenkins.plugins.formatter.DefinedException;
import io.jenkins.plugins.formatter.PolicyConfiguration;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.owasp.html.Handler;
import org.owasp.html.HtmlSanitizer;
import org.owasp.html.HtmlStreamEventReceiver;
import org.owasp.html.HtmlStreamRenderer;
import org.owasp.html.PolicyFactory;

public class CustomMarkupFormatter
extends MarkupFormatter {
    final boolean disableSyntaxHighlighting;
    public static final MarkupFormatter INSTANCE = new CustomMarkupFormatter(false);

    @DataBoundConstructor
    public CustomMarkupFormatter(boolean disableSyntaxHighlighting) {
        this.disableSyntaxHighlighting = disableSyntaxHighlighting;
    }

    public void translate(String s, @NonNull Writer writer) throws IOException {
        HtmlStreamRenderer renderer = HtmlStreamRenderer.create((Appendable)writer, (Handler)Handler.PROPAGATE, x -> {
            throw new Error((String)x);
        });
        PolicyFactory DEFINITION = null;
        String policyDefinition = null;
        PolicyConfiguration config = PolicyConfiguration.get();
        if (config == null) {
            try {
                ExtensionList configs = Jenkins.get().getExtensionList(PolicyConfiguration.class);
                if (!configs.isEmpty()) {
                    config = (PolicyConfiguration)((Object)configs.get(0));
                }
            }
            catch (Exception configs) {
                // empty catch block
            }
        }
        if (config != null) {
            policyDefinition = config.getPolicyDefinition();
        }
        if (policyDefinition != null && !policyDefinition.isEmpty()) {
            try {
                DEFINITION = CustomPolicyBuilder.build(policyDefinition);
                HtmlSanitizer.sanitize((String)s, (HtmlSanitizer.Policy)DEFINITION.apply((HtmlStreamEventReceiver)renderer));
            }
            catch (DefinedException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                DEFINITION = null;
            }
        }
        if (DEFINITION == null) {
            try {
                DEFINITION = CustomPolicyBuilder.build("[\n\t{\n\t\t\"type\": \"inbuilt\",\n\t\t\"name\": \"blocks, formatting, styles, links, tables, images\"\n\t},\n\t{\n\t\t\"type\": \"new\",\n\t\t\"allow\": {\n\t\t\t\"dl, dt, dd, hr, pre\": \"\"\n\t\t}\n\t}\n]");
                HtmlSanitizer.sanitize((String)s, (HtmlSanitizer.Policy)DEFINITION.apply((HtmlStreamEventReceiver)renderer));
            }
            catch (DefinedException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends MarkupFormatterDescriptor {
        public String getDisplayName() {
            return "Customizable HTML Formatter";
        }
    }
}

