/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.foldericon;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.BallColor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.plugins.foldericon.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;

public class BuildStatusFolderIcon
extends FolderIcon {
    private final Set<String> jobs;
    private AbstractFolder<?> owner;

    @DataBoundConstructor
    public BuildStatusFolderIcon(Set<String> jobs) {
        this.jobs = jobs;
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.owner = folder;
    }

    public Set<String> getJobs() {
        return this.jobs;
    }

    public Set<String> getAvailableJobs() {
        return this.getAllJobs().stream().map(job -> job.getRelativeDisplayNameFrom(this.owner)).collect(Collectors.toCollection(TreeSet::new));
    }

    private Collection<? extends Job> getAllJobs() {
        if (this.owner != null) {
            return this.owner.getAllJobs();
        }
        return Set.of();
    }

    private Collection<? extends Job> getConfiguredJobs() {
        Collection<? extends Job> availableJobs = this.getAllJobs();
        Collection<Object> filteredJobs = new HashSet<Job>();
        Set<String> configuredJobs = this.getJobs();
        if (configuredJobs != null) {
            filteredJobs = availableJobs.stream().filter(job -> configuredJobs.contains(job.getRelativeDisplayNameFrom(this.owner))).collect(Collectors.toSet());
        }
        return filteredJobs.isEmpty() ? availableJobs : filteredJobs;
    }

    private BallColor getCombinedBallColor() {
        Collection<? extends Job> configuredJobs = this.getConfiguredJobs();
        Result combinedResult = null;
        boolean buildable = false;
        boolean running = false;
        boolean empty = configuredJobs.isEmpty();
        for (Job job : configuredJobs) {
            if (!job.isBuildable()) continue;
            buildable = true;
            Run build = job.getLastBuild();
            if (build != null && build.isBuilding()) {
                running = true;
                build = build.getPreviousBuild();
            }
            Result result = build != null ? build.getResult() : null;
            combinedResult = Result.combine(combinedResult, (Result)result);
        }
        BallColor color = combinedResult != null ? combinedResult.color : (empty || buildable ? BallColor.NOTBUILT : BallColor.DISABLED);
        return running ? color.anime() : color;
    }

    public String getIconClassName() {
        return "symbol-status-" + this.getCombinedBallColor().getIconName();
    }

    public String getImageOf(String size) {
        return Stapler.getCurrentRequest2().getContextPath() + Jenkins.RESOURCE_PATH + "/images/" + size + "/" + this.getCombinedBallColor().getImage();
    }

    public String getDescription() {
        if (this.owner != null) {
            return this.owner.getPronoun() + " (" + this.getCombinedBallColor().getDescription() + ")";
        }
        return Messages.Folder_description() + " (" + this.getCombinedBallColor().getDescription() + ")";
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BuildStatusFolderIcon_description();
        }
    }
}

