/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.foldericon;

import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.FolderIcon;
import com.cloudbees.hudson.plugins.folder.FolderIconDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import io.jenkins.plugins.fontawesome.FontAwesomeIcons;
import jenkins.model.Jenkins;
import jenkins.plugins.foldericon.Messages;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class FontAwesomeFolderIcon
extends FolderIcon {
    private static final String DEFAULT_ICON = "brands/jenkins";
    private final String fontAwesome;
    private AbstractFolder<?> owner;

    @DataBoundConstructor
    public FontAwesomeFolderIcon(String fontAwesome) {
        this.fontAwesome = StringUtils.isBlank((CharSequence)fontAwesome) ? DEFAULT_ICON : fontAwesome;
    }

    protected void setOwner(AbstractFolder<?> folder) {
        this.owner = folder;
    }

    public String getFontAwesome() {
        return this.fontAwesome;
    }

    public String getImageOf(String size) {
        return null;
    }

    public String getIconClassName() {
        return FontAwesomeIcons.getIconClassName((String)this.getFontAwesome());
    }

    public String getDescription() {
        if (this.owner != null) {
            return this.owner.getPronoun();
        }
        return Messages.Folder_description();
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    @Extension
    public static class DescriptorImpl
    extends FolderIconDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.FontAwesomeFolderIcon_description();
        }
    }
}

