// CHECKSTYLE:OFF

package jenkins.plugins.foldericon;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code Url.invalidUrl}: {@code Only http(s) URLs are allowed.}.
     * 
     * @return
     *     {@code Only http(s) URLs are allowed.}
     */
    public static String Url_invalidUrl() {
        return holder.format("Url.invalidUrl");
    }

    /**
     * Key {@code Url.invalidUrl}: {@code Only http(s) URLs are allowed.}.
     * 
     * @return
     *     {@code Only http(s) URLs are allowed.}
     */
    public static Localizable _Url_invalidUrl() {
        return new Localizable(holder, "Url.invalidUrl");
    }

    /**
     * Key {@code CustomFolderIcon.description}: {@code Custom Folder Icon}.
     * 
     * @return
     *     {@code Custom Folder Icon}
     */
    public static String CustomFolderIcon_description() {
        return holder.format("CustomFolderIcon.description");
    }

    /**
     * Key {@code CustomFolderIcon.description}: {@code Custom Folder Icon}.
     * 
     * @return
     *     {@code Custom Folder Icon}
     */
    public static Localizable _CustomFolderIcon_description() {
        return new Localizable(holder, "CustomFolderIcon.description");
    }

    /**
     * Key {@code IoniconFolderIcon.description}: {@code Ionicon Folder

     * Icon}.
     * 
     * @return
     *     {@code Ionicon Folder Icon}
     */
    public static String IoniconFolderIcon_description() {
        return holder.format("IoniconFolderIcon.description");
    }

    /**
     * Key {@code IoniconFolderIcon.description}: {@code Ionicon Folder

     * Icon}.
     * 
     * @return
     *     {@code Ionicon Folder Icon}
     */
    public static Localizable _IoniconFolderIcon_description() {
        return new Localizable(holder, "IoniconFolderIcon.description");
    }

    /**
     * Key {@code BuildStatusFolderIcon.description}: {@code Build Status

     * Folder Icon}.
     * 
     * @return
     *     {@code Build Status Folder Icon}
     */
    public static String BuildStatusFolderIcon_description() {
        return holder.format("BuildStatusFolderIcon.description");
    }

    /**
     * Key {@code BuildStatusFolderIcon.description}: {@code Build Status

     * Folder Icon}.
     * 
     * @return
     *     {@code Build Status Folder Icon}
     */
    public static Localizable _BuildStatusFolderIcon_description() {
        return new Localizable(holder, "BuildStatusFolderIcon.description");
    }

    /**
     * Key {@code FontAwesomeFolderIcon.description}: {@code FontAwesome

     * Folder Icon}.
     * 
     * @return
     *     {@code FontAwesome Folder Icon}
     */
    public static String FontAwesomeFolderIcon_description() {
        return holder.format("FontAwesomeFolderIcon.description");
    }

    /**
     * Key {@code FontAwesomeFolderIcon.description}: {@code FontAwesome

     * Folder Icon}.
     * 
     * @return
     *     {@code FontAwesome Folder Icon}
     */
    public static Localizable _FontAwesomeFolderIcon_description() {
        return new Localizable(holder, "FontAwesomeFolderIcon.description");
    }

    /**
     * Key {@code Folder.description}: {@code Folder}.
     * 
     * @return
     *     {@code Folder}
     */
    public static String Folder_description() {
        return holder.format("Folder.description");
    }

    /**
     * Key {@code Folder.description}: {@code Folder}.
     * 
     * @return
     *     {@code Folder}
     */
    public static Localizable _Folder_description() {
        return new Localizable(holder, "Folder.description");
    }

    /**
     * Key {@code UrlFolderIcon.description}: {@code URL Folder Icon}.
     * 
     * @return
     *     {@code URL Folder Icon}
     */
    public static String UrlFolderIcon_description() {
        return holder.format("UrlFolderIcon.description");
    }

    /**
     * Key {@code UrlFolderIcon.description}: {@code URL Folder Icon}.
     * 
     * @return
     *     {@code URL Folder Icon}
     */
    public static Localizable _UrlFolderIcon_description() {
        return new Localizable(holder, "UrlFolderIcon.description");
    }

    /**
     * Key {@code OpenSourceFolderIcon.description}: {@code Dev Tools Folder

     * Icon}.
     * 
     * @return
     *     {@code Dev Tools Folder Icon}
     */
    public static String OpenSourceFolderIcon_description() {
        return holder.format("OpenSourceFolderIcon.description");
    }

    /**
     * Key {@code OpenSourceFolderIcon.description}: {@code Dev Tools Folder

     * Icon}.
     * 
     * @return
     *     {@code Dev Tools Folder Icon}
     */
    public static Localizable _OpenSourceFolderIcon_description() {
        return new Localizable(holder, "OpenSourceFolderIcon.description");
    }

    /**
     * Key {@code Upload.exceedsFileSize}: {@code The request was rejected

     * because its size ({0,number} kb) exceeds the allowed maximum

     * ({1,number} kb)!}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code The request was rejected because its size ({0,number} kb)

     *     exceeds the allowed maximum ({1,number} kb)!}
     */
    public static String Upload_exceedsFileSize(Object arg0, Object arg1) {
        return holder.format("Upload.exceedsFileSize", arg0, arg1);
    }

    /**
     * Key {@code Upload.exceedsFileSize}: {@code The request was rejected

     * because its size ({0,number} kb) exceeds the allowed maximum

     * ({1,number} kb)!}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, a number.
     * @param arg0
     *      1st format parameter, {@code {0}}, a number.
     * @return
     *     {@code The request was rejected because its size ({0,number} kb)

     *     exceeds the allowed maximum ({1,number} kb)!}
     */
    public static Localizable _Upload_exceedsFileSize(Object arg0, Object arg1) {
        return new Localizable(holder, "Upload.exceedsFileSize", arg0, arg1);
    }

    /**
     * Key {@code EmojiFolderIcon.description}: {@code Emoji Folder Icon}.
     * 
     * @return
     *     {@code Emoji Folder Icon}
     */
    public static String EmojiFolderIcon_description() {
        return holder.format("EmojiFolderIcon.description");
    }

    /**
     * Key {@code EmojiFolderIcon.description}: {@code Emoji Folder Icon}.
     * 
     * @return
     *     {@code Emoji Folder Icon}
     */
    public static Localizable _EmojiFolderIcon_description() {
        return new Localizable(holder, "EmojiFolderIcon.description");
    }

    /**
     * Key {@code Upload.invalidFile}: {@code The request was rejected

     * because its file is invalid - please select a valid file!}.
     * 
     * @return
     *     {@code The request was rejected because its file is invalid - please

     *     select a valid file!}
     */
    public static String Upload_invalidFile() {
        return holder.format("Upload.invalidFile");
    }

    /**
     * Key {@code Upload.invalidFile}: {@code The request was rejected

     * because its file is invalid - please select a valid file!}.
     * 
     * @return
     *     {@code The request was rejected because its file is invalid - please

     *     select a valid file!}
     */
    public static Localizable _Upload_invalidFile() {
        return new Localizable(holder, "Upload.invalidFile");
    }

}
